/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.knxnetip.readwrite.CEMIPriority;
import org.apache.plc4x.java.knxnetip.readwrite.KnxAddress;
import org.apache.plc4x.java.knxnetip.readwrite.LDataFrame;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class LPollData
extends LDataFrame
implements Message {
    protected final KnxAddress sourceAddress;
    protected final byte[] targetAddress;
    protected final byte numberExpectedPollData;

    @Override
    public Boolean getNotAckFrame() {
        return true;
    }

    @Override
    public Boolean getPolling() {
        return true;
    }

    public LPollData(boolean frameType, boolean notRepeated, CEMIPriority priority, boolean acknowledgeRequested, boolean errorFlag, KnxAddress sourceAddress, byte[] targetAddress, byte numberExpectedPollData) {
        super(frameType, notRepeated, priority, acknowledgeRequested, errorFlag);
        this.sourceAddress = sourceAddress;
        this.targetAddress = targetAddress;
        this.numberExpectedPollData = numberExpectedPollData;
    }

    public KnxAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public byte[] getTargetAddress() {
        return this.targetAddress;
    }

    public byte getNumberExpectedPollData() {
        return this.numberExpectedPollData;
    }

    @Override
    protected void serializeLDataFrameChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("LPollData", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sourceAddress", (Object)this.sourceAddress, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"targetAddress", (byte[])this.targetAddress, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)4), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"numberExpectedPollData", (Object)this.numberExpectedPollData, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)6), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("LPollData", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        LPollData _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.sourceAddress.getLengthInBits();
        if (this.targetAddress != null) {
            lengthInBits += 8 * this.targetAddress.length;
        }
        lengthInBits += 4;
        return lengthInBits += 6;
    }

    public static LDataFrame.LDataFrameBuilder staticParseLDataFrameBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("LPollData", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        KnxAddress sourceAddress = (KnxAddress)FieldReaderFactory.readSimpleField((String)"sourceAddress", (DataReader)DataReaderFactory.readComplex(() -> KnxAddress.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] targetAddress = readBuffer.readByteArray("targetAddress", Math.toIntExact(2L), new WithReaderArgs[0]);
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)4), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        byte numberExpectedPollData = (Byte)FieldReaderFactory.readSimpleField((String)"numberExpectedPollData", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)6), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("LPollData", new WithReaderArgs[0]);
        return new LPollDataBuilderImpl(sourceAddress, targetAddress, numberExpectedPollData);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LPollData)) {
            return false;
        }
        LPollData that = (LPollData)o;
        return this.getSourceAddress() == that.getSourceAddress() && this.getTargetAddress() == that.getTargetAddress() && this.getNumberExpectedPollData() == that.getNumberExpectedPollData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSourceAddress(), this.getTargetAddress(), this.getNumberExpectedPollData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class LPollDataBuilderImpl
    implements LDataFrame.LDataFrameBuilder {
        private final KnxAddress sourceAddress;
        private final byte[] targetAddress;
        private final byte numberExpectedPollData;

        public LPollDataBuilderImpl(KnxAddress sourceAddress, byte[] targetAddress, byte numberExpectedPollData) {
            this.sourceAddress = sourceAddress;
            this.targetAddress = targetAddress;
            this.numberExpectedPollData = numberExpectedPollData;
        }

        @Override
        public LPollData build(boolean frameType, boolean notRepeated, CEMIPriority priority, boolean acknowledgeRequested, boolean errorFlag) {
            LPollData lPollData = new LPollData(frameType, notRepeated, priority, acknowledgeRequested, errorFlag, this.sourceAddress, this.targetAddress, this.numberExpectedPollData);
            return lPollData;
        }
    }
}

