/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum ModbusDeviceInformationConformityLevel {
  BASIC_STREAM_ONLY((short) 0x01),
  REGULAR_STREAM_ONLY((short) 0x02),
  EXTENDED_STREAM_ONLY((short) 0x03);
  private static final Map<Short, ModbusDeviceInformationConformityLevel> map;

  static {
    map = new HashMap<>();
    for (ModbusDeviceInformationConformityLevel value :
        ModbusDeviceInformationConformityLevel.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private short value;

  ModbusDeviceInformationConformityLevel(short value) {
    this.value = value;
  }

  public short getValue() {
    return value;
  }

  public static ModbusDeviceInformationConformityLevel enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
