/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.modbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class ModbusPDU implements Message {

  // Abstract accessors for discriminator values.
  public abstract Boolean getErrorFlag();

  public abstract Short getFunctionFlag();

  public abstract Boolean getResponse();

  public ModbusPDU() {
    super();
  }

  protected abstract void serializeModbusPDUChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("ModbusPDU");

    // Discriminator Field (errorFlag) (Used as input to a switch field)
    writeDiscriminatorField("errorFlag", getErrorFlag(), writeBoolean(writeBuffer));

    // Discriminator Field (functionFlag) (Used as input to a switch field)
    writeDiscriminatorField("functionFlag", getFunctionFlag(), writeUnsignedShort(writeBuffer, 7));

    // Switch field (Serialize the sub-type)
    serializeModbusPDUChild(writeBuffer);

    writeBuffer.popContext("ModbusPDU");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    ModbusPDU _value = this;

    // Discriminator Field (errorFlag)
    lengthInBits += 1;

    // Discriminator Field (functionFlag)
    lengthInBits += 7;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static ModbusPDU staticParse(ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 1)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 1, but got " + args.length);
    }
    Boolean response;
    if (args[0] instanceof Boolean) {
      response = (Boolean) args[0];
    } else if (args[0] instanceof String) {
      response = Boolean.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type Boolean or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    return staticParse(readBuffer, response);
  }

  public static ModbusPDU staticParse(ReadBuffer readBuffer, Boolean response)
      throws ParseException {
    readBuffer.pullContext("ModbusPDU");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    boolean errorFlag = readDiscriminatorField("errorFlag", readBoolean(readBuffer));

    short functionFlag = readDiscriminatorField("functionFlag", readUnsignedShort(readBuffer, 7));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    ModbusPDUBuilder builder = null;
    if (EvaluationHelper.equals(errorFlag, (boolean) true)) {
      builder = ModbusPDUError.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x02)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUReadDiscreteInputsRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x02)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUReadDiscreteInputsResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x01)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUReadCoilsRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x01)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUReadCoilsResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x05)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUWriteSingleCoilRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x05)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUWriteSingleCoilResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x0F)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUWriteMultipleCoilsRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x0F)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUWriteMultipleCoilsResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x04)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUReadInputRegistersRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x04)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUReadInputRegistersResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x03)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUReadHoldingRegistersRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x03)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUReadHoldingRegistersResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x06)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUWriteSingleRegisterRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x06)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUWriteSingleRegisterResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x10)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder =
          ModbusPDUWriteMultipleHoldingRegistersRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x10)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder =
          ModbusPDUWriteMultipleHoldingRegistersResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x17)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder =
          ModbusPDUReadWriteMultipleHoldingRegistersRequest.staticParseBuilder(
              readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x17)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder =
          ModbusPDUReadWriteMultipleHoldingRegistersResponse.staticParseBuilder(
              readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x16)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUMaskWriteHoldingRegisterRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x16)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUMaskWriteHoldingRegisterResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x18)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUReadFifoQueueRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x18)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUReadFifoQueueResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x14)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUReadFileRecordRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x14)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUReadFileRecordResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x15)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUWriteFileRecordRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x15)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUWriteFileRecordResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x07)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUReadExceptionStatusRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x07)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUReadExceptionStatusResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x08)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUDiagnosticRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x08)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUDiagnosticResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x0B)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUGetComEventCounterRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x0B)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUGetComEventCounterResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x0C)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUGetComEventLogRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x0C)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUGetComEventLogResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x11)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUReportServerIdRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x11)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUReportServerIdResponse.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x2B)
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = ModbusPDUReadDeviceIdentificationRequest.staticParseBuilder(readBuffer, response);
    } else if (EvaluationHelper.equals(errorFlag, (boolean) false)
        && EvaluationHelper.equals(functionFlag, (short) 0x2B)
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = ModbusPDUReadDeviceIdentificationResponse.staticParseBuilder(readBuffer, response);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "errorFlag="
              + errorFlag
              + " "
              + "functionFlag="
              + functionFlag
              + " "
              + "response="
              + response
              + "]");
    }

    readBuffer.closeContext("ModbusPDU");
    // Create the instance
    ModbusPDU _modbusPDU = builder.build();
    return _modbusPDU;
  }

  public static interface ModbusPDUBuilder {
    ModbusPDU build();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ModbusPDU)) {
      return false;
    }
    ModbusPDU that = (ModbusPDU) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
