/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.modbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ModbusPDUDiagnosticRequest extends ModbusPDU implements Message {

  // Accessors for discriminator values.
  public Boolean getErrorFlag() {
    return (boolean) false;
  }

  public Short getFunctionFlag() {
    return (short) 0x08;
  }

  public Boolean getResponse() {
    return (boolean) false;
  }

  // Properties.
  protected final int subFunction;
  protected final int data;

  public ModbusPDUDiagnosticRequest(int subFunction, int data) {
    super();
    this.subFunction = subFunction;
    this.data = data;
  }

  public int getSubFunction() {
    return subFunction;
  }

  public int getData() {
    return data;
  }

  @Override
  protected void serializeModbusPDUChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("ModbusPDUDiagnosticRequest");

    // Simple Field (subFunction)
    writeSimpleField("subFunction", subFunction, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (data)
    writeSimpleField("data", data, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("ModbusPDUDiagnosticRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ModbusPDUDiagnosticRequest _value = this;

    // Simple field (subFunction)
    lengthInBits += 16;

    // Simple field (data)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static ModbusPDUDiagnosticRequestBuilder staticParseBuilder(
      ReadBuffer readBuffer, Boolean response) throws ParseException {
    readBuffer.pullContext("ModbusPDUDiagnosticRequest");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    int subFunction = readSimpleField("subFunction", readUnsignedInt(readBuffer, 16));

    int data = readSimpleField("data", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("ModbusPDUDiagnosticRequest");
    // Create the instance
    return new ModbusPDUDiagnosticRequestBuilder(subFunction, data);
  }

  public static class ModbusPDUDiagnosticRequestBuilder implements ModbusPDU.ModbusPDUBuilder {
    private final int subFunction;
    private final int data;

    public ModbusPDUDiagnosticRequestBuilder(int subFunction, int data) {

      this.subFunction = subFunction;
      this.data = data;
    }

    public ModbusPDUDiagnosticRequest build() {
      ModbusPDUDiagnosticRequest modbusPDUDiagnosticRequest =
          new ModbusPDUDiagnosticRequest(subFunction, data);
      return modbusPDUDiagnosticRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ModbusPDUDiagnosticRequest)) {
      return false;
    }
    ModbusPDUDiagnosticRequest that = (ModbusPDUDiagnosticRequest) o;
    return (getSubFunction() == that.getSubFunction())
        && (getData() == that.getData())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getSubFunction(), getData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
