/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.modbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ModbusPDUError extends ModbusPDU implements Message {

  // Accessors for discriminator values.
  public Boolean getErrorFlag() {
    return (boolean) true;
  }

  public Short getFunctionFlag() {
    return 0;
  }

  public Boolean getResponse() {
    return false;
  }

  // Properties.
  protected final ModbusErrorCode exceptionCode;

  public ModbusPDUError(ModbusErrorCode exceptionCode) {
    super();
    this.exceptionCode = exceptionCode;
  }

  public ModbusErrorCode getExceptionCode() {
    return exceptionCode;
  }

  @Override
  protected void serializeModbusPDUChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("ModbusPDUError");

    // Simple Field (exceptionCode)
    writeSimpleEnumField(
        "exceptionCode",
        "ModbusErrorCode",
        exceptionCode,
        new DataWriterEnumDefault<>(
            ModbusErrorCode::getValue, ModbusErrorCode::name, writeUnsignedShort(writeBuffer, 8)));

    writeBuffer.popContext("ModbusPDUError");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ModbusPDUError _value = this;

    // Simple field (exceptionCode)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static ModbusPDUErrorBuilder staticParseBuilder(ReadBuffer readBuffer, Boolean response)
      throws ParseException {
    readBuffer.pullContext("ModbusPDUError");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    ModbusErrorCode exceptionCode =
        readEnumField(
            "exceptionCode",
            "ModbusErrorCode",
            new DataReaderEnumDefault<>(
                ModbusErrorCode::enumForValue, readUnsignedShort(readBuffer, 8)));

    readBuffer.closeContext("ModbusPDUError");
    // Create the instance
    return new ModbusPDUErrorBuilder(exceptionCode);
  }

  public static class ModbusPDUErrorBuilder implements ModbusPDU.ModbusPDUBuilder {
    private final ModbusErrorCode exceptionCode;

    public ModbusPDUErrorBuilder(ModbusErrorCode exceptionCode) {

      this.exceptionCode = exceptionCode;
    }

    public ModbusPDUError build() {
      ModbusPDUError modbusPDUError = new ModbusPDUError(exceptionCode);
      return modbusPDUError;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ModbusPDUError)) {
      return false;
    }
    ModbusPDUError that = (ModbusPDUError) o;
    return (getExceptionCode() == that.getExceptionCode()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getExceptionCode());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
