/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.modbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ModbusPDUGetComEventCounterResponse extends ModbusPDU implements Message {

  // Accessors for discriminator values.
  public Boolean getErrorFlag() {
    return (boolean) false;
  }

  public Short getFunctionFlag() {
    return (short) 0x0B;
  }

  public Boolean getResponse() {
    return (boolean) true;
  }

  // Properties.
  protected final int status;
  protected final int eventCount;

  public ModbusPDUGetComEventCounterResponse(int status, int eventCount) {
    super();
    this.status = status;
    this.eventCount = eventCount;
  }

  public int getStatus() {
    return status;
  }

  public int getEventCount() {
    return eventCount;
  }

  @Override
  protected void serializeModbusPDUChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("ModbusPDUGetComEventCounterResponse");

    // Simple Field (status)
    writeSimpleField("status", status, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (eventCount)
    writeSimpleField("eventCount", eventCount, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("ModbusPDUGetComEventCounterResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ModbusPDUGetComEventCounterResponse _value = this;

    // Simple field (status)
    lengthInBits += 16;

    // Simple field (eventCount)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static ModbusPDUGetComEventCounterResponseBuilder staticParseBuilder(
      ReadBuffer readBuffer, Boolean response) throws ParseException {
    readBuffer.pullContext("ModbusPDUGetComEventCounterResponse");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    int status = readSimpleField("status", readUnsignedInt(readBuffer, 16));

    int eventCount = readSimpleField("eventCount", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("ModbusPDUGetComEventCounterResponse");
    // Create the instance
    return new ModbusPDUGetComEventCounterResponseBuilder(status, eventCount);
  }

  public static class ModbusPDUGetComEventCounterResponseBuilder
      implements ModbusPDU.ModbusPDUBuilder {
    private final int status;
    private final int eventCount;

    public ModbusPDUGetComEventCounterResponseBuilder(int status, int eventCount) {

      this.status = status;
      this.eventCount = eventCount;
    }

    public ModbusPDUGetComEventCounterResponse build() {
      ModbusPDUGetComEventCounterResponse modbusPDUGetComEventCounterResponse =
          new ModbusPDUGetComEventCounterResponse(status, eventCount);
      return modbusPDUGetComEventCounterResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ModbusPDUGetComEventCounterResponse)) {
      return false;
    }
    ModbusPDUGetComEventCounterResponse that = (ModbusPDUGetComEventCounterResponse) o;
    return (getStatus() == that.getStatus())
        && (getEventCount() == that.getEventCount())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getStatus(), getEventCount());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
