/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.modbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ModbusPDUMaskWriteHoldingRegisterRequest extends ModbusPDU implements Message {

  // Accessors for discriminator values.
  public Boolean getErrorFlag() {
    return (boolean) false;
  }

  public Short getFunctionFlag() {
    return (short) 0x16;
  }

  public Boolean getResponse() {
    return (boolean) false;
  }

  // Properties.
  protected final int referenceAddress;
  protected final int andMask;
  protected final int orMask;

  public ModbusPDUMaskWriteHoldingRegisterRequest(int referenceAddress, int andMask, int orMask) {
    super();
    this.referenceAddress = referenceAddress;
    this.andMask = andMask;
    this.orMask = orMask;
  }

  public int getReferenceAddress() {
    return referenceAddress;
  }

  public int getAndMask() {
    return andMask;
  }

  public int getOrMask() {
    return orMask;
  }

  @Override
  protected void serializeModbusPDUChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("ModbusPDUMaskWriteHoldingRegisterRequest");

    // Simple Field (referenceAddress)
    writeSimpleField("referenceAddress", referenceAddress, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (andMask)
    writeSimpleField("andMask", andMask, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (orMask)
    writeSimpleField("orMask", orMask, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("ModbusPDUMaskWriteHoldingRegisterRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ModbusPDUMaskWriteHoldingRegisterRequest _value = this;

    // Simple field (referenceAddress)
    lengthInBits += 16;

    // Simple field (andMask)
    lengthInBits += 16;

    // Simple field (orMask)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static ModbusPDUMaskWriteHoldingRegisterRequestBuilder staticParseBuilder(
      ReadBuffer readBuffer, Boolean response) throws ParseException {
    readBuffer.pullContext("ModbusPDUMaskWriteHoldingRegisterRequest");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    int referenceAddress = readSimpleField("referenceAddress", readUnsignedInt(readBuffer, 16));

    int andMask = readSimpleField("andMask", readUnsignedInt(readBuffer, 16));

    int orMask = readSimpleField("orMask", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("ModbusPDUMaskWriteHoldingRegisterRequest");
    // Create the instance
    return new ModbusPDUMaskWriteHoldingRegisterRequestBuilder(referenceAddress, andMask, orMask);
  }

  public static class ModbusPDUMaskWriteHoldingRegisterRequestBuilder
      implements ModbusPDU.ModbusPDUBuilder {
    private final int referenceAddress;
    private final int andMask;
    private final int orMask;

    public ModbusPDUMaskWriteHoldingRegisterRequestBuilder(
        int referenceAddress, int andMask, int orMask) {

      this.referenceAddress = referenceAddress;
      this.andMask = andMask;
      this.orMask = orMask;
    }

    public ModbusPDUMaskWriteHoldingRegisterRequest build() {
      ModbusPDUMaskWriteHoldingRegisterRequest modbusPDUMaskWriteHoldingRegisterRequest =
          new ModbusPDUMaskWriteHoldingRegisterRequest(referenceAddress, andMask, orMask);
      return modbusPDUMaskWriteHoldingRegisterRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ModbusPDUMaskWriteHoldingRegisterRequest)) {
      return false;
    }
    ModbusPDUMaskWriteHoldingRegisterRequest that = (ModbusPDUMaskWriteHoldingRegisterRequest) o;
    return (getReferenceAddress() == that.getReferenceAddress())
        && (getAndMask() == that.getAndMask())
        && (getOrMask() == that.getOrMask())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getReferenceAddress(), getAndMask(), getOrMask());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
