/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.modbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ModbusPDUMaskWriteHoldingRegisterResponse extends ModbusPDU implements Message {

  // Accessors for discriminator values.
  public Boolean getErrorFlag() {
    return (boolean) false;
  }

  public Short getFunctionFlag() {
    return (short) 0x16;
  }

  public Boolean getResponse() {
    return (boolean) true;
  }

  // Properties.
  protected final int referenceAddress;
  protected final int andMask;
  protected final int orMask;

  public ModbusPDUMaskWriteHoldingRegisterResponse(int referenceAddress, int andMask, int orMask) {
    super();
    this.referenceAddress = referenceAddress;
    this.andMask = andMask;
    this.orMask = orMask;
  }

  public int getReferenceAddress() {
    return referenceAddress;
  }

  public int getAndMask() {
    return andMask;
  }

  public int getOrMask() {
    return orMask;
  }

  @Override
  protected void serializeModbusPDUChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("ModbusPDUMaskWriteHoldingRegisterResponse");

    // Simple Field (referenceAddress)
    writeSimpleField("referenceAddress", referenceAddress, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (andMask)
    writeSimpleField("andMask", andMask, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (orMask)
    writeSimpleField("orMask", orMask, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("ModbusPDUMaskWriteHoldingRegisterResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ModbusPDUMaskWriteHoldingRegisterResponse _value = this;

    // Simple field (referenceAddress)
    lengthInBits += 16;

    // Simple field (andMask)
    lengthInBits += 16;

    // Simple field (orMask)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static ModbusPDUMaskWriteHoldingRegisterResponseBuilder staticParseBuilder(
      ReadBuffer readBuffer, Boolean response) throws ParseException {
    readBuffer.pullContext("ModbusPDUMaskWriteHoldingRegisterResponse");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    int referenceAddress = readSimpleField("referenceAddress", readUnsignedInt(readBuffer, 16));

    int andMask = readSimpleField("andMask", readUnsignedInt(readBuffer, 16));

    int orMask = readSimpleField("orMask", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("ModbusPDUMaskWriteHoldingRegisterResponse");
    // Create the instance
    return new ModbusPDUMaskWriteHoldingRegisterResponseBuilder(referenceAddress, andMask, orMask);
  }

  public static class ModbusPDUMaskWriteHoldingRegisterResponseBuilder
      implements ModbusPDU.ModbusPDUBuilder {
    private final int referenceAddress;
    private final int andMask;
    private final int orMask;

    public ModbusPDUMaskWriteHoldingRegisterResponseBuilder(
        int referenceAddress, int andMask, int orMask) {

      this.referenceAddress = referenceAddress;
      this.andMask = andMask;
      this.orMask = orMask;
    }

    public ModbusPDUMaskWriteHoldingRegisterResponse build() {
      ModbusPDUMaskWriteHoldingRegisterResponse modbusPDUMaskWriteHoldingRegisterResponse =
          new ModbusPDUMaskWriteHoldingRegisterResponse(referenceAddress, andMask, orMask);
      return modbusPDUMaskWriteHoldingRegisterResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ModbusPDUMaskWriteHoldingRegisterResponse)) {
      return false;
    }
    ModbusPDUMaskWriteHoldingRegisterResponse that = (ModbusPDUMaskWriteHoldingRegisterResponse) o;
    return (getReferenceAddress() == that.getReferenceAddress())
        && (getAndMask() == that.getAndMask())
        && (getOrMask() == that.getOrMask())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getReferenceAddress(), getAndMask(), getOrMask());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
