/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.modbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ModbusPDUReadExceptionStatusResponse extends ModbusPDU implements Message {

  // Accessors for discriminator values.
  public Boolean getErrorFlag() {
    return (boolean) false;
  }

  public Short getFunctionFlag() {
    return (short) 0x07;
  }

  public Boolean getResponse() {
    return (boolean) true;
  }

  // Properties.
  protected final short value;

  public ModbusPDUReadExceptionStatusResponse(short value) {
    super();
    this.value = value;
  }

  public short getValue() {
    return value;
  }

  @Override
  protected void serializeModbusPDUChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("ModbusPDUReadExceptionStatusResponse");

    // Simple Field (value)
    writeSimpleField("value", value, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("ModbusPDUReadExceptionStatusResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ModbusPDUReadExceptionStatusResponse _value = this;

    // Simple field (value)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static ModbusPDUReadExceptionStatusResponseBuilder staticParseBuilder(
      ReadBuffer readBuffer, Boolean response) throws ParseException {
    readBuffer.pullContext("ModbusPDUReadExceptionStatusResponse");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));

    readBuffer.closeContext("ModbusPDUReadExceptionStatusResponse");
    // Create the instance
    return new ModbusPDUReadExceptionStatusResponseBuilder(value);
  }

  public static class ModbusPDUReadExceptionStatusResponseBuilder
      implements ModbusPDU.ModbusPDUBuilder {
    private final short value;

    public ModbusPDUReadExceptionStatusResponseBuilder(short value) {

      this.value = value;
    }

    public ModbusPDUReadExceptionStatusResponse build() {
      ModbusPDUReadExceptionStatusResponse modbusPDUReadExceptionStatusResponse =
          new ModbusPDUReadExceptionStatusResponse(value);
      return modbusPDUReadExceptionStatusResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ModbusPDUReadExceptionStatusResponse)) {
      return false;
    }
    ModbusPDUReadExceptionStatusResponse that = (ModbusPDUReadExceptionStatusResponse) o;
    return (getValue() == that.getValue()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
