/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.modbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ModbusPDUReadFileRecordRequestItem implements Message {

  // Properties.
  protected final short referenceType;
  protected final int fileNumber;
  protected final int recordNumber;
  protected final int recordLength;

  public ModbusPDUReadFileRecordRequestItem(
      short referenceType, int fileNumber, int recordNumber, int recordLength) {
    super();
    this.referenceType = referenceType;
    this.fileNumber = fileNumber;
    this.recordNumber = recordNumber;
    this.recordLength = recordLength;
  }

  public short getReferenceType() {
    return referenceType;
  }

  public int getFileNumber() {
    return fileNumber;
  }

  public int getRecordNumber() {
    return recordNumber;
  }

  public int getRecordLength() {
    return recordLength;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("ModbusPDUReadFileRecordRequestItem");

    // Simple Field (referenceType)
    writeSimpleField("referenceType", referenceType, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (fileNumber)
    writeSimpleField("fileNumber", fileNumber, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (recordNumber)
    writeSimpleField("recordNumber", recordNumber, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (recordLength)
    writeSimpleField("recordLength", recordLength, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("ModbusPDUReadFileRecordRequestItem");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    ModbusPDUReadFileRecordRequestItem _value = this;

    // Simple field (referenceType)
    lengthInBits += 8;

    // Simple field (fileNumber)
    lengthInBits += 16;

    // Simple field (recordNumber)
    lengthInBits += 16;

    // Simple field (recordLength)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static ModbusPDUReadFileRecordRequestItem staticParse(
      ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static ModbusPDUReadFileRecordRequestItem staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("ModbusPDUReadFileRecordRequestItem");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    short referenceType = readSimpleField("referenceType", readUnsignedShort(readBuffer, 8));

    int fileNumber = readSimpleField("fileNumber", readUnsignedInt(readBuffer, 16));

    int recordNumber = readSimpleField("recordNumber", readUnsignedInt(readBuffer, 16));

    int recordLength = readSimpleField("recordLength", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("ModbusPDUReadFileRecordRequestItem");
    // Create the instance
    ModbusPDUReadFileRecordRequestItem _modbusPDUReadFileRecordRequestItem;
    _modbusPDUReadFileRecordRequestItem =
        new ModbusPDUReadFileRecordRequestItem(
            referenceType, fileNumber, recordNumber, recordLength);
    return _modbusPDUReadFileRecordRequestItem;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ModbusPDUReadFileRecordRequestItem)) {
      return false;
    }
    ModbusPDUReadFileRecordRequestItem that = (ModbusPDUReadFileRecordRequestItem) o;
    return (getReferenceType() == that.getReferenceType())
        && (getFileNumber() == that.getFileNumber())
        && (getRecordNumber() == that.getRecordNumber())
        && (getRecordLength() == that.getRecordLength())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getReferenceType(), getFileNumber(), getRecordNumber(), getRecordLength());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
