/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.modbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ModbusPDUWriteMultipleHoldingRegistersRequest extends ModbusPDU implements Message {

  // Accessors for discriminator values.
  public Boolean getErrorFlag() {
    return (boolean) false;
  }

  public Short getFunctionFlag() {
    return (short) 0x10;
  }

  public Boolean getResponse() {
    return (boolean) false;
  }

  // Properties.
  protected final int startingAddress;
  protected final int quantity;
  protected final byte[] value;

  public ModbusPDUWriteMultipleHoldingRegistersRequest(
      int startingAddress, int quantity, byte[] value) {
    super();
    this.startingAddress = startingAddress;
    this.quantity = quantity;
    this.value = value;
  }

  public int getStartingAddress() {
    return startingAddress;
  }

  public int getQuantity() {
    return quantity;
  }

  public byte[] getValue() {
    return value;
  }

  @Override
  protected void serializeModbusPDUChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("ModbusPDUWriteMultipleHoldingRegistersRequest");

    // Simple Field (startingAddress)
    writeSimpleField("startingAddress", startingAddress, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (quantity)
    writeSimpleField("quantity", quantity, writeUnsignedInt(writeBuffer, 16));

    // Implicit Field (byteCount) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    short byteCount = (short) (COUNT(getValue()));
    writeImplicitField("byteCount", byteCount, writeUnsignedShort(writeBuffer, 8));

    // Array Field (value)
    writeByteArrayField("value", value, writeByteArray(writeBuffer, 8));

    writeBuffer.popContext("ModbusPDUWriteMultipleHoldingRegistersRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ModbusPDUWriteMultipleHoldingRegistersRequest _value = this;

    // Simple field (startingAddress)
    lengthInBits += 16;

    // Simple field (quantity)
    lengthInBits += 16;

    // Implicit Field (byteCount)
    lengthInBits += 8;

    // Array field
    if (value != null) {
      lengthInBits += 8 * value.length;
    }

    return lengthInBits;
  }

  public static ModbusPDUWriteMultipleHoldingRegistersRequestBuilder staticParseBuilder(
      ReadBuffer readBuffer, Boolean response) throws ParseException {
    readBuffer.pullContext("ModbusPDUWriteMultipleHoldingRegistersRequest");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    int startingAddress = readSimpleField("startingAddress", readUnsignedInt(readBuffer, 16));

    int quantity = readSimpleField("quantity", readUnsignedInt(readBuffer, 16));

    short byteCount = readImplicitField("byteCount", readUnsignedShort(readBuffer, 8));

    byte[] value = readBuffer.readByteArray("value", Math.toIntExact(byteCount));

    readBuffer.closeContext("ModbusPDUWriteMultipleHoldingRegistersRequest");
    // Create the instance
    return new ModbusPDUWriteMultipleHoldingRegistersRequestBuilder(
        startingAddress, quantity, value);
  }

  public static class ModbusPDUWriteMultipleHoldingRegistersRequestBuilder
      implements ModbusPDU.ModbusPDUBuilder {
    private final int startingAddress;
    private final int quantity;
    private final byte[] value;

    public ModbusPDUWriteMultipleHoldingRegistersRequestBuilder(
        int startingAddress, int quantity, byte[] value) {

      this.startingAddress = startingAddress;
      this.quantity = quantity;
      this.value = value;
    }

    public ModbusPDUWriteMultipleHoldingRegistersRequest build() {
      ModbusPDUWriteMultipleHoldingRegistersRequest modbusPDUWriteMultipleHoldingRegistersRequest =
          new ModbusPDUWriteMultipleHoldingRegistersRequest(startingAddress, quantity, value);
      return modbusPDUWriteMultipleHoldingRegistersRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ModbusPDUWriteMultipleHoldingRegistersRequest)) {
      return false;
    }
    ModbusPDUWriteMultipleHoldingRegistersRequest that =
        (ModbusPDUWriteMultipleHoldingRegistersRequest) o;
    return (getStartingAddress() == that.getStartingAddress())
        && (getQuantity() == that.getQuantity())
        && (getValue() == that.getValue())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getStartingAddress(), getQuantity(), getValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
