/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.base.field;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.modbus.base.field.ModbusExtendedRegister;
import org.apache.plc4x.java.modbus.base.field.ModbusFieldCoil;
import org.apache.plc4x.java.modbus.base.field.ModbusFieldDiscreteInput;
import org.apache.plc4x.java.modbus.base.field.ModbusFieldHoldingRegister;
import org.apache.plc4x.java.modbus.base.field.ModbusFieldInputRegister;
import org.apache.plc4x.java.modbus.readwrite.ModbusDataType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class ModbusField
implements PlcField,
Serializable {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("(?<address>\\d+)(:(?<datatype>[a-zA-Z_]+))?(\\[(?<quantity>\\d+)])?");
    public static final Pattern FIXED_DIGIT_MODBUS_PATTERN = Pattern.compile("(?<address>\\d{4,5})?(:(?<datatype>[a-zA-Z_]+))?(\\[(?<quantity>\\d+)])?");
    protected static final int PROTOCOL_ADDRESS_OFFSET = 1;
    private final int address;
    private final int quantity;
    private final ModbusDataType dataType;

    public static ModbusField of(String addressString) {
        if (ModbusFieldCoil.matches(addressString)) {
            return ModbusFieldCoil.of(addressString);
        }
        if (ModbusFieldDiscreteInput.matches(addressString)) {
            return ModbusFieldDiscreteInput.of(addressString);
        }
        if (ModbusFieldHoldingRegister.matches(addressString)) {
            return ModbusFieldHoldingRegister.of(addressString);
        }
        if (ModbusFieldInputRegister.matches(addressString)) {
            return ModbusFieldInputRegister.of(addressString);
        }
        if (ModbusExtendedRegister.matches(addressString)) {
            return ModbusExtendedRegister.of(addressString);
        }
        throw new PlcInvalidFieldException("Unable to parse address: " + addressString);
    }

    protected ModbusField(int address, Integer quantity, ModbusDataType dataType) {
        this.address = address;
        if (this.address + 1 <= 0) {
            throw new IllegalArgumentException("address must be greater than zero. Was " + (this.address + 1));
        }
        int n = this.quantity = quantity != null ? quantity : 1;
        if (this.quantity <= 0) {
            throw new IllegalArgumentException("quantity must be greater than zero. Was " + this.quantity);
        }
        this.dataType = dataType != null ? dataType : ModbusDataType.INT;
    }

    public int getAddress() {
        return this.address;
    }

    public int getNumberOfElements() {
        return this.quantity;
    }

    public int getLengthBytes() {
        return this.quantity * this.dataType.getDataTypeSize();
    }

    @JsonIgnore
    public int getLengthWords() {
        return (int)((float)this.quantity * (float)this.dataType.getDataTypeSize() / 2.0f);
    }

    public ModbusDataType getDataType() {
        return this.dataType;
    }

    public String getPlcDataType() {
        return this.dataType.name();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusField)) {
            return false;
        }
        ModbusField that = (ModbusField)o;
        return this.address == that.address;
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public String toString() {
        return "ModbusField{address=" + this.address + "datatype=" + (Object)((Object)this.dataType) + "quantity=" + this.quantity + '}';
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt("address", 16, this.address, new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt("numberOfElements", 16, this.getNumberOfElements(), new WithWriterArgs[0]);
        String dataType = this.getPlcDataType();
        writeBuffer.writeString("dataType", dataType.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), dataType, new WithWriterArgs[0]);
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

