/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.base.field;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.modbus.base.field.ModbusField;
import org.apache.plc4x.java.modbus.readwrite.ModbusDataType;

public class ModbusFieldCoil
extends ModbusField {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("coil:" + ModbusField.ADDRESS_PATTERN);
    public static final Pattern ADDRESS_SHORTER_PATTERN = Pattern.compile("0" + ModbusField.FIXED_DIGIT_MODBUS_PATTERN);
    public static final Pattern ADDRESS_SHORT_PATTERN = Pattern.compile("0x" + ModbusField.FIXED_DIGIT_MODBUS_PATTERN);
    protected static final int REGISTER_MAXADDRESS = 65535;

    public ModbusFieldCoil(int address, Integer quantity, ModbusDataType dataType) {
        super(address, quantity, dataType);
    }

    public static boolean matches(String addressString) {
        return ADDRESS_PATTERN.matcher(addressString).matches() || ADDRESS_SHORTER_PATTERN.matcher(addressString).matches() || ADDRESS_SHORT_PATTERN.matcher(addressString).matches();
    }

    public static Matcher getMatcher(String addressString) {
        Matcher matcher = ADDRESS_PATTERN.matcher(addressString);
        if (matcher.matches()) {
            return matcher;
        }
        matcher = ADDRESS_SHORT_PATTERN.matcher(addressString);
        if (matcher.matches()) {
            return matcher;
        }
        matcher = ADDRESS_SHORTER_PATTERN.matcher(addressString);
        if (matcher.matches()) {
            return matcher;
        }
        throw new PlcInvalidFieldException(addressString, ADDRESS_PATTERN);
    }

    public static ModbusFieldCoil of(String addressString) {
        int quantity;
        Matcher matcher = ModbusFieldCoil.getMatcher(addressString);
        int address = Integer.parseInt(matcher.group("address")) - 1;
        if (address > 65535) {
            throw new IllegalArgumentException("Address must be less than or equal to 65535. Was " + (address + 1));
        }
        String quantityString = matcher.group("quantity");
        int n = quantity = quantityString != null ? Integer.parseInt(quantityString) : 1;
        if (address + quantity > 65535) {
            throw new IllegalArgumentException("Last requested address is out of range, should be between 1 and 65535. Was " + (address + 1 + (quantity - 1)));
        }
        ModbusDataType dataType = matcher.group("datatype") != null ? ModbusDataType.valueOf(matcher.group("datatype")) : ModbusDataType.BOOL;
        return new ModbusFieldCoil(address, quantity, dataType);
    }
}

