/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusADU;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ModbusAsciiADU
extends ModbusADU
implements Message {
    protected final short address;
    protected final ModbusPDU pdu;
    protected final Boolean response;

    @Override
    public DriverType getDriverType() {
        return DriverType.MODBUS_ASCII;
    }

    public ModbusAsciiADU(short address, ModbusPDU pdu, Boolean response) {
        super(response);
        this.address = address;
        this.pdu = pdu;
        this.response = response;
    }

    public short getAddress() {
        return this.address;
    }

    public ModbusPDU getPdu() {
        return this.pdu;
    }

    @Override
    protected void serializeModbusADUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("ModbusAsciiADU", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"address", (Object)this.address, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleField((String)"pdu", (Object)this.pdu, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeChecksumField((String)"crc", (Object)StaticHelper.asciiLrcCheck(this.address, this.pdu), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ModbusAsciiADU", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ModbusAsciiADU _value = this;
        lengthInBits += 8;
        lengthInBits += this.pdu.getLengthInBits();
        return lengthInBits += 8;
    }

    public static ModbusAsciiADUBuilder staticParseBuilder(ReadBuffer readBuffer, DriverType driverType, Boolean response) throws ParseException {
        readBuffer.pullContext("ModbusAsciiADU", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        short address = (Short)FieldReaderFactory.readSimpleField((String)"address", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        ModbusPDU pdu = (ModbusPDU)FieldReaderFactory.readSimpleField((String)"pdu", (DataReader)new DataReaderComplexDefault(() -> ModbusPDU.staticParse(readBuffer, (boolean)response), readBuffer), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        short crc = (Short)FieldReaderFactory.readChecksumField((String)"crc", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (Object)StaticHelper.asciiLrcCheck(address, pdu), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        readBuffer.closeContext("ModbusAsciiADU", new WithReaderArgs[0]);
        return new ModbusAsciiADUBuilder(address, pdu, response);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusAsciiADU)) {
            return false;
        }
        ModbusAsciiADU that = (ModbusAsciiADU)o;
        return this.getAddress() == that.getAddress() && this.getPdu() == that.getPdu() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAddress(), this.getPdu());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ModbusAsciiADUBuilder
    implements ModbusADU.ModbusADUBuilder {
        private final short address;
        private final ModbusPDU pdu;
        private final Boolean response;

        public ModbusAsciiADUBuilder(short address, ModbusPDU pdu, Boolean response) {
            this.address = address;
            this.pdu = pdu;
            this.response = response;
        }

        @Override
        public ModbusAsciiADU build(Boolean response) {
            ModbusAsciiADU modbusAsciiADU = new ModbusAsciiADU(this.address, this.pdu, response);
            return modbusAsciiADU;
        }
    }
}

