/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum ModbusDataType {
    BOOL(1, 2),
    BYTE(2, 2),
    WORD(3, 2),
    DWORD(4, 4),
    LWORD(5, 8),
    SINT(6, 2),
    INT(7, 2),
    DINT(8, 4),
    LINT(9, 8),
    USINT(10, 2),
    UINT(11, 2),
    UDINT(12, 4),
    ULINT(13, 8),
    REAL(14, 4),
    LREAL(15, 8),
    TIME(16, 8),
    LTIME(17, 8),
    DATE(18, 8),
    LDATE(19, 8),
    TIME_OF_DAY(20, 8),
    LTIME_OF_DAY(21, 8),
    DATE_AND_TIME(22, 8),
    LDATE_AND_TIME(23, 8),
    CHAR(24, 1),
    WCHAR(25, 2),
    STRING(26, 1),
    WSTRING(27, 2);

    private static final Map<Short, ModbusDataType> map;
    private short value;
    private short dataTypeSize;

    private ModbusDataType(short value, short dataTypeSize) {
        this.value = value;
        this.dataTypeSize = dataTypeSize;
    }

    public short getValue() {
        return this.value;
    }

    public short getDataTypeSize() {
        return this.dataTypeSize;
    }

    public static ModbusDataType firstEnumForFieldDataTypeSize(short fieldValue) {
        for (ModbusDataType _val : ModbusDataType.values()) {
            if (_val.getDataTypeSize() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<ModbusDataType> enumsForFieldDataTypeSize(short fieldValue) {
        ArrayList<ModbusDataType> _values = new ArrayList<ModbusDataType>();
        for (ModbusDataType _val : ModbusDataType.values()) {
            if (_val.getDataTypeSize() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public static ModbusDataType enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }

    static {
        map = new HashMap<Short, ModbusDataType>();
        for (ModbusDataType value : ModbusDataType.values()) {
            map.put(value.getValue(), value);
        }
    }
}

