/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.rtu.protocol;

import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.modbus.base.field.ModbusField;
import org.apache.plc4x.java.modbus.base.protocol.ModbusProtocolLogic;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUError;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteSingleCoilRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteSingleCoilResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusRtuADU;
import org.apache.plc4x.java.modbus.rtu.config.ModbusRtuConfiguration;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;

public class ModbusRtuProtocolLogic
extends ModbusProtocolLogic<ModbusRtuADU>
implements HasConfiguration<ModbusRtuConfiguration> {
    public ModbusRtuProtocolLogic() {
        super(DriverType.MODBUS_RTU);
    }

    public void setConfiguration(ModbusRtuConfiguration configuration) {
        this.requestTimeout = Duration.ofMillis(configuration.getRequestTimeout());
        this.unitIdentifier = (short)configuration.getUnitIdentifier();
        this.tm = new RequestTransactionManager(1);
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
        DefaultPlcReadRequest request = (DefaultPlcReadRequest)readRequest;
        if (request.getFieldNames().size() == 1) {
            String fieldName = (String)request.getFieldNames().iterator().next();
            ModbusField field = (ModbusField)request.getField(fieldName);
            ModbusPDU requestPdu = this.getReadRequestPdu(field);
            ModbusRtuADU modbusRtuADU = new ModbusRtuADU(this.unitIdentifier, requestPdu, false);
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            transaction.submit(() -> this.context.sendRequest((Object)modbusRtuADU).expectResponse(ModbusRtuADU.class, this.requestTimeout).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).unwrap(ModbusRtuADU::getPdu).handle(responsePdu -> {
                PlcResponseCode responseCode;
                PlcValue plcValue = null;
                if (responsePdu instanceof ModbusPDUError) {
                    ModbusPDUError errorResponse = (ModbusPDUError)responsePdu;
                    responseCode = this.getErrorCode(errorResponse);
                } else {
                    try {
                        plcValue = this.toPlcValue(requestPdu, (ModbusPDU)responsePdu, field.getDataType());
                        responseCode = PlcResponseCode.OK;
                    }
                    catch (ParseException e) {
                        responseCode = PlcResponseCode.INTERNAL_ERROR;
                    }
                }
                DefaultPlcReadResponse response = new DefaultPlcReadResponse((PlcReadRequest)request, Collections.singletonMap(fieldName, new ResponseItem(responseCode, (Object)plcValue)));
                future.complete((PlcReadResponse)response);
                transaction.endRequest();
            }));
        } else {
            future.completeExceptionally((Throwable)new PlcRuntimeException("Modbus only supports single filed requests"));
        }
        return future;
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        DefaultPlcWriteRequest request = (DefaultPlcWriteRequest)writeRequest;
        if (request.getFieldNames().size() == 1) {
            String fieldName = (String)request.getFieldNames().iterator().next();
            PlcField field = request.getField(fieldName);
            ModbusPDU requestPdu = this.getWriteRequestPdu(field, writeRequest.getPlcValue(fieldName));
            ModbusRtuADU modbusRtuADU = new ModbusRtuADU(this.unitIdentifier, requestPdu, false);
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            transaction.submit(() -> this.context.sendRequest((Object)modbusRtuADU).expectResponse(ModbusRtuADU.class, this.requestTimeout).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).unwrap(ModbusRtuADU::getPdu).handle(responsePdu -> {
                ModbusPDUWriteSingleCoilResponse response;
                PlcResponseCode responseCode;
                if (responsePdu instanceof ModbusPDUError) {
                    ModbusPDUError errorResponse = (ModbusPDUError)responsePdu;
                    responseCode = this.getErrorCode(errorResponse);
                } else {
                    responseCode = PlcResponseCode.OK;
                    if (responsePdu instanceof ModbusPDUWriteSingleCoilResponse) {
                        response = (ModbusPDUWriteSingleCoilResponse)responsePdu;
                        ModbusPDUWriteSingleCoilRequest requestSingleCoil = (ModbusPDUWriteSingleCoilRequest)requestPdu;
                        if (response.getValue() != requestSingleCoil.getValue() || response.getAddress() != requestSingleCoil.getAddress()) {
                            responseCode = PlcResponseCode.REMOTE_ERROR;
                        }
                    }
                }
                response = new DefaultPlcWriteResponse((PlcWriteRequest)request, Collections.singletonMap(fieldName, responseCode));
                future.complete((PlcWriteResponse)response);
                transaction.endRequest();
            }));
        } else {
            future.completeExceptionally((Throwable)new PlcRuntimeException("Modbus only supports single filed requests"));
        }
        return future;
    }
}

