/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.ascii.protocol;

import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcPingRequest;
import org.apache.plc4x.java.api.messages.PlcPingResponse;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.modbus.ascii.config.ModbusAsciiConfiguration;
import org.apache.plc4x.java.modbus.base.protocol.ModbusProtocolLogic;
import org.apache.plc4x.java.modbus.base.tag.ModbusTag;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusAsciiADU;
import org.apache.plc4x.java.modbus.readwrite.ModbusDeviceInformationLevel;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUError;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadDeviceIdentificationRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteSingleCoilRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteSingleCoilResponse;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.messages.DefaultPlcPingResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;

public class ModbusAsciiProtocolLogic
extends ModbusProtocolLogic<ModbusAsciiADU>
implements HasConfiguration<ModbusAsciiConfiguration> {
    public ModbusAsciiProtocolLogic() {
        super(DriverType.MODBUS_ASCII);
    }

    public void setConfiguration(ModbusAsciiConfiguration configuration) {
        this.requestTimeout = Duration.ofMillis(configuration.getRequestTimeout());
        this.unitIdentifier = (short)configuration.getUnitIdentifier();
        this.tm = new RequestTransactionManager(1);
    }

    public CompletableFuture<PlcPingResponse> ping(PlcPingRequest pingRequest) {
        CompletableFuture<PlcPingResponse> future = new CompletableFuture<PlcPingResponse>();
        ModbusPDUReadDeviceIdentificationRequest identificationRequestPdu = new ModbusPDUReadDeviceIdentificationRequest(ModbusDeviceInformationLevel.BASIC, 0);
        ModbusAsciiADU modbusTcpADU = new ModbusAsciiADU(this.unitIdentifier, identificationRequestPdu);
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> {
            ConversationContext.ContextHandler contextHandler = this.context.sendRequest((Object)modbusTcpADU).expectResponse(ModbusAsciiADU.class, this.requestTimeout).onTimeout(future::completeExceptionally).onError((p, e) -> {
                boolean bl = future.completeExceptionally((Throwable)e);
            }).unwrap(ModbusAsciiADU::getPdu).handle(responsePdu -> {
                transaction.endRequest();
                future.complete((PlcPingResponse)new DefaultPlcPingResponse(pingRequest, PlcResponseCode.OK));
            });
        });
        return future;
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
        DefaultPlcReadRequest request = (DefaultPlcReadRequest)readRequest;
        if (request.getTagNames().size() == 1) {
            String tagName = (String)request.getTagNames().iterator().next();
            ModbusTag tag = (ModbusTag)request.getTag(tagName);
            ModbusPDU requestPdu = this.getReadRequestPdu(tag);
            ModbusAsciiADU modbusAsciiADU = new ModbusAsciiADU(this.unitIdentifier, requestPdu);
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            transaction.submit(() -> {
                ConversationContext.ContextHandler contextHandler = this.context.sendRequest((Object)modbusAsciiADU).expectResponse(ModbusAsciiADU.class, this.requestTimeout).onTimeout(future::completeExceptionally).onError((p, e) -> {
                    boolean bl = future.completeExceptionally((Throwable)e);
                }).unwrap(ModbusAsciiADU::getPdu).handle(responsePdu -> {
                    PlcResponseCode responseCode;
                    PlcValue plcValue = null;
                    if (responsePdu instanceof ModbusPDUError) {
                        ModbusPDUError errorResponse = (ModbusPDUError)responsePdu;
                        responseCode = this.getErrorCode(errorResponse);
                    } else {
                        try {
                            plcValue = this.toPlcValue(requestPdu, (ModbusPDU)responsePdu, tag.getDataType());
                            responseCode = PlcResponseCode.OK;
                        }
                        catch (ParseException e) {
                            responseCode = PlcResponseCode.INTERNAL_ERROR;
                        }
                    }
                    DefaultPlcReadResponse response = new DefaultPlcReadResponse((PlcReadRequest)request, Collections.singletonMap(tagName, new ResponseItem(responseCode, (Object)plcValue)));
                    future.complete((PlcReadResponse)response);
                    transaction.endRequest();
                });
            });
        } else {
            future.completeExceptionally((Throwable)new PlcRuntimeException("Modbus only supports single filed requests"));
        }
        return future;
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        DefaultPlcWriteRequest request = (DefaultPlcWriteRequest)writeRequest;
        if (request.getTagNames().size() == 1) {
            String tagName = (String)request.getTagNames().iterator().next();
            PlcTag tag = request.getTag(tagName);
            ModbusPDU requestPdu = this.getWriteRequestPdu(tag, writeRequest.getPlcValue(tagName));
            ModbusAsciiADU modbusAsciiADU = new ModbusAsciiADU(this.unitIdentifier, requestPdu);
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            transaction.submit(() -> {
                ConversationContext.ContextHandler contextHandler = this.context.sendRequest((Object)modbusAsciiADU).expectResponse(ModbusAsciiADU.class, this.requestTimeout).onTimeout(future::completeExceptionally).onError((p, e) -> {
                    boolean bl = future.completeExceptionally((Throwable)e);
                }).unwrap(ModbusAsciiADU::getPdu).handle(responsePdu -> {
                    ModbusPDUWriteSingleCoilResponse response;
                    PlcResponseCode responseCode;
                    if (responsePdu instanceof ModbusPDUError) {
                        ModbusPDUError errorResponse = (ModbusPDUError)responsePdu;
                        responseCode = this.getErrorCode(errorResponse);
                    } else {
                        responseCode = PlcResponseCode.OK;
                        if (responsePdu instanceof ModbusPDUWriteSingleCoilResponse) {
                            response = (ModbusPDUWriteSingleCoilResponse)responsePdu;
                            ModbusPDUWriteSingleCoilRequest requestSingleCoil = (ModbusPDUWriteSingleCoilRequest)requestPdu;
                            if (response.getValue() != requestSingleCoil.getValue() || response.getAddress() != requestSingleCoil.getAddress()) {
                                responseCode = PlcResponseCode.REMOTE_ERROR;
                            }
                        }
                    }
                    response = new DefaultPlcWriteResponse((PlcWriteRequest)request, Collections.singletonMap(tagName, responseCode));
                    future.complete((PlcWriteResponse)response);
                    transaction.endRequest();
                });
            });
        } else {
            future.completeExceptionally((Throwable)new PlcRuntimeException("Modbus only supports single filed requests"));
        }
        return future;
    }
}

