/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ActivateSessionRequest extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "467";
  }

  // Properties.
  protected final ExtensionObjectDefinition requestHeader;
  protected final ExtensionObjectDefinition clientSignature;
  protected final int noOfClientSoftwareCertificates;
  protected final List<ExtensionObjectDefinition> clientSoftwareCertificates;
  protected final int noOfLocaleIds;
  protected final List<PascalString> localeIds;
  protected final ExtensionObject userIdentityToken;
  protected final ExtensionObjectDefinition userTokenSignature;

  public ActivateSessionRequest(
      ExtensionObjectDefinition requestHeader,
      ExtensionObjectDefinition clientSignature,
      int noOfClientSoftwareCertificates,
      List<ExtensionObjectDefinition> clientSoftwareCertificates,
      int noOfLocaleIds,
      List<PascalString> localeIds,
      ExtensionObject userIdentityToken,
      ExtensionObjectDefinition userTokenSignature) {
    super();
    this.requestHeader = requestHeader;
    this.clientSignature = clientSignature;
    this.noOfClientSoftwareCertificates = noOfClientSoftwareCertificates;
    this.clientSoftwareCertificates = clientSoftwareCertificates;
    this.noOfLocaleIds = noOfLocaleIds;
    this.localeIds = localeIds;
    this.userIdentityToken = userIdentityToken;
    this.userTokenSignature = userTokenSignature;
  }

  public ExtensionObjectDefinition getRequestHeader() {
    return requestHeader;
  }

  public ExtensionObjectDefinition getClientSignature() {
    return clientSignature;
  }

  public int getNoOfClientSoftwareCertificates() {
    return noOfClientSoftwareCertificates;
  }

  public List<ExtensionObjectDefinition> getClientSoftwareCertificates() {
    return clientSoftwareCertificates;
  }

  public int getNoOfLocaleIds() {
    return noOfLocaleIds;
  }

  public List<PascalString> getLocaleIds() {
    return localeIds;
  }

  public ExtensionObject getUserIdentityToken() {
    return userIdentityToken;
  }

  public ExtensionObjectDefinition getUserTokenSignature() {
    return userTokenSignature;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("ActivateSessionRequest");

    // Simple Field (requestHeader)
    writeSimpleField("requestHeader", requestHeader, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (clientSignature)
    writeSimpleField(
        "clientSignature", clientSignature, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfClientSoftwareCertificates)
    writeSimpleField(
        "noOfClientSoftwareCertificates",
        noOfClientSoftwareCertificates,
        writeSignedInt(writeBuffer, 32));

    // Array Field (clientSoftwareCertificates)
    writeComplexTypeArrayField(
        "clientSoftwareCertificates", clientSoftwareCertificates, writeBuffer);

    // Simple Field (noOfLocaleIds)
    writeSimpleField("noOfLocaleIds", noOfLocaleIds, writeSignedInt(writeBuffer, 32));

    // Array Field (localeIds)
    writeComplexTypeArrayField("localeIds", localeIds, writeBuffer);

    // Simple Field (userIdentityToken)
    writeSimpleField(
        "userIdentityToken", userIdentityToken, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (userTokenSignature)
    writeSimpleField(
        "userTokenSignature", userTokenSignature, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("ActivateSessionRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ActivateSessionRequest _value = this;

    // Simple field (requestHeader)
    lengthInBits += requestHeader.getLengthInBits();

    // Simple field (clientSignature)
    lengthInBits += clientSignature.getLengthInBits();

    // Simple field (noOfClientSoftwareCertificates)
    lengthInBits += 32;

    // Array field
    if (clientSoftwareCertificates != null) {
      int i = 0;
      for (ExtensionObjectDefinition element : clientSoftwareCertificates) {
        boolean last = ++i >= clientSoftwareCertificates.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (noOfLocaleIds)
    lengthInBits += 32;

    // Array field
    if (localeIds != null) {
      int i = 0;
      for (PascalString element : localeIds) {
        boolean last = ++i >= localeIds.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (userIdentityToken)
    lengthInBits += userIdentityToken.getLengthInBits();

    // Simple field (userTokenSignature)
    lengthInBits += userTokenSignature.getLengthInBits();

    return lengthInBits;
  }

  public static ActivateSessionRequestBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("ActivateSessionRequest");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    ExtensionObjectDefinition requestHeader =
        readSimpleField(
            "requestHeader",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("391")),
                readBuffer));

    ExtensionObjectDefinition clientSignature =
        readSimpleField(
            "clientSignature",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("458")),
                readBuffer));

    int noOfClientSoftwareCertificates =
        readSimpleField("noOfClientSoftwareCertificates", readSignedInt(readBuffer, 32));

    List<ExtensionObjectDefinition> clientSoftwareCertificates =
        readCountArrayField(
            "clientSoftwareCertificates",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("346")),
                readBuffer),
            noOfClientSoftwareCertificates);

    int noOfLocaleIds = readSimpleField("noOfLocaleIds", readSignedInt(readBuffer, 32));

    List<PascalString> localeIds =
        readCountArrayField(
            "localeIds",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfLocaleIds);

    ExtensionObject userIdentityToken =
        readSimpleField(
            "userIdentityToken",
            new DataReaderComplexDefault<>(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer));

    ExtensionObjectDefinition userTokenSignature =
        readSimpleField(
            "userTokenSignature",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("458")),
                readBuffer));

    readBuffer.closeContext("ActivateSessionRequest");
    // Create the instance
    return new ActivateSessionRequestBuilder(
        requestHeader,
        clientSignature,
        noOfClientSoftwareCertificates,
        clientSoftwareCertificates,
        noOfLocaleIds,
        localeIds,
        userIdentityToken,
        userTokenSignature);
  }

  public static class ActivateSessionRequestBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObjectDefinition requestHeader;
    private final ExtensionObjectDefinition clientSignature;
    private final int noOfClientSoftwareCertificates;
    private final List<ExtensionObjectDefinition> clientSoftwareCertificates;
    private final int noOfLocaleIds;
    private final List<PascalString> localeIds;
    private final ExtensionObject userIdentityToken;
    private final ExtensionObjectDefinition userTokenSignature;

    public ActivateSessionRequestBuilder(
        ExtensionObjectDefinition requestHeader,
        ExtensionObjectDefinition clientSignature,
        int noOfClientSoftwareCertificates,
        List<ExtensionObjectDefinition> clientSoftwareCertificates,
        int noOfLocaleIds,
        List<PascalString> localeIds,
        ExtensionObject userIdentityToken,
        ExtensionObjectDefinition userTokenSignature) {

      this.requestHeader = requestHeader;
      this.clientSignature = clientSignature;
      this.noOfClientSoftwareCertificates = noOfClientSoftwareCertificates;
      this.clientSoftwareCertificates = clientSoftwareCertificates;
      this.noOfLocaleIds = noOfLocaleIds;
      this.localeIds = localeIds;
      this.userIdentityToken = userIdentityToken;
      this.userTokenSignature = userTokenSignature;
    }

    public ActivateSessionRequest build() {
      ActivateSessionRequest activateSessionRequest =
          new ActivateSessionRequest(
              requestHeader,
              clientSignature,
              noOfClientSoftwareCertificates,
              clientSoftwareCertificates,
              noOfLocaleIds,
              localeIds,
              userIdentityToken,
              userTokenSignature);
      return activateSessionRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ActivateSessionRequest)) {
      return false;
    }
    ActivateSessionRequest that = (ActivateSessionRequest) o;
    return (getRequestHeader() == that.getRequestHeader())
        && (getClientSignature() == that.getClientSignature())
        && (getNoOfClientSoftwareCertificates() == that.getNoOfClientSoftwareCertificates())
        && (getClientSoftwareCertificates() == that.getClientSoftwareCertificates())
        && (getNoOfLocaleIds() == that.getNoOfLocaleIds())
        && (getLocaleIds() == that.getLocaleIds())
        && (getUserIdentityToken() == that.getUserIdentityToken())
        && (getUserTokenSignature() == that.getUserTokenSignature())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getRequestHeader(),
        getClientSignature(),
        getNoOfClientSoftwareCertificates(),
        getClientSoftwareCertificates(),
        getNoOfLocaleIds(),
        getLocaleIds(),
        getUserIdentityToken(),
        getUserTokenSignature());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
