/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CurrencyUnitType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "23500";
  }

  // Properties.
  protected final short numericCode;
  protected final byte exponent;
  protected final PascalString alphabeticCode;
  protected final LocalizedText currency;

  public CurrencyUnitType(
      short numericCode, byte exponent, PascalString alphabeticCode, LocalizedText currency) {
    super();
    this.numericCode = numericCode;
    this.exponent = exponent;
    this.alphabeticCode = alphabeticCode;
    this.currency = currency;
  }

  public short getNumericCode() {
    return numericCode;
  }

  public byte getExponent() {
    return exponent;
  }

  public PascalString getAlphabeticCode() {
    return alphabeticCode;
  }

  public LocalizedText getCurrency() {
    return currency;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("CurrencyUnitType");

    // Simple Field (numericCode)
    writeSimpleField("numericCode", numericCode, writeSignedShort(writeBuffer, 16));

    // Simple Field (exponent)
    writeSimpleField("exponent", exponent, writeSignedByte(writeBuffer, 8));

    // Simple Field (alphabeticCode)
    writeSimpleField("alphabeticCode", alphabeticCode, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (currency)
    writeSimpleField("currency", currency, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("CurrencyUnitType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CurrencyUnitType _value = this;

    // Simple field (numericCode)
    lengthInBits += 16;

    // Simple field (exponent)
    lengthInBits += 8;

    // Simple field (alphabeticCode)
    lengthInBits += alphabeticCode.getLengthInBits();

    // Simple field (currency)
    lengthInBits += currency.getLengthInBits();

    return lengthInBits;
  }

  public static CurrencyUnitTypeBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier)
      throws ParseException {
    readBuffer.pullContext("CurrencyUnitType");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    short numericCode = readSimpleField("numericCode", readSignedShort(readBuffer, 16));

    byte exponent = readSimpleField("exponent", readSignedByte(readBuffer, 8));

    PascalString alphabeticCode =
        readSimpleField(
            "alphabeticCode",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    LocalizedText currency =
        readSimpleField(
            "currency",
            new DataReaderComplexDefault<>(
                () -> LocalizedText.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("CurrencyUnitType");
    // Create the instance
    return new CurrencyUnitTypeBuilder(numericCode, exponent, alphabeticCode, currency);
  }

  public static class CurrencyUnitTypeBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final short numericCode;
    private final byte exponent;
    private final PascalString alphabeticCode;
    private final LocalizedText currency;

    public CurrencyUnitTypeBuilder(
        short numericCode, byte exponent, PascalString alphabeticCode, LocalizedText currency) {

      this.numericCode = numericCode;
      this.exponent = exponent;
      this.alphabeticCode = alphabeticCode;
      this.currency = currency;
    }

    public CurrencyUnitType build() {
      CurrencyUnitType currencyUnitType =
          new CurrencyUnitType(numericCode, exponent, alphabeticCode, currency);
      return currencyUnitType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CurrencyUnitType)) {
      return false;
    }
    CurrencyUnitType that = (CurrencyUnitType) o;
    return (getNumericCode() == that.getNumericCode())
        && (getExponent() == that.getExponent())
        && (getAlphabeticCode() == that.getAlphabeticCode())
        && (getCurrency() == that.getCurrency())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getNumericCode(), getExponent(), getAlphabeticCode(), getCurrency());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
