/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class DoubleComplexNumberType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "12174";
  }

  // Properties.
  protected final double real;
  protected final double imaginary;

  public DoubleComplexNumberType(double real, double imaginary) {
    super();
    this.real = real;
    this.imaginary = imaginary;
  }

  public double getReal() {
    return real;
  }

  public double getImaginary() {
    return imaginary;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("DoubleComplexNumberType");

    // Simple Field (real)
    writeSimpleField("real", real, writeDouble(writeBuffer, 64));

    // Simple Field (imaginary)
    writeSimpleField("imaginary", imaginary, writeDouble(writeBuffer, 64));

    writeBuffer.popContext("DoubleComplexNumberType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    DoubleComplexNumberType _value = this;

    // Simple field (real)
    lengthInBits += 64;

    // Simple field (imaginary)
    lengthInBits += 64;

    return lengthInBits;
  }

  public static DoubleComplexNumberTypeBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("DoubleComplexNumberType");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    double real = readSimpleField("real", readDouble(readBuffer, 64));

    double imaginary = readSimpleField("imaginary", readDouble(readBuffer, 64));

    readBuffer.closeContext("DoubleComplexNumberType");
    // Create the instance
    return new DoubleComplexNumberTypeBuilder(real, imaginary);
  }

  public static class DoubleComplexNumberTypeBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final double real;
    private final double imaginary;

    public DoubleComplexNumberTypeBuilder(double real, double imaginary) {

      this.real = real;
      this.imaginary = imaginary;
    }

    public DoubleComplexNumberType build() {
      DoubleComplexNumberType doubleComplexNumberType =
          new DoubleComplexNumberType(real, imaginary);
      return doubleComplexNumberType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DoubleComplexNumberType)) {
      return false;
    }
    DoubleComplexNumberType that = (DoubleComplexNumberType) o;
    return (getReal() == that.getReal())
        && (getImaginary() == that.getImaginary())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getReal(), getImaginary());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
