/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class EndpointConfiguration extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "333";
  }

  // Properties.
  protected final int operationTimeout;
  protected final boolean useBinaryEncoding;
  protected final int maxStringLength;
  protected final int maxByteStringLength;
  protected final int maxArrayLength;
  protected final int maxMessageSize;
  protected final int maxBufferSize;
  protected final int channelLifetime;
  protected final int securityTokenLifetime;
  // Reserved Fields
  private Short reservedField0;

  public EndpointConfiguration(
      int operationTimeout,
      boolean useBinaryEncoding,
      int maxStringLength,
      int maxByteStringLength,
      int maxArrayLength,
      int maxMessageSize,
      int maxBufferSize,
      int channelLifetime,
      int securityTokenLifetime) {
    super();
    this.operationTimeout = operationTimeout;
    this.useBinaryEncoding = useBinaryEncoding;
    this.maxStringLength = maxStringLength;
    this.maxByteStringLength = maxByteStringLength;
    this.maxArrayLength = maxArrayLength;
    this.maxMessageSize = maxMessageSize;
    this.maxBufferSize = maxBufferSize;
    this.channelLifetime = channelLifetime;
    this.securityTokenLifetime = securityTokenLifetime;
  }

  public int getOperationTimeout() {
    return operationTimeout;
  }

  public boolean getUseBinaryEncoding() {
    return useBinaryEncoding;
  }

  public int getMaxStringLength() {
    return maxStringLength;
  }

  public int getMaxByteStringLength() {
    return maxByteStringLength;
  }

  public int getMaxArrayLength() {
    return maxArrayLength;
  }

  public int getMaxMessageSize() {
    return maxMessageSize;
  }

  public int getMaxBufferSize() {
    return maxBufferSize;
  }

  public int getChannelLifetime() {
    return channelLifetime;
  }

  public int getSecurityTokenLifetime() {
    return securityTokenLifetime;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("EndpointConfiguration");

    // Simple Field (operationTimeout)
    writeSimpleField("operationTimeout", operationTimeout, writeSignedInt(writeBuffer, 32));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (short) 0x00,
        writeUnsignedShort(writeBuffer, 7));

    // Simple Field (useBinaryEncoding)
    writeSimpleField("useBinaryEncoding", useBinaryEncoding, writeBoolean(writeBuffer));

    // Simple Field (maxStringLength)
    writeSimpleField("maxStringLength", maxStringLength, writeSignedInt(writeBuffer, 32));

    // Simple Field (maxByteStringLength)
    writeSimpleField("maxByteStringLength", maxByteStringLength, writeSignedInt(writeBuffer, 32));

    // Simple Field (maxArrayLength)
    writeSimpleField("maxArrayLength", maxArrayLength, writeSignedInt(writeBuffer, 32));

    // Simple Field (maxMessageSize)
    writeSimpleField("maxMessageSize", maxMessageSize, writeSignedInt(writeBuffer, 32));

    // Simple Field (maxBufferSize)
    writeSimpleField("maxBufferSize", maxBufferSize, writeSignedInt(writeBuffer, 32));

    // Simple Field (channelLifetime)
    writeSimpleField("channelLifetime", channelLifetime, writeSignedInt(writeBuffer, 32));

    // Simple Field (securityTokenLifetime)
    writeSimpleField(
        "securityTokenLifetime", securityTokenLifetime, writeSignedInt(writeBuffer, 32));

    writeBuffer.popContext("EndpointConfiguration");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    EndpointConfiguration _value = this;

    // Simple field (operationTimeout)
    lengthInBits += 32;

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (useBinaryEncoding)
    lengthInBits += 1;

    // Simple field (maxStringLength)
    lengthInBits += 32;

    // Simple field (maxByteStringLength)
    lengthInBits += 32;

    // Simple field (maxArrayLength)
    lengthInBits += 32;

    // Simple field (maxMessageSize)
    lengthInBits += 32;

    // Simple field (maxBufferSize)
    lengthInBits += 32;

    // Simple field (channelLifetime)
    lengthInBits += 32;

    // Simple field (securityTokenLifetime)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static EndpointConfigurationBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("EndpointConfiguration");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    int operationTimeout = readSimpleField("operationTimeout", readSignedInt(readBuffer, 32));

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 7), (short) 0x00);

    boolean useBinaryEncoding = readSimpleField("useBinaryEncoding", readBoolean(readBuffer));

    int maxStringLength = readSimpleField("maxStringLength", readSignedInt(readBuffer, 32));

    int maxByteStringLength = readSimpleField("maxByteStringLength", readSignedInt(readBuffer, 32));

    int maxArrayLength = readSimpleField("maxArrayLength", readSignedInt(readBuffer, 32));

    int maxMessageSize = readSimpleField("maxMessageSize", readSignedInt(readBuffer, 32));

    int maxBufferSize = readSimpleField("maxBufferSize", readSignedInt(readBuffer, 32));

    int channelLifetime = readSimpleField("channelLifetime", readSignedInt(readBuffer, 32));

    int securityTokenLifetime =
        readSimpleField("securityTokenLifetime", readSignedInt(readBuffer, 32));

    readBuffer.closeContext("EndpointConfiguration");
    // Create the instance
    return new EndpointConfigurationBuilder(
        operationTimeout,
        useBinaryEncoding,
        maxStringLength,
        maxByteStringLength,
        maxArrayLength,
        maxMessageSize,
        maxBufferSize,
        channelLifetime,
        securityTokenLifetime,
        reservedField0);
  }

  public static class EndpointConfigurationBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final int operationTimeout;
    private final boolean useBinaryEncoding;
    private final int maxStringLength;
    private final int maxByteStringLength;
    private final int maxArrayLength;
    private final int maxMessageSize;
    private final int maxBufferSize;
    private final int channelLifetime;
    private final int securityTokenLifetime;
    private final Short reservedField0;

    public EndpointConfigurationBuilder(
        int operationTimeout,
        boolean useBinaryEncoding,
        int maxStringLength,
        int maxByteStringLength,
        int maxArrayLength,
        int maxMessageSize,
        int maxBufferSize,
        int channelLifetime,
        int securityTokenLifetime,
        Short reservedField0) {
      this.operationTimeout = operationTimeout;
      this.useBinaryEncoding = useBinaryEncoding;
      this.maxStringLength = maxStringLength;
      this.maxByteStringLength = maxByteStringLength;
      this.maxArrayLength = maxArrayLength;
      this.maxMessageSize = maxMessageSize;
      this.maxBufferSize = maxBufferSize;
      this.channelLifetime = channelLifetime;
      this.securityTokenLifetime = securityTokenLifetime;
      this.reservedField0 = reservedField0;
    }

    public EndpointConfiguration build() {
      EndpointConfiguration endpointConfiguration =
          new EndpointConfiguration(
              operationTimeout,
              useBinaryEncoding,
              maxStringLength,
              maxByteStringLength,
              maxArrayLength,
              maxMessageSize,
              maxBufferSize,
              channelLifetime,
              securityTokenLifetime);
      endpointConfiguration.reservedField0 = reservedField0;
      return endpointConfiguration;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof EndpointConfiguration)) {
      return false;
    }
    EndpointConfiguration that = (EndpointConfiguration) o;
    return (getOperationTimeout() == that.getOperationTimeout())
        && (getUseBinaryEncoding() == that.getUseBinaryEncoding())
        && (getMaxStringLength() == that.getMaxStringLength())
        && (getMaxByteStringLength() == that.getMaxByteStringLength())
        && (getMaxArrayLength() == that.getMaxArrayLength())
        && (getMaxMessageSize() == that.getMaxMessageSize())
        && (getMaxBufferSize() == that.getMaxBufferSize())
        && (getChannelLifetime() == that.getChannelLifetime())
        && (getSecurityTokenLifetime() == that.getSecurityTokenLifetime())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getOperationTimeout(),
        getUseBinaryEncoding(),
        getMaxStringLength(),
        getMaxByteStringLength(),
        getMaxArrayLength(),
        getMaxMessageSize(),
        getMaxBufferSize(),
        getChannelLifetime(),
        getSecurityTokenLifetime());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
