/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class MonitoredItemModifyResult extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "760";
  }

  // Properties.
  protected final StatusCode statusCode;
  protected final double revisedSamplingInterval;
  protected final long revisedQueueSize;
  protected final ExtensionObject filterResult;

  public MonitoredItemModifyResult(
      StatusCode statusCode,
      double revisedSamplingInterval,
      long revisedQueueSize,
      ExtensionObject filterResult) {
    super();
    this.statusCode = statusCode;
    this.revisedSamplingInterval = revisedSamplingInterval;
    this.revisedQueueSize = revisedQueueSize;
    this.filterResult = filterResult;
  }

  public StatusCode getStatusCode() {
    return statusCode;
  }

  public double getRevisedSamplingInterval() {
    return revisedSamplingInterval;
  }

  public long getRevisedQueueSize() {
    return revisedQueueSize;
  }

  public ExtensionObject getFilterResult() {
    return filterResult;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("MonitoredItemModifyResult");

    // Simple Field (statusCode)
    writeSimpleField("statusCode", statusCode, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (revisedSamplingInterval)
    writeSimpleField(
        "revisedSamplingInterval", revisedSamplingInterval, writeDouble(writeBuffer, 64));

    // Simple Field (revisedQueueSize)
    writeSimpleField("revisedQueueSize", revisedQueueSize, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (filterResult)
    writeSimpleField("filterResult", filterResult, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("MonitoredItemModifyResult");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    MonitoredItemModifyResult _value = this;

    // Simple field (statusCode)
    lengthInBits += statusCode.getLengthInBits();

    // Simple field (revisedSamplingInterval)
    lengthInBits += 64;

    // Simple field (revisedQueueSize)
    lengthInBits += 32;

    // Simple field (filterResult)
    lengthInBits += filterResult.getLengthInBits();

    return lengthInBits;
  }

  public static MonitoredItemModifyResultBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("MonitoredItemModifyResult");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    StatusCode statusCode =
        readSimpleField(
            "statusCode",
            new DataReaderComplexDefault<>(() -> StatusCode.staticParse(readBuffer), readBuffer));

    double revisedSamplingInterval =
        readSimpleField("revisedSamplingInterval", readDouble(readBuffer, 64));

    long revisedQueueSize = readSimpleField("revisedQueueSize", readUnsignedLong(readBuffer, 32));

    ExtensionObject filterResult =
        readSimpleField(
            "filterResult",
            new DataReaderComplexDefault<>(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer));

    readBuffer.closeContext("MonitoredItemModifyResult");
    // Create the instance
    return new MonitoredItemModifyResultBuilder(
        statusCode, revisedSamplingInterval, revisedQueueSize, filterResult);
  }

  public static class MonitoredItemModifyResultBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final StatusCode statusCode;
    private final double revisedSamplingInterval;
    private final long revisedQueueSize;
    private final ExtensionObject filterResult;

    public MonitoredItemModifyResultBuilder(
        StatusCode statusCode,
        double revisedSamplingInterval,
        long revisedQueueSize,
        ExtensionObject filterResult) {

      this.statusCode = statusCode;
      this.revisedSamplingInterval = revisedSamplingInterval;
      this.revisedQueueSize = revisedQueueSize;
      this.filterResult = filterResult;
    }

    public MonitoredItemModifyResult build() {
      MonitoredItemModifyResult monitoredItemModifyResult =
          new MonitoredItemModifyResult(
              statusCode, revisedSamplingInterval, revisedQueueSize, filterResult);
      return monitoredItemModifyResult;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof MonitoredItemModifyResult)) {
      return false;
    }
    MonitoredItemModifyResult that = (MonitoredItemModifyResult) o;
    return (getStatusCode() == that.getStatusCode())
        && (getRevisedSamplingInterval() == that.getRevisedSamplingInterval())
        && (getRevisedQueueSize() == that.getRevisedQueueSize())
        && (getFilterResult() == that.getFilterResult())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getStatusCode(),
        getRevisedSamplingInterval(),
        getRevisedQueueSize(),
        getFilterResult());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
