/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum OpcuaDataType {
  NULL((String) "NULL", (short) 0),
  BOOL((String) "BOOL", (short) 1),
  BYTE((String) "BYTE", (short) 3),
  SINT((String) "SINT", (short) 2),
  INT((String) "INT", (short) 4),
  DINT((String) "DINT", (short) 6),
  LINT((String) "LINT", (short) 8),
  USINT((String) "USINT", (short) 3),
  UINT((String) "UINT", (short) 5),
  UDINT((String) "UDINT", (short) 7),
  ULINT((String) "ULINT", (short) 9),
  REAL((String) "REAL", (short) 10),
  LREAL((String) "LREAL", (short) 11),
  TIME((String) "TIME", (short) 1),
  LTIME((String) "LTIME", (short) 1),
  DATE((String) "DATE", (short) 1),
  LDATE((String) "LDATE", (short) 1),
  TIME_OF_DAY((String) "TIME_OF_DAY", (short) 1),
  LTIME_OF_DAY((String) "LTIME_OF_DAY", (short) 1),
  DATE_AND_TIME((String) "DATE_AND_TIME", (short) 13),
  LDATE_AND_TIME((String) "LDATE_AND_TIME", (short) 1),
  CHAR((String) "CHAR", (short) 1),
  WCHAR((String) "WCHAR", (short) 1),
  STRING((String) "STRING", (short) 12);
  private static final Map<String, OpcuaDataType> map;

  static {
    map = new HashMap<>();
    for (OpcuaDataType value : OpcuaDataType.values()) {
      map.put((String) value.getValue(), value);
    }
  }

  private String value;
  private short variantType;

  OpcuaDataType(String value, short variantType) {
    this.value = value;
    this.variantType = variantType;
  }

  public String getValue() {
    return value;
  }

  public short getVariantType() {
    return variantType;
  }

  public static OpcuaDataType firstEnumForFieldVariantType(short fieldValue) {
    for (OpcuaDataType _val : OpcuaDataType.values()) {
      if (_val.getVariantType() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<OpcuaDataType> enumsForFieldVariantType(short fieldValue) {
    List<OpcuaDataType> _values = new ArrayList();
    for (OpcuaDataType _val : OpcuaDataType.values()) {
      if (_val.getVariantType() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static OpcuaDataType enumForValue(String value) {
    return map.get(value);
  }

  public static Boolean isDefined(String value) {
    return map.containsKey(value);
  }
}
