/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpcuaOpenResponse extends MessagePDU implements Message {

  // Accessors for discriminator values.
  public String getMessageType() {
    return (String) "OPN";
  }

  public Boolean getResponse() {
    return (boolean) true;
  }

  // Properties.
  protected final String chunk;
  protected final int secureChannelId;
  protected final PascalString securityPolicyUri;
  protected final PascalByteString senderCertificate;
  protected final PascalByteString receiverCertificateThumbprint;
  protected final int sequenceNumber;
  protected final int requestId;
  protected final byte[] message;

  public OpcuaOpenResponse(
      String chunk,
      int secureChannelId,
      PascalString securityPolicyUri,
      PascalByteString senderCertificate,
      PascalByteString receiverCertificateThumbprint,
      int sequenceNumber,
      int requestId,
      byte[] message) {
    super();
    this.chunk = chunk;
    this.secureChannelId = secureChannelId;
    this.securityPolicyUri = securityPolicyUri;
    this.senderCertificate = senderCertificate;
    this.receiverCertificateThumbprint = receiverCertificateThumbprint;
    this.sequenceNumber = sequenceNumber;
    this.requestId = requestId;
    this.message = message;
  }

  public String getChunk() {
    return chunk;
  }

  public int getSecureChannelId() {
    return secureChannelId;
  }

  public PascalString getSecurityPolicyUri() {
    return securityPolicyUri;
  }

  public PascalByteString getSenderCertificate() {
    return senderCertificate;
  }

  public PascalByteString getReceiverCertificateThumbprint() {
    return receiverCertificateThumbprint;
  }

  public int getSequenceNumber() {
    return sequenceNumber;
  }

  public int getRequestId() {
    return requestId;
  }

  public byte[] getMessage() {
    return message;
  }

  @Override
  protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("OpcuaOpenResponse");

    // Simple Field (chunk)
    writeSimpleField("chunk", chunk, writeString(writeBuffer, 8));

    // Implicit Field (messageSize) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int messageSize = (int) (getLengthInBytes());
    writeImplicitField("messageSize", messageSize, writeSignedInt(writeBuffer, 32));

    // Simple Field (secureChannelId)
    writeSimpleField("secureChannelId", secureChannelId, writeSignedInt(writeBuffer, 32));

    // Simple Field (securityPolicyUri)
    writeSimpleField(
        "securityPolicyUri", securityPolicyUri, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (senderCertificate)
    writeSimpleField(
        "senderCertificate", senderCertificate, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (receiverCertificateThumbprint)
    writeSimpleField(
        "receiverCertificateThumbprint",
        receiverCertificateThumbprint,
        new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (sequenceNumber)
    writeSimpleField("sequenceNumber", sequenceNumber, writeSignedInt(writeBuffer, 32));

    // Simple Field (requestId)
    writeSimpleField("requestId", requestId, writeSignedInt(writeBuffer, 32));

    // Array Field (message)
    writeByteArrayField("message", message, writeByteArray(writeBuffer, 8));

    writeBuffer.popContext("OpcuaOpenResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpcuaOpenResponse _value = this;

    // Simple field (chunk)
    lengthInBits += 8;

    // Implicit Field (messageSize)
    lengthInBits += 32;

    // Simple field (secureChannelId)
    lengthInBits += 32;

    // Simple field (securityPolicyUri)
    lengthInBits += securityPolicyUri.getLengthInBits();

    // Simple field (senderCertificate)
    lengthInBits += senderCertificate.getLengthInBits();

    // Simple field (receiverCertificateThumbprint)
    lengthInBits += receiverCertificateThumbprint.getLengthInBits();

    // Simple field (sequenceNumber)
    lengthInBits += 32;

    // Simple field (requestId)
    lengthInBits += 32;

    // Array field
    if (message != null) {
      lengthInBits += 8 * message.length;
    }

    return lengthInBits;
  }

  public static OpcuaOpenResponseBuilder staticParseBuilder(ReadBuffer readBuffer, Boolean response)
      throws ParseException {
    readBuffer.pullContext("OpcuaOpenResponse");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    String chunk = readSimpleField("chunk", readString(readBuffer, 8));

    int messageSize = readImplicitField("messageSize", readSignedInt(readBuffer, 32));

    int secureChannelId = readSimpleField("secureChannelId", readSignedInt(readBuffer, 32));

    PascalString securityPolicyUri =
        readSimpleField(
            "securityPolicyUri",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalByteString senderCertificate =
        readSimpleField(
            "senderCertificate",
            new DataReaderComplexDefault<>(
                () -> PascalByteString.staticParse(readBuffer), readBuffer));

    PascalByteString receiverCertificateThumbprint =
        readSimpleField(
            "receiverCertificateThumbprint",
            new DataReaderComplexDefault<>(
                () -> PascalByteString.staticParse(readBuffer), readBuffer));

    int sequenceNumber = readSimpleField("sequenceNumber", readSignedInt(readBuffer, 32));

    int requestId = readSimpleField("requestId", readSignedInt(readBuffer, 32));

    byte[] message =
        readBuffer.readByteArray(
            "message",
            Math.toIntExact(
                ((((messageSize)
                                - (((((securityPolicyUri.getStringLength()) == (-(1)))
                                    ? 0
                                    : securityPolicyUri.getStringLength()))))
                            - (((((senderCertificate.getStringLength()) == (-(1)))
                                ? 0
                                : senderCertificate.getStringLength()))))
                        - (((((receiverCertificateThumbprint.getStringLength()) == (-(1)))
                            ? 0
                            : receiverCertificateThumbprint.getStringLength()))))
                    - (32)));

    readBuffer.closeContext("OpcuaOpenResponse");
    // Create the instance
    return new OpcuaOpenResponseBuilder(
        chunk,
        secureChannelId,
        securityPolicyUri,
        senderCertificate,
        receiverCertificateThumbprint,
        sequenceNumber,
        requestId,
        message);
  }

  public static class OpcuaOpenResponseBuilder implements MessagePDU.MessagePDUBuilder {
    private final String chunk;
    private final int secureChannelId;
    private final PascalString securityPolicyUri;
    private final PascalByteString senderCertificate;
    private final PascalByteString receiverCertificateThumbprint;
    private final int sequenceNumber;
    private final int requestId;
    private final byte[] message;

    public OpcuaOpenResponseBuilder(
        String chunk,
        int secureChannelId,
        PascalString securityPolicyUri,
        PascalByteString senderCertificate,
        PascalByteString receiverCertificateThumbprint,
        int sequenceNumber,
        int requestId,
        byte[] message) {

      this.chunk = chunk;
      this.secureChannelId = secureChannelId;
      this.securityPolicyUri = securityPolicyUri;
      this.senderCertificate = senderCertificate;
      this.receiverCertificateThumbprint = receiverCertificateThumbprint;
      this.sequenceNumber = sequenceNumber;
      this.requestId = requestId;
      this.message = message;
    }

    public OpcuaOpenResponse build() {
      OpcuaOpenResponse opcuaOpenResponse =
          new OpcuaOpenResponse(
              chunk,
              secureChannelId,
              securityPolicyUri,
              senderCertificate,
              receiverCertificateThumbprint,
              sequenceNumber,
              requestId,
              message);
      return opcuaOpenResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpcuaOpenResponse)) {
      return false;
    }
    OpcuaOpenResponse that = (OpcuaOpenResponse) o;
    return (getChunk() == that.getChunk())
        && (getSecureChannelId() == that.getSecureChannelId())
        && (getSecurityPolicyUri() == that.getSecurityPolicyUri())
        && (getSenderCertificate() == that.getSenderCertificate())
        && (getReceiverCertificateThumbprint() == that.getReceiverCertificateThumbprint())
        && (getSequenceNumber() == that.getSequenceNumber())
        && (getRequestId() == that.getRequestId())
        && (getMessage() == that.getMessage())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getChunk(),
        getSecureChannelId(),
        getSecurityPolicyUri(),
        getSenderCertificate(),
        getReceiverCertificateThumbprint(),
        getSequenceNumber(),
        getRequestId(),
        getMessage());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
