/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpenSecureChannelResponse extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "449";
  }

  // Properties.
  protected final ExtensionObjectDefinition responseHeader;
  protected final long serverProtocolVersion;
  protected final ExtensionObjectDefinition securityToken;
  protected final PascalByteString serverNonce;

  public OpenSecureChannelResponse(
      ExtensionObjectDefinition responseHeader,
      long serverProtocolVersion,
      ExtensionObjectDefinition securityToken,
      PascalByteString serverNonce) {
    super();
    this.responseHeader = responseHeader;
    this.serverProtocolVersion = serverProtocolVersion;
    this.securityToken = securityToken;
    this.serverNonce = serverNonce;
  }

  public ExtensionObjectDefinition getResponseHeader() {
    return responseHeader;
  }

  public long getServerProtocolVersion() {
    return serverProtocolVersion;
  }

  public ExtensionObjectDefinition getSecurityToken() {
    return securityToken;
  }

  public PascalByteString getServerNonce() {
    return serverNonce;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("OpenSecureChannelResponse");

    // Simple Field (responseHeader)
    writeSimpleField("responseHeader", responseHeader, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (serverProtocolVersion)
    writeSimpleField(
        "serverProtocolVersion", serverProtocolVersion, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (securityToken)
    writeSimpleField("securityToken", securityToken, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (serverNonce)
    writeSimpleField("serverNonce", serverNonce, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("OpenSecureChannelResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpenSecureChannelResponse _value = this;

    // Simple field (responseHeader)
    lengthInBits += responseHeader.getLengthInBits();

    // Simple field (serverProtocolVersion)
    lengthInBits += 32;

    // Simple field (securityToken)
    lengthInBits += securityToken.getLengthInBits();

    // Simple field (serverNonce)
    lengthInBits += serverNonce.getLengthInBits();

    return lengthInBits;
  }

  public static OpenSecureChannelResponseBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("OpenSecureChannelResponse");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    ExtensionObjectDefinition responseHeader =
        readSimpleField(
            "responseHeader",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("394")),
                readBuffer));

    long serverProtocolVersion =
        readSimpleField("serverProtocolVersion", readUnsignedLong(readBuffer, 32));

    ExtensionObjectDefinition securityToken =
        readSimpleField(
            "securityToken",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("443")),
                readBuffer));

    PascalByteString serverNonce =
        readSimpleField(
            "serverNonce",
            new DataReaderComplexDefault<>(
                () -> PascalByteString.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("OpenSecureChannelResponse");
    // Create the instance
    return new OpenSecureChannelResponseBuilder(
        responseHeader, serverProtocolVersion, securityToken, serverNonce);
  }

  public static class OpenSecureChannelResponseBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObjectDefinition responseHeader;
    private final long serverProtocolVersion;
    private final ExtensionObjectDefinition securityToken;
    private final PascalByteString serverNonce;

    public OpenSecureChannelResponseBuilder(
        ExtensionObjectDefinition responseHeader,
        long serverProtocolVersion,
        ExtensionObjectDefinition securityToken,
        PascalByteString serverNonce) {

      this.responseHeader = responseHeader;
      this.serverProtocolVersion = serverProtocolVersion;
      this.securityToken = securityToken;
      this.serverNonce = serverNonce;
    }

    public OpenSecureChannelResponse build() {
      OpenSecureChannelResponse openSecureChannelResponse =
          new OpenSecureChannelResponse(
              responseHeader, serverProtocolVersion, securityToken, serverNonce);
      return openSecureChannelResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpenSecureChannelResponse)) {
      return false;
    }
    OpenSecureChannelResponse that = (OpenSecureChannelResponse) o;
    return (getResponseHeader() == that.getResponseHeader())
        && (getServerProtocolVersion() == that.getServerProtocolVersion())
        && (getSecurityToken() == that.getSecurityToken())
        && (getServerNonce() == that.getServerNonce())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getResponseHeader(),
        getServerProtocolVersion(),
        getSecurityToken(),
        getServerNonce());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
