/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PublishResponse extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "829";
  }

  // Properties.
  protected final ExtensionObjectDefinition responseHeader;
  protected final long subscriptionId;
  protected final int noOfAvailableSequenceNumbers;
  protected final List<Long> availableSequenceNumbers;
  protected final boolean moreNotifications;
  protected final ExtensionObjectDefinition notificationMessage;
  protected final int noOfResults;
  protected final List<StatusCode> results;
  protected final int noOfDiagnosticInfos;
  protected final List<DiagnosticInfo> diagnosticInfos;
  // Reserved Fields
  private Short reservedField0;

  public PublishResponse(
      ExtensionObjectDefinition responseHeader,
      long subscriptionId,
      int noOfAvailableSequenceNumbers,
      List<Long> availableSequenceNumbers,
      boolean moreNotifications,
      ExtensionObjectDefinition notificationMessage,
      int noOfResults,
      List<StatusCode> results,
      int noOfDiagnosticInfos,
      List<DiagnosticInfo> diagnosticInfos) {
    super();
    this.responseHeader = responseHeader;
    this.subscriptionId = subscriptionId;
    this.noOfAvailableSequenceNumbers = noOfAvailableSequenceNumbers;
    this.availableSequenceNumbers = availableSequenceNumbers;
    this.moreNotifications = moreNotifications;
    this.notificationMessage = notificationMessage;
    this.noOfResults = noOfResults;
    this.results = results;
    this.noOfDiagnosticInfos = noOfDiagnosticInfos;
    this.diagnosticInfos = diagnosticInfos;
  }

  public ExtensionObjectDefinition getResponseHeader() {
    return responseHeader;
  }

  public long getSubscriptionId() {
    return subscriptionId;
  }

  public int getNoOfAvailableSequenceNumbers() {
    return noOfAvailableSequenceNumbers;
  }

  public List<Long> getAvailableSequenceNumbers() {
    return availableSequenceNumbers;
  }

  public boolean getMoreNotifications() {
    return moreNotifications;
  }

  public ExtensionObjectDefinition getNotificationMessage() {
    return notificationMessage;
  }

  public int getNoOfResults() {
    return noOfResults;
  }

  public List<StatusCode> getResults() {
    return results;
  }

  public int getNoOfDiagnosticInfos() {
    return noOfDiagnosticInfos;
  }

  public List<DiagnosticInfo> getDiagnosticInfos() {
    return diagnosticInfos;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("PublishResponse");

    // Simple Field (responseHeader)
    writeSimpleField("responseHeader", responseHeader, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (subscriptionId)
    writeSimpleField("subscriptionId", subscriptionId, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (noOfAvailableSequenceNumbers)
    writeSimpleField(
        "noOfAvailableSequenceNumbers",
        noOfAvailableSequenceNumbers,
        writeSignedInt(writeBuffer, 32));

    // Array Field (availableSequenceNumbers)
    writeSimpleTypeArrayField(
        "availableSequenceNumbers", availableSequenceNumbers, writeUnsignedLong(writeBuffer, 32));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (short) 0x00,
        writeUnsignedShort(writeBuffer, 7));

    // Simple Field (moreNotifications)
    writeSimpleField("moreNotifications", moreNotifications, writeBoolean(writeBuffer));

    // Simple Field (notificationMessage)
    writeSimpleField(
        "notificationMessage", notificationMessage, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfResults)
    writeSimpleField("noOfResults", noOfResults, writeSignedInt(writeBuffer, 32));

    // Array Field (results)
    writeComplexTypeArrayField("results", results, writeBuffer);

    // Simple Field (noOfDiagnosticInfos)
    writeSimpleField("noOfDiagnosticInfos", noOfDiagnosticInfos, writeSignedInt(writeBuffer, 32));

    // Array Field (diagnosticInfos)
    writeComplexTypeArrayField("diagnosticInfos", diagnosticInfos, writeBuffer);

    writeBuffer.popContext("PublishResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PublishResponse _value = this;

    // Simple field (responseHeader)
    lengthInBits += responseHeader.getLengthInBits();

    // Simple field (subscriptionId)
    lengthInBits += 32;

    // Simple field (noOfAvailableSequenceNumbers)
    lengthInBits += 32;

    // Array field
    if (availableSequenceNumbers != null) {
      lengthInBits += 32 * availableSequenceNumbers.size();
    }

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (moreNotifications)
    lengthInBits += 1;

    // Simple field (notificationMessage)
    lengthInBits += notificationMessage.getLengthInBits();

    // Simple field (noOfResults)
    lengthInBits += 32;

    // Array field
    if (results != null) {
      int i = 0;
      for (StatusCode element : results) {
        boolean last = ++i >= results.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (noOfDiagnosticInfos)
    lengthInBits += 32;

    // Array field
    if (diagnosticInfos != null) {
      int i = 0;
      for (DiagnosticInfo element : diagnosticInfos) {
        boolean last = ++i >= diagnosticInfos.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static PublishResponseBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier)
      throws ParseException {
    readBuffer.pullContext("PublishResponse");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    ExtensionObjectDefinition responseHeader =
        readSimpleField(
            "responseHeader",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("394")),
                readBuffer));

    long subscriptionId = readSimpleField("subscriptionId", readUnsignedLong(readBuffer, 32));

    int noOfAvailableSequenceNumbers =
        readSimpleField("noOfAvailableSequenceNumbers", readSignedInt(readBuffer, 32));

    List<Long> availableSequenceNumbers =
        readCountArrayField(
            "availableSequenceNumbers",
            readUnsignedLong(readBuffer, 32),
            noOfAvailableSequenceNumbers);

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 7), (short) 0x00);

    boolean moreNotifications = readSimpleField("moreNotifications", readBoolean(readBuffer));

    ExtensionObjectDefinition notificationMessage =
        readSimpleField(
            "notificationMessage",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("805")),
                readBuffer));

    int noOfResults = readSimpleField("noOfResults", readSignedInt(readBuffer, 32));

    List<StatusCode> results =
        readCountArrayField(
            "results",
            new DataReaderComplexDefault<>(() -> StatusCode.staticParse(readBuffer), readBuffer),
            noOfResults);

    int noOfDiagnosticInfos = readSimpleField("noOfDiagnosticInfos", readSignedInt(readBuffer, 32));

    List<DiagnosticInfo> diagnosticInfos =
        readCountArrayField(
            "diagnosticInfos",
            new DataReaderComplexDefault<>(
                () -> DiagnosticInfo.staticParse(readBuffer), readBuffer),
            noOfDiagnosticInfos);

    readBuffer.closeContext("PublishResponse");
    // Create the instance
    return new PublishResponseBuilder(
        responseHeader,
        subscriptionId,
        noOfAvailableSequenceNumbers,
        availableSequenceNumbers,
        moreNotifications,
        notificationMessage,
        noOfResults,
        results,
        noOfDiagnosticInfos,
        diagnosticInfos,
        reservedField0);
  }

  public static class PublishResponseBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObjectDefinition responseHeader;
    private final long subscriptionId;
    private final int noOfAvailableSequenceNumbers;
    private final List<Long> availableSequenceNumbers;
    private final boolean moreNotifications;
    private final ExtensionObjectDefinition notificationMessage;
    private final int noOfResults;
    private final List<StatusCode> results;
    private final int noOfDiagnosticInfos;
    private final List<DiagnosticInfo> diagnosticInfos;
    private final Short reservedField0;

    public PublishResponseBuilder(
        ExtensionObjectDefinition responseHeader,
        long subscriptionId,
        int noOfAvailableSequenceNumbers,
        List<Long> availableSequenceNumbers,
        boolean moreNotifications,
        ExtensionObjectDefinition notificationMessage,
        int noOfResults,
        List<StatusCode> results,
        int noOfDiagnosticInfos,
        List<DiagnosticInfo> diagnosticInfos,
        Short reservedField0) {
      this.responseHeader = responseHeader;
      this.subscriptionId = subscriptionId;
      this.noOfAvailableSequenceNumbers = noOfAvailableSequenceNumbers;
      this.availableSequenceNumbers = availableSequenceNumbers;
      this.moreNotifications = moreNotifications;
      this.notificationMessage = notificationMessage;
      this.noOfResults = noOfResults;
      this.results = results;
      this.noOfDiagnosticInfos = noOfDiagnosticInfos;
      this.diagnosticInfos = diagnosticInfos;
      this.reservedField0 = reservedField0;
    }

    public PublishResponse build() {
      PublishResponse publishResponse =
          new PublishResponse(
              responseHeader,
              subscriptionId,
              noOfAvailableSequenceNumbers,
              availableSequenceNumbers,
              moreNotifications,
              notificationMessage,
              noOfResults,
              results,
              noOfDiagnosticInfos,
              diagnosticInfos);
      publishResponse.reservedField0 = reservedField0;
      return publishResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PublishResponse)) {
      return false;
    }
    PublishResponse that = (PublishResponse) o;
    return (getResponseHeader() == that.getResponseHeader())
        && (getSubscriptionId() == that.getSubscriptionId())
        && (getNoOfAvailableSequenceNumbers() == that.getNoOfAvailableSequenceNumbers())
        && (getAvailableSequenceNumbers() == that.getAvailableSequenceNumbers())
        && (getMoreNotifications() == that.getMoreNotifications())
        && (getNotificationMessage() == that.getNotificationMessage())
        && (getNoOfResults() == that.getNoOfResults())
        && (getResults() == that.getResults())
        && (getNoOfDiagnosticInfos() == that.getNoOfDiagnosticInfos())
        && (getDiagnosticInfos() == that.getDiagnosticInfos())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getResponseHeader(),
        getSubscriptionId(),
        getNoOfAvailableSequenceNumbers(),
        getAvailableSequenceNumbers(),
        getMoreNotifications(),
        getNotificationMessage(),
        getNoOfResults(),
        getResults(),
        getNoOfDiagnosticInfos(),
        getDiagnosticInfos());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
