/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class QueryFirstRequest extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "615";
  }

  // Properties.
  protected final ExtensionObjectDefinition requestHeader;
  protected final ExtensionObjectDefinition view;
  protected final int noOfNodeTypes;
  protected final List<ExtensionObjectDefinition> nodeTypes;
  protected final ExtensionObjectDefinition filter;
  protected final long maxDataSetsToReturn;
  protected final long maxReferencesToReturn;

  public QueryFirstRequest(
      ExtensionObjectDefinition requestHeader,
      ExtensionObjectDefinition view,
      int noOfNodeTypes,
      List<ExtensionObjectDefinition> nodeTypes,
      ExtensionObjectDefinition filter,
      long maxDataSetsToReturn,
      long maxReferencesToReturn) {
    super();
    this.requestHeader = requestHeader;
    this.view = view;
    this.noOfNodeTypes = noOfNodeTypes;
    this.nodeTypes = nodeTypes;
    this.filter = filter;
    this.maxDataSetsToReturn = maxDataSetsToReturn;
    this.maxReferencesToReturn = maxReferencesToReturn;
  }

  public ExtensionObjectDefinition getRequestHeader() {
    return requestHeader;
  }

  public ExtensionObjectDefinition getView() {
    return view;
  }

  public int getNoOfNodeTypes() {
    return noOfNodeTypes;
  }

  public List<ExtensionObjectDefinition> getNodeTypes() {
    return nodeTypes;
  }

  public ExtensionObjectDefinition getFilter() {
    return filter;
  }

  public long getMaxDataSetsToReturn() {
    return maxDataSetsToReturn;
  }

  public long getMaxReferencesToReturn() {
    return maxReferencesToReturn;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("QueryFirstRequest");

    // Simple Field (requestHeader)
    writeSimpleField("requestHeader", requestHeader, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (view)
    writeSimpleField("view", view, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfNodeTypes)
    writeSimpleField("noOfNodeTypes", noOfNodeTypes, writeSignedInt(writeBuffer, 32));

    // Array Field (nodeTypes)
    writeComplexTypeArrayField("nodeTypes", nodeTypes, writeBuffer);

    // Simple Field (filter)
    writeSimpleField("filter", filter, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (maxDataSetsToReturn)
    writeSimpleField(
        "maxDataSetsToReturn", maxDataSetsToReturn, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (maxReferencesToReturn)
    writeSimpleField(
        "maxReferencesToReturn", maxReferencesToReturn, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("QueryFirstRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    QueryFirstRequest _value = this;

    // Simple field (requestHeader)
    lengthInBits += requestHeader.getLengthInBits();

    // Simple field (view)
    lengthInBits += view.getLengthInBits();

    // Simple field (noOfNodeTypes)
    lengthInBits += 32;

    // Array field
    if (nodeTypes != null) {
      int i = 0;
      for (ExtensionObjectDefinition element : nodeTypes) {
        boolean last = ++i >= nodeTypes.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (filter)
    lengthInBits += filter.getLengthInBits();

    // Simple field (maxDataSetsToReturn)
    lengthInBits += 32;

    // Simple field (maxReferencesToReturn)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static QueryFirstRequestBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("QueryFirstRequest");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    ExtensionObjectDefinition requestHeader =
        readSimpleField(
            "requestHeader",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("391")),
                readBuffer));

    ExtensionObjectDefinition view =
        readSimpleField(
            "view",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("513")),
                readBuffer));

    int noOfNodeTypes = readSimpleField("noOfNodeTypes", readSignedInt(readBuffer, 32));

    List<ExtensionObjectDefinition> nodeTypes =
        readCountArrayField(
            "nodeTypes",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("575")),
                readBuffer),
            noOfNodeTypes);

    ExtensionObjectDefinition filter =
        readSimpleField(
            "filter",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("588")),
                readBuffer));

    long maxDataSetsToReturn =
        readSimpleField("maxDataSetsToReturn", readUnsignedLong(readBuffer, 32));

    long maxReferencesToReturn =
        readSimpleField("maxReferencesToReturn", readUnsignedLong(readBuffer, 32));

    readBuffer.closeContext("QueryFirstRequest");
    // Create the instance
    return new QueryFirstRequestBuilder(
        requestHeader,
        view,
        noOfNodeTypes,
        nodeTypes,
        filter,
        maxDataSetsToReturn,
        maxReferencesToReturn);
  }

  public static class QueryFirstRequestBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObjectDefinition requestHeader;
    private final ExtensionObjectDefinition view;
    private final int noOfNodeTypes;
    private final List<ExtensionObjectDefinition> nodeTypes;
    private final ExtensionObjectDefinition filter;
    private final long maxDataSetsToReturn;
    private final long maxReferencesToReturn;

    public QueryFirstRequestBuilder(
        ExtensionObjectDefinition requestHeader,
        ExtensionObjectDefinition view,
        int noOfNodeTypes,
        List<ExtensionObjectDefinition> nodeTypes,
        ExtensionObjectDefinition filter,
        long maxDataSetsToReturn,
        long maxReferencesToReturn) {

      this.requestHeader = requestHeader;
      this.view = view;
      this.noOfNodeTypes = noOfNodeTypes;
      this.nodeTypes = nodeTypes;
      this.filter = filter;
      this.maxDataSetsToReturn = maxDataSetsToReturn;
      this.maxReferencesToReturn = maxReferencesToReturn;
    }

    public QueryFirstRequest build() {
      QueryFirstRequest queryFirstRequest =
          new QueryFirstRequest(
              requestHeader,
              view,
              noOfNodeTypes,
              nodeTypes,
              filter,
              maxDataSetsToReturn,
              maxReferencesToReturn);
      return queryFirstRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof QueryFirstRequest)) {
      return false;
    }
    QueryFirstRequest that = (QueryFirstRequest) o;
    return (getRequestHeader() == that.getRequestHeader())
        && (getView() == that.getView())
        && (getNoOfNodeTypes() == that.getNoOfNodeTypes())
        && (getNodeTypes() == that.getNodeTypes())
        && (getFilter() == that.getFilter())
        && (getMaxDataSetsToReturn() == that.getMaxDataSetsToReturn())
        && (getMaxReferencesToReturn() == that.getMaxReferencesToReturn())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getRequestHeader(),
        getView(),
        getNoOfNodeTypes(),
        getNodeTypes(),
        getFilter(),
        getMaxDataSetsToReturn(),
        getMaxReferencesToReturn());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
