/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ReferenceNode extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "287";
  }

  // Properties.
  protected final NodeId referenceTypeId;
  protected final boolean isInverse;
  protected final ExpandedNodeId targetId;
  // Reserved Fields
  private Short reservedField0;

  public ReferenceNode(NodeId referenceTypeId, boolean isInverse, ExpandedNodeId targetId) {
    super();
    this.referenceTypeId = referenceTypeId;
    this.isInverse = isInverse;
    this.targetId = targetId;
  }

  public NodeId getReferenceTypeId() {
    return referenceTypeId;
  }

  public boolean getIsInverse() {
    return isInverse;
  }

  public ExpandedNodeId getTargetId() {
    return targetId;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("ReferenceNode");

    // Simple Field (referenceTypeId)
    writeSimpleField(
        "referenceTypeId", referenceTypeId, new DataWriterComplexDefault<>(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (short) 0x00,
        writeUnsignedShort(writeBuffer, 7));

    // Simple Field (isInverse)
    writeSimpleField("isInverse", isInverse, writeBoolean(writeBuffer));

    // Simple Field (targetId)
    writeSimpleField("targetId", targetId, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("ReferenceNode");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ReferenceNode _value = this;

    // Simple field (referenceTypeId)
    lengthInBits += referenceTypeId.getLengthInBits();

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (isInverse)
    lengthInBits += 1;

    // Simple field (targetId)
    lengthInBits += targetId.getLengthInBits();

    return lengthInBits;
  }

  public static ReferenceNodeBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier)
      throws ParseException {
    readBuffer.pullContext("ReferenceNode");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    NodeId referenceTypeId =
        readSimpleField(
            "referenceTypeId",
            new DataReaderComplexDefault<>(() -> NodeId.staticParse(readBuffer), readBuffer));

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 7), (short) 0x00);

    boolean isInverse = readSimpleField("isInverse", readBoolean(readBuffer));

    ExpandedNodeId targetId =
        readSimpleField(
            "targetId",
            new DataReaderComplexDefault<>(
                () -> ExpandedNodeId.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("ReferenceNode");
    // Create the instance
    return new ReferenceNodeBuilder(referenceTypeId, isInverse, targetId, reservedField0);
  }

  public static class ReferenceNodeBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final NodeId referenceTypeId;
    private final boolean isInverse;
    private final ExpandedNodeId targetId;
    private final Short reservedField0;

    public ReferenceNodeBuilder(
        NodeId referenceTypeId, boolean isInverse, ExpandedNodeId targetId, Short reservedField0) {
      this.referenceTypeId = referenceTypeId;
      this.isInverse = isInverse;
      this.targetId = targetId;
      this.reservedField0 = reservedField0;
    }

    public ReferenceNode build() {
      ReferenceNode referenceNode = new ReferenceNode(referenceTypeId, isInverse, targetId);
      referenceNode.reservedField0 = reservedField0;
      return referenceNode;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ReferenceNode)) {
      return false;
    }
    ReferenceNode that = (ReferenceNode) o;
    return (getReferenceTypeId() == that.getReferenceTypeId())
        && (getIsInverse() == that.getIsInverse())
        && (getTargetId() == that.getTargetId())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getReferenceTypeId(), getIsInverse(), getTargetId());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
