/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class RegisterServer2Response extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "12196";
  }

  // Properties.
  protected final ExtensionObjectDefinition responseHeader;
  protected final int noOfConfigurationResults;
  protected final List<StatusCode> configurationResults;
  protected final int noOfDiagnosticInfos;
  protected final List<DiagnosticInfo> diagnosticInfos;

  public RegisterServer2Response(
      ExtensionObjectDefinition responseHeader,
      int noOfConfigurationResults,
      List<StatusCode> configurationResults,
      int noOfDiagnosticInfos,
      List<DiagnosticInfo> diagnosticInfos) {
    super();
    this.responseHeader = responseHeader;
    this.noOfConfigurationResults = noOfConfigurationResults;
    this.configurationResults = configurationResults;
    this.noOfDiagnosticInfos = noOfDiagnosticInfos;
    this.diagnosticInfos = diagnosticInfos;
  }

  public ExtensionObjectDefinition getResponseHeader() {
    return responseHeader;
  }

  public int getNoOfConfigurationResults() {
    return noOfConfigurationResults;
  }

  public List<StatusCode> getConfigurationResults() {
    return configurationResults;
  }

  public int getNoOfDiagnosticInfos() {
    return noOfDiagnosticInfos;
  }

  public List<DiagnosticInfo> getDiagnosticInfos() {
    return diagnosticInfos;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("RegisterServer2Response");

    // Simple Field (responseHeader)
    writeSimpleField("responseHeader", responseHeader, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfConfigurationResults)
    writeSimpleField(
        "noOfConfigurationResults", noOfConfigurationResults, writeSignedInt(writeBuffer, 32));

    // Array Field (configurationResults)
    writeComplexTypeArrayField("configurationResults", configurationResults, writeBuffer);

    // Simple Field (noOfDiagnosticInfos)
    writeSimpleField("noOfDiagnosticInfos", noOfDiagnosticInfos, writeSignedInt(writeBuffer, 32));

    // Array Field (diagnosticInfos)
    writeComplexTypeArrayField("diagnosticInfos", diagnosticInfos, writeBuffer);

    writeBuffer.popContext("RegisterServer2Response");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    RegisterServer2Response _value = this;

    // Simple field (responseHeader)
    lengthInBits += responseHeader.getLengthInBits();

    // Simple field (noOfConfigurationResults)
    lengthInBits += 32;

    // Array field
    if (configurationResults != null) {
      int i = 0;
      for (StatusCode element : configurationResults) {
        boolean last = ++i >= configurationResults.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (noOfDiagnosticInfos)
    lengthInBits += 32;

    // Array field
    if (diagnosticInfos != null) {
      int i = 0;
      for (DiagnosticInfo element : diagnosticInfos) {
        boolean last = ++i >= diagnosticInfos.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static RegisterServer2ResponseBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("RegisterServer2Response");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    ExtensionObjectDefinition responseHeader =
        readSimpleField(
            "responseHeader",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("394")),
                readBuffer));

    int noOfConfigurationResults =
        readSimpleField("noOfConfigurationResults", readSignedInt(readBuffer, 32));

    List<StatusCode> configurationResults =
        readCountArrayField(
            "configurationResults",
            new DataReaderComplexDefault<>(() -> StatusCode.staticParse(readBuffer), readBuffer),
            noOfConfigurationResults);

    int noOfDiagnosticInfos = readSimpleField("noOfDiagnosticInfos", readSignedInt(readBuffer, 32));

    List<DiagnosticInfo> diagnosticInfos =
        readCountArrayField(
            "diagnosticInfos",
            new DataReaderComplexDefault<>(
                () -> DiagnosticInfo.staticParse(readBuffer), readBuffer),
            noOfDiagnosticInfos);

    readBuffer.closeContext("RegisterServer2Response");
    // Create the instance
    return new RegisterServer2ResponseBuilder(
        responseHeader,
        noOfConfigurationResults,
        configurationResults,
        noOfDiagnosticInfos,
        diagnosticInfos);
  }

  public static class RegisterServer2ResponseBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObjectDefinition responseHeader;
    private final int noOfConfigurationResults;
    private final List<StatusCode> configurationResults;
    private final int noOfDiagnosticInfos;
    private final List<DiagnosticInfo> diagnosticInfos;

    public RegisterServer2ResponseBuilder(
        ExtensionObjectDefinition responseHeader,
        int noOfConfigurationResults,
        List<StatusCode> configurationResults,
        int noOfDiagnosticInfos,
        List<DiagnosticInfo> diagnosticInfos) {

      this.responseHeader = responseHeader;
      this.noOfConfigurationResults = noOfConfigurationResults;
      this.configurationResults = configurationResults;
      this.noOfDiagnosticInfos = noOfDiagnosticInfos;
      this.diagnosticInfos = diagnosticInfos;
    }

    public RegisterServer2Response build() {
      RegisterServer2Response registerServer2Response =
          new RegisterServer2Response(
              responseHeader,
              noOfConfigurationResults,
              configurationResults,
              noOfDiagnosticInfos,
              diagnosticInfos);
      return registerServer2Response;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof RegisterServer2Response)) {
      return false;
    }
    RegisterServer2Response that = (RegisterServer2Response) o;
    return (getResponseHeader() == that.getResponseHeader())
        && (getNoOfConfigurationResults() == that.getNoOfConfigurationResults())
        && (getConfigurationResults() == that.getConfigurationResults())
        && (getNoOfDiagnosticInfos() == that.getNoOfDiagnosticInfos())
        && (getDiagnosticInfos() == that.getDiagnosticInfos())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getResponseHeader(),
        getNoOfConfigurationResults(),
        getConfigurationResults(),
        getNoOfDiagnosticInfos(),
        getDiagnosticInfos());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
