/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SessionDiagnosticsDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "867";
  }

  // Properties.
  protected final NodeId sessionId;
  protected final PascalString sessionName;
  protected final ExtensionObjectDefinition clientDescription;
  protected final PascalString serverUri;
  protected final PascalString endpointUrl;
  protected final int noOfLocaleIds;
  protected final List<PascalString> localeIds;
  protected final double actualSessionTimeout;
  protected final long maxResponseMessageSize;
  protected final long clientConnectionTime;
  protected final long clientLastContactTime;
  protected final long currentSubscriptionsCount;
  protected final long currentMonitoredItemsCount;
  protected final long currentPublishRequestsInQueue;
  protected final ExtensionObjectDefinition totalRequestCount;
  protected final long unauthorizedRequestCount;
  protected final ExtensionObjectDefinition readCount;
  protected final ExtensionObjectDefinition historyReadCount;
  protected final ExtensionObjectDefinition writeCount;
  protected final ExtensionObjectDefinition historyUpdateCount;
  protected final ExtensionObjectDefinition callCount;
  protected final ExtensionObjectDefinition createMonitoredItemsCount;
  protected final ExtensionObjectDefinition modifyMonitoredItemsCount;
  protected final ExtensionObjectDefinition setMonitoringModeCount;
  protected final ExtensionObjectDefinition setTriggeringCount;
  protected final ExtensionObjectDefinition deleteMonitoredItemsCount;
  protected final ExtensionObjectDefinition createSubscriptionCount;
  protected final ExtensionObjectDefinition modifySubscriptionCount;
  protected final ExtensionObjectDefinition setPublishingModeCount;
  protected final ExtensionObjectDefinition publishCount;
  protected final ExtensionObjectDefinition republishCount;
  protected final ExtensionObjectDefinition transferSubscriptionsCount;
  protected final ExtensionObjectDefinition deleteSubscriptionsCount;
  protected final ExtensionObjectDefinition addNodesCount;
  protected final ExtensionObjectDefinition addReferencesCount;
  protected final ExtensionObjectDefinition deleteNodesCount;
  protected final ExtensionObjectDefinition deleteReferencesCount;
  protected final ExtensionObjectDefinition browseCount;
  protected final ExtensionObjectDefinition browseNextCount;
  protected final ExtensionObjectDefinition translateBrowsePathsToNodeIdsCount;
  protected final ExtensionObjectDefinition queryFirstCount;
  protected final ExtensionObjectDefinition queryNextCount;
  protected final ExtensionObjectDefinition registerNodesCount;
  protected final ExtensionObjectDefinition unregisterNodesCount;

  public SessionDiagnosticsDataType(
      NodeId sessionId,
      PascalString sessionName,
      ExtensionObjectDefinition clientDescription,
      PascalString serverUri,
      PascalString endpointUrl,
      int noOfLocaleIds,
      List<PascalString> localeIds,
      double actualSessionTimeout,
      long maxResponseMessageSize,
      long clientConnectionTime,
      long clientLastContactTime,
      long currentSubscriptionsCount,
      long currentMonitoredItemsCount,
      long currentPublishRequestsInQueue,
      ExtensionObjectDefinition totalRequestCount,
      long unauthorizedRequestCount,
      ExtensionObjectDefinition readCount,
      ExtensionObjectDefinition historyReadCount,
      ExtensionObjectDefinition writeCount,
      ExtensionObjectDefinition historyUpdateCount,
      ExtensionObjectDefinition callCount,
      ExtensionObjectDefinition createMonitoredItemsCount,
      ExtensionObjectDefinition modifyMonitoredItemsCount,
      ExtensionObjectDefinition setMonitoringModeCount,
      ExtensionObjectDefinition setTriggeringCount,
      ExtensionObjectDefinition deleteMonitoredItemsCount,
      ExtensionObjectDefinition createSubscriptionCount,
      ExtensionObjectDefinition modifySubscriptionCount,
      ExtensionObjectDefinition setPublishingModeCount,
      ExtensionObjectDefinition publishCount,
      ExtensionObjectDefinition republishCount,
      ExtensionObjectDefinition transferSubscriptionsCount,
      ExtensionObjectDefinition deleteSubscriptionsCount,
      ExtensionObjectDefinition addNodesCount,
      ExtensionObjectDefinition addReferencesCount,
      ExtensionObjectDefinition deleteNodesCount,
      ExtensionObjectDefinition deleteReferencesCount,
      ExtensionObjectDefinition browseCount,
      ExtensionObjectDefinition browseNextCount,
      ExtensionObjectDefinition translateBrowsePathsToNodeIdsCount,
      ExtensionObjectDefinition queryFirstCount,
      ExtensionObjectDefinition queryNextCount,
      ExtensionObjectDefinition registerNodesCount,
      ExtensionObjectDefinition unregisterNodesCount) {
    super();
    this.sessionId = sessionId;
    this.sessionName = sessionName;
    this.clientDescription = clientDescription;
    this.serverUri = serverUri;
    this.endpointUrl = endpointUrl;
    this.noOfLocaleIds = noOfLocaleIds;
    this.localeIds = localeIds;
    this.actualSessionTimeout = actualSessionTimeout;
    this.maxResponseMessageSize = maxResponseMessageSize;
    this.clientConnectionTime = clientConnectionTime;
    this.clientLastContactTime = clientLastContactTime;
    this.currentSubscriptionsCount = currentSubscriptionsCount;
    this.currentMonitoredItemsCount = currentMonitoredItemsCount;
    this.currentPublishRequestsInQueue = currentPublishRequestsInQueue;
    this.totalRequestCount = totalRequestCount;
    this.unauthorizedRequestCount = unauthorizedRequestCount;
    this.readCount = readCount;
    this.historyReadCount = historyReadCount;
    this.writeCount = writeCount;
    this.historyUpdateCount = historyUpdateCount;
    this.callCount = callCount;
    this.createMonitoredItemsCount = createMonitoredItemsCount;
    this.modifyMonitoredItemsCount = modifyMonitoredItemsCount;
    this.setMonitoringModeCount = setMonitoringModeCount;
    this.setTriggeringCount = setTriggeringCount;
    this.deleteMonitoredItemsCount = deleteMonitoredItemsCount;
    this.createSubscriptionCount = createSubscriptionCount;
    this.modifySubscriptionCount = modifySubscriptionCount;
    this.setPublishingModeCount = setPublishingModeCount;
    this.publishCount = publishCount;
    this.republishCount = republishCount;
    this.transferSubscriptionsCount = transferSubscriptionsCount;
    this.deleteSubscriptionsCount = deleteSubscriptionsCount;
    this.addNodesCount = addNodesCount;
    this.addReferencesCount = addReferencesCount;
    this.deleteNodesCount = deleteNodesCount;
    this.deleteReferencesCount = deleteReferencesCount;
    this.browseCount = browseCount;
    this.browseNextCount = browseNextCount;
    this.translateBrowsePathsToNodeIdsCount = translateBrowsePathsToNodeIdsCount;
    this.queryFirstCount = queryFirstCount;
    this.queryNextCount = queryNextCount;
    this.registerNodesCount = registerNodesCount;
    this.unregisterNodesCount = unregisterNodesCount;
  }

  public NodeId getSessionId() {
    return sessionId;
  }

  public PascalString getSessionName() {
    return sessionName;
  }

  public ExtensionObjectDefinition getClientDescription() {
    return clientDescription;
  }

  public PascalString getServerUri() {
    return serverUri;
  }

  public PascalString getEndpointUrl() {
    return endpointUrl;
  }

  public int getNoOfLocaleIds() {
    return noOfLocaleIds;
  }

  public List<PascalString> getLocaleIds() {
    return localeIds;
  }

  public double getActualSessionTimeout() {
    return actualSessionTimeout;
  }

  public long getMaxResponseMessageSize() {
    return maxResponseMessageSize;
  }

  public long getClientConnectionTime() {
    return clientConnectionTime;
  }

  public long getClientLastContactTime() {
    return clientLastContactTime;
  }

  public long getCurrentSubscriptionsCount() {
    return currentSubscriptionsCount;
  }

  public long getCurrentMonitoredItemsCount() {
    return currentMonitoredItemsCount;
  }

  public long getCurrentPublishRequestsInQueue() {
    return currentPublishRequestsInQueue;
  }

  public ExtensionObjectDefinition getTotalRequestCount() {
    return totalRequestCount;
  }

  public long getUnauthorizedRequestCount() {
    return unauthorizedRequestCount;
  }

  public ExtensionObjectDefinition getReadCount() {
    return readCount;
  }

  public ExtensionObjectDefinition getHistoryReadCount() {
    return historyReadCount;
  }

  public ExtensionObjectDefinition getWriteCount() {
    return writeCount;
  }

  public ExtensionObjectDefinition getHistoryUpdateCount() {
    return historyUpdateCount;
  }

  public ExtensionObjectDefinition getCallCount() {
    return callCount;
  }

  public ExtensionObjectDefinition getCreateMonitoredItemsCount() {
    return createMonitoredItemsCount;
  }

  public ExtensionObjectDefinition getModifyMonitoredItemsCount() {
    return modifyMonitoredItemsCount;
  }

  public ExtensionObjectDefinition getSetMonitoringModeCount() {
    return setMonitoringModeCount;
  }

  public ExtensionObjectDefinition getSetTriggeringCount() {
    return setTriggeringCount;
  }

  public ExtensionObjectDefinition getDeleteMonitoredItemsCount() {
    return deleteMonitoredItemsCount;
  }

  public ExtensionObjectDefinition getCreateSubscriptionCount() {
    return createSubscriptionCount;
  }

  public ExtensionObjectDefinition getModifySubscriptionCount() {
    return modifySubscriptionCount;
  }

  public ExtensionObjectDefinition getSetPublishingModeCount() {
    return setPublishingModeCount;
  }

  public ExtensionObjectDefinition getPublishCount() {
    return publishCount;
  }

  public ExtensionObjectDefinition getRepublishCount() {
    return republishCount;
  }

  public ExtensionObjectDefinition getTransferSubscriptionsCount() {
    return transferSubscriptionsCount;
  }

  public ExtensionObjectDefinition getDeleteSubscriptionsCount() {
    return deleteSubscriptionsCount;
  }

  public ExtensionObjectDefinition getAddNodesCount() {
    return addNodesCount;
  }

  public ExtensionObjectDefinition getAddReferencesCount() {
    return addReferencesCount;
  }

  public ExtensionObjectDefinition getDeleteNodesCount() {
    return deleteNodesCount;
  }

  public ExtensionObjectDefinition getDeleteReferencesCount() {
    return deleteReferencesCount;
  }

  public ExtensionObjectDefinition getBrowseCount() {
    return browseCount;
  }

  public ExtensionObjectDefinition getBrowseNextCount() {
    return browseNextCount;
  }

  public ExtensionObjectDefinition getTranslateBrowsePathsToNodeIdsCount() {
    return translateBrowsePathsToNodeIdsCount;
  }

  public ExtensionObjectDefinition getQueryFirstCount() {
    return queryFirstCount;
  }

  public ExtensionObjectDefinition getQueryNextCount() {
    return queryNextCount;
  }

  public ExtensionObjectDefinition getRegisterNodesCount() {
    return registerNodesCount;
  }

  public ExtensionObjectDefinition getUnregisterNodesCount() {
    return unregisterNodesCount;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("SessionDiagnosticsDataType");

    // Simple Field (sessionId)
    writeSimpleField("sessionId", sessionId, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (sessionName)
    writeSimpleField("sessionName", sessionName, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (clientDescription)
    writeSimpleField(
        "clientDescription", clientDescription, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (serverUri)
    writeSimpleField("serverUri", serverUri, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (endpointUrl)
    writeSimpleField("endpointUrl", endpointUrl, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfLocaleIds)
    writeSimpleField("noOfLocaleIds", noOfLocaleIds, writeSignedInt(writeBuffer, 32));

    // Array Field (localeIds)
    writeComplexTypeArrayField("localeIds", localeIds, writeBuffer);

    // Simple Field (actualSessionTimeout)
    writeSimpleField("actualSessionTimeout", actualSessionTimeout, writeDouble(writeBuffer, 64));

    // Simple Field (maxResponseMessageSize)
    writeSimpleField(
        "maxResponseMessageSize", maxResponseMessageSize, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (clientConnectionTime)
    writeSimpleField(
        "clientConnectionTime", clientConnectionTime, writeSignedLong(writeBuffer, 64));

    // Simple Field (clientLastContactTime)
    writeSimpleField(
        "clientLastContactTime", clientLastContactTime, writeSignedLong(writeBuffer, 64));

    // Simple Field (currentSubscriptionsCount)
    writeSimpleField(
        "currentSubscriptionsCount", currentSubscriptionsCount, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (currentMonitoredItemsCount)
    writeSimpleField(
        "currentMonitoredItemsCount",
        currentMonitoredItemsCount,
        writeUnsignedLong(writeBuffer, 32));

    // Simple Field (currentPublishRequestsInQueue)
    writeSimpleField(
        "currentPublishRequestsInQueue",
        currentPublishRequestsInQueue,
        writeUnsignedLong(writeBuffer, 32));

    // Simple Field (totalRequestCount)
    writeSimpleField(
        "totalRequestCount", totalRequestCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (unauthorizedRequestCount)
    writeSimpleField(
        "unauthorizedRequestCount", unauthorizedRequestCount, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (readCount)
    writeSimpleField("readCount", readCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (historyReadCount)
    writeSimpleField(
        "historyReadCount", historyReadCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (writeCount)
    writeSimpleField("writeCount", writeCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (historyUpdateCount)
    writeSimpleField(
        "historyUpdateCount", historyUpdateCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (callCount)
    writeSimpleField("callCount", callCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (createMonitoredItemsCount)
    writeSimpleField(
        "createMonitoredItemsCount",
        createMonitoredItemsCount,
        new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (modifyMonitoredItemsCount)
    writeSimpleField(
        "modifyMonitoredItemsCount",
        modifyMonitoredItemsCount,
        new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (setMonitoringModeCount)
    writeSimpleField(
        "setMonitoringModeCount",
        setMonitoringModeCount,
        new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (setTriggeringCount)
    writeSimpleField(
        "setTriggeringCount", setTriggeringCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (deleteMonitoredItemsCount)
    writeSimpleField(
        "deleteMonitoredItemsCount",
        deleteMonitoredItemsCount,
        new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (createSubscriptionCount)
    writeSimpleField(
        "createSubscriptionCount",
        createSubscriptionCount,
        new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (modifySubscriptionCount)
    writeSimpleField(
        "modifySubscriptionCount",
        modifySubscriptionCount,
        new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (setPublishingModeCount)
    writeSimpleField(
        "setPublishingModeCount",
        setPublishingModeCount,
        new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (publishCount)
    writeSimpleField("publishCount", publishCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (republishCount)
    writeSimpleField("republishCount", republishCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (transferSubscriptionsCount)
    writeSimpleField(
        "transferSubscriptionsCount",
        transferSubscriptionsCount,
        new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (deleteSubscriptionsCount)
    writeSimpleField(
        "deleteSubscriptionsCount",
        deleteSubscriptionsCount,
        new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (addNodesCount)
    writeSimpleField("addNodesCount", addNodesCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (addReferencesCount)
    writeSimpleField(
        "addReferencesCount", addReferencesCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (deleteNodesCount)
    writeSimpleField(
        "deleteNodesCount", deleteNodesCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (deleteReferencesCount)
    writeSimpleField(
        "deleteReferencesCount",
        deleteReferencesCount,
        new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (browseCount)
    writeSimpleField("browseCount", browseCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (browseNextCount)
    writeSimpleField(
        "browseNextCount", browseNextCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (translateBrowsePathsToNodeIdsCount)
    writeSimpleField(
        "translateBrowsePathsToNodeIdsCount",
        translateBrowsePathsToNodeIdsCount,
        new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (queryFirstCount)
    writeSimpleField(
        "queryFirstCount", queryFirstCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (queryNextCount)
    writeSimpleField("queryNextCount", queryNextCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (registerNodesCount)
    writeSimpleField(
        "registerNodesCount", registerNodesCount, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (unregisterNodesCount)
    writeSimpleField(
        "unregisterNodesCount", unregisterNodesCount, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("SessionDiagnosticsDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SessionDiagnosticsDataType _value = this;

    // Simple field (sessionId)
    lengthInBits += sessionId.getLengthInBits();

    // Simple field (sessionName)
    lengthInBits += sessionName.getLengthInBits();

    // Simple field (clientDescription)
    lengthInBits += clientDescription.getLengthInBits();

    // Simple field (serverUri)
    lengthInBits += serverUri.getLengthInBits();

    // Simple field (endpointUrl)
    lengthInBits += endpointUrl.getLengthInBits();

    // Simple field (noOfLocaleIds)
    lengthInBits += 32;

    // Array field
    if (localeIds != null) {
      int i = 0;
      for (PascalString element : localeIds) {
        boolean last = ++i >= localeIds.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (actualSessionTimeout)
    lengthInBits += 64;

    // Simple field (maxResponseMessageSize)
    lengthInBits += 32;

    // Simple field (clientConnectionTime)
    lengthInBits += 64;

    // Simple field (clientLastContactTime)
    lengthInBits += 64;

    // Simple field (currentSubscriptionsCount)
    lengthInBits += 32;

    // Simple field (currentMonitoredItemsCount)
    lengthInBits += 32;

    // Simple field (currentPublishRequestsInQueue)
    lengthInBits += 32;

    // Simple field (totalRequestCount)
    lengthInBits += totalRequestCount.getLengthInBits();

    // Simple field (unauthorizedRequestCount)
    lengthInBits += 32;

    // Simple field (readCount)
    lengthInBits += readCount.getLengthInBits();

    // Simple field (historyReadCount)
    lengthInBits += historyReadCount.getLengthInBits();

    // Simple field (writeCount)
    lengthInBits += writeCount.getLengthInBits();

    // Simple field (historyUpdateCount)
    lengthInBits += historyUpdateCount.getLengthInBits();

    // Simple field (callCount)
    lengthInBits += callCount.getLengthInBits();

    // Simple field (createMonitoredItemsCount)
    lengthInBits += createMonitoredItemsCount.getLengthInBits();

    // Simple field (modifyMonitoredItemsCount)
    lengthInBits += modifyMonitoredItemsCount.getLengthInBits();

    // Simple field (setMonitoringModeCount)
    lengthInBits += setMonitoringModeCount.getLengthInBits();

    // Simple field (setTriggeringCount)
    lengthInBits += setTriggeringCount.getLengthInBits();

    // Simple field (deleteMonitoredItemsCount)
    lengthInBits += deleteMonitoredItemsCount.getLengthInBits();

    // Simple field (createSubscriptionCount)
    lengthInBits += createSubscriptionCount.getLengthInBits();

    // Simple field (modifySubscriptionCount)
    lengthInBits += modifySubscriptionCount.getLengthInBits();

    // Simple field (setPublishingModeCount)
    lengthInBits += setPublishingModeCount.getLengthInBits();

    // Simple field (publishCount)
    lengthInBits += publishCount.getLengthInBits();

    // Simple field (republishCount)
    lengthInBits += republishCount.getLengthInBits();

    // Simple field (transferSubscriptionsCount)
    lengthInBits += transferSubscriptionsCount.getLengthInBits();

    // Simple field (deleteSubscriptionsCount)
    lengthInBits += deleteSubscriptionsCount.getLengthInBits();

    // Simple field (addNodesCount)
    lengthInBits += addNodesCount.getLengthInBits();

    // Simple field (addReferencesCount)
    lengthInBits += addReferencesCount.getLengthInBits();

    // Simple field (deleteNodesCount)
    lengthInBits += deleteNodesCount.getLengthInBits();

    // Simple field (deleteReferencesCount)
    lengthInBits += deleteReferencesCount.getLengthInBits();

    // Simple field (browseCount)
    lengthInBits += browseCount.getLengthInBits();

    // Simple field (browseNextCount)
    lengthInBits += browseNextCount.getLengthInBits();

    // Simple field (translateBrowsePathsToNodeIdsCount)
    lengthInBits += translateBrowsePathsToNodeIdsCount.getLengthInBits();

    // Simple field (queryFirstCount)
    lengthInBits += queryFirstCount.getLengthInBits();

    // Simple field (queryNextCount)
    lengthInBits += queryNextCount.getLengthInBits();

    // Simple field (registerNodesCount)
    lengthInBits += registerNodesCount.getLengthInBits();

    // Simple field (unregisterNodesCount)
    lengthInBits += unregisterNodesCount.getLengthInBits();

    return lengthInBits;
  }

  public static SessionDiagnosticsDataTypeBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("SessionDiagnosticsDataType");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    NodeId sessionId =
        readSimpleField(
            "sessionId",
            new DataReaderComplexDefault<>(() -> NodeId.staticParse(readBuffer), readBuffer));

    PascalString sessionName =
        readSimpleField(
            "sessionName",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    ExtensionObjectDefinition clientDescription =
        readSimpleField(
            "clientDescription",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("310")),
                readBuffer));

    PascalString serverUri =
        readSimpleField(
            "serverUri",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString endpointUrl =
        readSimpleField(
            "endpointUrl",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfLocaleIds = readSimpleField("noOfLocaleIds", readSignedInt(readBuffer, 32));

    List<PascalString> localeIds =
        readCountArrayField(
            "localeIds",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfLocaleIds);

    double actualSessionTimeout =
        readSimpleField("actualSessionTimeout", readDouble(readBuffer, 64));

    long maxResponseMessageSize =
        readSimpleField("maxResponseMessageSize", readUnsignedLong(readBuffer, 32));

    long clientConnectionTime =
        readSimpleField("clientConnectionTime", readSignedLong(readBuffer, 64));

    long clientLastContactTime =
        readSimpleField("clientLastContactTime", readSignedLong(readBuffer, 64));

    long currentSubscriptionsCount =
        readSimpleField("currentSubscriptionsCount", readUnsignedLong(readBuffer, 32));

    long currentMonitoredItemsCount =
        readSimpleField("currentMonitoredItemsCount", readUnsignedLong(readBuffer, 32));

    long currentPublishRequestsInQueue =
        readSimpleField("currentPublishRequestsInQueue", readUnsignedLong(readBuffer, 32));

    ExtensionObjectDefinition totalRequestCount =
        readSimpleField(
            "totalRequestCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    long unauthorizedRequestCount =
        readSimpleField("unauthorizedRequestCount", readUnsignedLong(readBuffer, 32));

    ExtensionObjectDefinition readCount =
        readSimpleField(
            "readCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition historyReadCount =
        readSimpleField(
            "historyReadCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition writeCount =
        readSimpleField(
            "writeCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition historyUpdateCount =
        readSimpleField(
            "historyUpdateCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition callCount =
        readSimpleField(
            "callCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition createMonitoredItemsCount =
        readSimpleField(
            "createMonitoredItemsCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition modifyMonitoredItemsCount =
        readSimpleField(
            "modifyMonitoredItemsCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition setMonitoringModeCount =
        readSimpleField(
            "setMonitoringModeCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition setTriggeringCount =
        readSimpleField(
            "setTriggeringCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition deleteMonitoredItemsCount =
        readSimpleField(
            "deleteMonitoredItemsCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition createSubscriptionCount =
        readSimpleField(
            "createSubscriptionCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition modifySubscriptionCount =
        readSimpleField(
            "modifySubscriptionCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition setPublishingModeCount =
        readSimpleField(
            "setPublishingModeCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition publishCount =
        readSimpleField(
            "publishCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition republishCount =
        readSimpleField(
            "republishCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition transferSubscriptionsCount =
        readSimpleField(
            "transferSubscriptionsCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition deleteSubscriptionsCount =
        readSimpleField(
            "deleteSubscriptionsCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition addNodesCount =
        readSimpleField(
            "addNodesCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition addReferencesCount =
        readSimpleField(
            "addReferencesCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition deleteNodesCount =
        readSimpleField(
            "deleteNodesCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition deleteReferencesCount =
        readSimpleField(
            "deleteReferencesCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition browseCount =
        readSimpleField(
            "browseCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition browseNextCount =
        readSimpleField(
            "browseNextCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition translateBrowsePathsToNodeIdsCount =
        readSimpleField(
            "translateBrowsePathsToNodeIdsCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition queryFirstCount =
        readSimpleField(
            "queryFirstCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition queryNextCount =
        readSimpleField(
            "queryNextCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition registerNodesCount =
        readSimpleField(
            "registerNodesCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    ExtensionObjectDefinition unregisterNodesCount =
        readSimpleField(
            "unregisterNodesCount",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("873")),
                readBuffer));

    readBuffer.closeContext("SessionDiagnosticsDataType");
    // Create the instance
    return new SessionDiagnosticsDataTypeBuilder(
        sessionId,
        sessionName,
        clientDescription,
        serverUri,
        endpointUrl,
        noOfLocaleIds,
        localeIds,
        actualSessionTimeout,
        maxResponseMessageSize,
        clientConnectionTime,
        clientLastContactTime,
        currentSubscriptionsCount,
        currentMonitoredItemsCount,
        currentPublishRequestsInQueue,
        totalRequestCount,
        unauthorizedRequestCount,
        readCount,
        historyReadCount,
        writeCount,
        historyUpdateCount,
        callCount,
        createMonitoredItemsCount,
        modifyMonitoredItemsCount,
        setMonitoringModeCount,
        setTriggeringCount,
        deleteMonitoredItemsCount,
        createSubscriptionCount,
        modifySubscriptionCount,
        setPublishingModeCount,
        publishCount,
        republishCount,
        transferSubscriptionsCount,
        deleteSubscriptionsCount,
        addNodesCount,
        addReferencesCount,
        deleteNodesCount,
        deleteReferencesCount,
        browseCount,
        browseNextCount,
        translateBrowsePathsToNodeIdsCount,
        queryFirstCount,
        queryNextCount,
        registerNodesCount,
        unregisterNodesCount);
  }

  public static class SessionDiagnosticsDataTypeBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final NodeId sessionId;
    private final PascalString sessionName;
    private final ExtensionObjectDefinition clientDescription;
    private final PascalString serverUri;
    private final PascalString endpointUrl;
    private final int noOfLocaleIds;
    private final List<PascalString> localeIds;
    private final double actualSessionTimeout;
    private final long maxResponseMessageSize;
    private final long clientConnectionTime;
    private final long clientLastContactTime;
    private final long currentSubscriptionsCount;
    private final long currentMonitoredItemsCount;
    private final long currentPublishRequestsInQueue;
    private final ExtensionObjectDefinition totalRequestCount;
    private final long unauthorizedRequestCount;
    private final ExtensionObjectDefinition readCount;
    private final ExtensionObjectDefinition historyReadCount;
    private final ExtensionObjectDefinition writeCount;
    private final ExtensionObjectDefinition historyUpdateCount;
    private final ExtensionObjectDefinition callCount;
    private final ExtensionObjectDefinition createMonitoredItemsCount;
    private final ExtensionObjectDefinition modifyMonitoredItemsCount;
    private final ExtensionObjectDefinition setMonitoringModeCount;
    private final ExtensionObjectDefinition setTriggeringCount;
    private final ExtensionObjectDefinition deleteMonitoredItemsCount;
    private final ExtensionObjectDefinition createSubscriptionCount;
    private final ExtensionObjectDefinition modifySubscriptionCount;
    private final ExtensionObjectDefinition setPublishingModeCount;
    private final ExtensionObjectDefinition publishCount;
    private final ExtensionObjectDefinition republishCount;
    private final ExtensionObjectDefinition transferSubscriptionsCount;
    private final ExtensionObjectDefinition deleteSubscriptionsCount;
    private final ExtensionObjectDefinition addNodesCount;
    private final ExtensionObjectDefinition addReferencesCount;
    private final ExtensionObjectDefinition deleteNodesCount;
    private final ExtensionObjectDefinition deleteReferencesCount;
    private final ExtensionObjectDefinition browseCount;
    private final ExtensionObjectDefinition browseNextCount;
    private final ExtensionObjectDefinition translateBrowsePathsToNodeIdsCount;
    private final ExtensionObjectDefinition queryFirstCount;
    private final ExtensionObjectDefinition queryNextCount;
    private final ExtensionObjectDefinition registerNodesCount;
    private final ExtensionObjectDefinition unregisterNodesCount;

    public SessionDiagnosticsDataTypeBuilder(
        NodeId sessionId,
        PascalString sessionName,
        ExtensionObjectDefinition clientDescription,
        PascalString serverUri,
        PascalString endpointUrl,
        int noOfLocaleIds,
        List<PascalString> localeIds,
        double actualSessionTimeout,
        long maxResponseMessageSize,
        long clientConnectionTime,
        long clientLastContactTime,
        long currentSubscriptionsCount,
        long currentMonitoredItemsCount,
        long currentPublishRequestsInQueue,
        ExtensionObjectDefinition totalRequestCount,
        long unauthorizedRequestCount,
        ExtensionObjectDefinition readCount,
        ExtensionObjectDefinition historyReadCount,
        ExtensionObjectDefinition writeCount,
        ExtensionObjectDefinition historyUpdateCount,
        ExtensionObjectDefinition callCount,
        ExtensionObjectDefinition createMonitoredItemsCount,
        ExtensionObjectDefinition modifyMonitoredItemsCount,
        ExtensionObjectDefinition setMonitoringModeCount,
        ExtensionObjectDefinition setTriggeringCount,
        ExtensionObjectDefinition deleteMonitoredItemsCount,
        ExtensionObjectDefinition createSubscriptionCount,
        ExtensionObjectDefinition modifySubscriptionCount,
        ExtensionObjectDefinition setPublishingModeCount,
        ExtensionObjectDefinition publishCount,
        ExtensionObjectDefinition republishCount,
        ExtensionObjectDefinition transferSubscriptionsCount,
        ExtensionObjectDefinition deleteSubscriptionsCount,
        ExtensionObjectDefinition addNodesCount,
        ExtensionObjectDefinition addReferencesCount,
        ExtensionObjectDefinition deleteNodesCount,
        ExtensionObjectDefinition deleteReferencesCount,
        ExtensionObjectDefinition browseCount,
        ExtensionObjectDefinition browseNextCount,
        ExtensionObjectDefinition translateBrowsePathsToNodeIdsCount,
        ExtensionObjectDefinition queryFirstCount,
        ExtensionObjectDefinition queryNextCount,
        ExtensionObjectDefinition registerNodesCount,
        ExtensionObjectDefinition unregisterNodesCount) {

      this.sessionId = sessionId;
      this.sessionName = sessionName;
      this.clientDescription = clientDescription;
      this.serverUri = serverUri;
      this.endpointUrl = endpointUrl;
      this.noOfLocaleIds = noOfLocaleIds;
      this.localeIds = localeIds;
      this.actualSessionTimeout = actualSessionTimeout;
      this.maxResponseMessageSize = maxResponseMessageSize;
      this.clientConnectionTime = clientConnectionTime;
      this.clientLastContactTime = clientLastContactTime;
      this.currentSubscriptionsCount = currentSubscriptionsCount;
      this.currentMonitoredItemsCount = currentMonitoredItemsCount;
      this.currentPublishRequestsInQueue = currentPublishRequestsInQueue;
      this.totalRequestCount = totalRequestCount;
      this.unauthorizedRequestCount = unauthorizedRequestCount;
      this.readCount = readCount;
      this.historyReadCount = historyReadCount;
      this.writeCount = writeCount;
      this.historyUpdateCount = historyUpdateCount;
      this.callCount = callCount;
      this.createMonitoredItemsCount = createMonitoredItemsCount;
      this.modifyMonitoredItemsCount = modifyMonitoredItemsCount;
      this.setMonitoringModeCount = setMonitoringModeCount;
      this.setTriggeringCount = setTriggeringCount;
      this.deleteMonitoredItemsCount = deleteMonitoredItemsCount;
      this.createSubscriptionCount = createSubscriptionCount;
      this.modifySubscriptionCount = modifySubscriptionCount;
      this.setPublishingModeCount = setPublishingModeCount;
      this.publishCount = publishCount;
      this.republishCount = republishCount;
      this.transferSubscriptionsCount = transferSubscriptionsCount;
      this.deleteSubscriptionsCount = deleteSubscriptionsCount;
      this.addNodesCount = addNodesCount;
      this.addReferencesCount = addReferencesCount;
      this.deleteNodesCount = deleteNodesCount;
      this.deleteReferencesCount = deleteReferencesCount;
      this.browseCount = browseCount;
      this.browseNextCount = browseNextCount;
      this.translateBrowsePathsToNodeIdsCount = translateBrowsePathsToNodeIdsCount;
      this.queryFirstCount = queryFirstCount;
      this.queryNextCount = queryNextCount;
      this.registerNodesCount = registerNodesCount;
      this.unregisterNodesCount = unregisterNodesCount;
    }

    public SessionDiagnosticsDataType build() {
      SessionDiagnosticsDataType sessionDiagnosticsDataType =
          new SessionDiagnosticsDataType(
              sessionId,
              sessionName,
              clientDescription,
              serverUri,
              endpointUrl,
              noOfLocaleIds,
              localeIds,
              actualSessionTimeout,
              maxResponseMessageSize,
              clientConnectionTime,
              clientLastContactTime,
              currentSubscriptionsCount,
              currentMonitoredItemsCount,
              currentPublishRequestsInQueue,
              totalRequestCount,
              unauthorizedRequestCount,
              readCount,
              historyReadCount,
              writeCount,
              historyUpdateCount,
              callCount,
              createMonitoredItemsCount,
              modifyMonitoredItemsCount,
              setMonitoringModeCount,
              setTriggeringCount,
              deleteMonitoredItemsCount,
              createSubscriptionCount,
              modifySubscriptionCount,
              setPublishingModeCount,
              publishCount,
              republishCount,
              transferSubscriptionsCount,
              deleteSubscriptionsCount,
              addNodesCount,
              addReferencesCount,
              deleteNodesCount,
              deleteReferencesCount,
              browseCount,
              browseNextCount,
              translateBrowsePathsToNodeIdsCount,
              queryFirstCount,
              queryNextCount,
              registerNodesCount,
              unregisterNodesCount);
      return sessionDiagnosticsDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SessionDiagnosticsDataType)) {
      return false;
    }
    SessionDiagnosticsDataType that = (SessionDiagnosticsDataType) o;
    return (getSessionId() == that.getSessionId())
        && (getSessionName() == that.getSessionName())
        && (getClientDescription() == that.getClientDescription())
        && (getServerUri() == that.getServerUri())
        && (getEndpointUrl() == that.getEndpointUrl())
        && (getNoOfLocaleIds() == that.getNoOfLocaleIds())
        && (getLocaleIds() == that.getLocaleIds())
        && (getActualSessionTimeout() == that.getActualSessionTimeout())
        && (getMaxResponseMessageSize() == that.getMaxResponseMessageSize())
        && (getClientConnectionTime() == that.getClientConnectionTime())
        && (getClientLastContactTime() == that.getClientLastContactTime())
        && (getCurrentSubscriptionsCount() == that.getCurrentSubscriptionsCount())
        && (getCurrentMonitoredItemsCount() == that.getCurrentMonitoredItemsCount())
        && (getCurrentPublishRequestsInQueue() == that.getCurrentPublishRequestsInQueue())
        && (getTotalRequestCount() == that.getTotalRequestCount())
        && (getUnauthorizedRequestCount() == that.getUnauthorizedRequestCount())
        && (getReadCount() == that.getReadCount())
        && (getHistoryReadCount() == that.getHistoryReadCount())
        && (getWriteCount() == that.getWriteCount())
        && (getHistoryUpdateCount() == that.getHistoryUpdateCount())
        && (getCallCount() == that.getCallCount())
        && (getCreateMonitoredItemsCount() == that.getCreateMonitoredItemsCount())
        && (getModifyMonitoredItemsCount() == that.getModifyMonitoredItemsCount())
        && (getSetMonitoringModeCount() == that.getSetMonitoringModeCount())
        && (getSetTriggeringCount() == that.getSetTriggeringCount())
        && (getDeleteMonitoredItemsCount() == that.getDeleteMonitoredItemsCount())
        && (getCreateSubscriptionCount() == that.getCreateSubscriptionCount())
        && (getModifySubscriptionCount() == that.getModifySubscriptionCount())
        && (getSetPublishingModeCount() == that.getSetPublishingModeCount())
        && (getPublishCount() == that.getPublishCount())
        && (getRepublishCount() == that.getRepublishCount())
        && (getTransferSubscriptionsCount() == that.getTransferSubscriptionsCount())
        && (getDeleteSubscriptionsCount() == that.getDeleteSubscriptionsCount())
        && (getAddNodesCount() == that.getAddNodesCount())
        && (getAddReferencesCount() == that.getAddReferencesCount())
        && (getDeleteNodesCount() == that.getDeleteNodesCount())
        && (getDeleteReferencesCount() == that.getDeleteReferencesCount())
        && (getBrowseCount() == that.getBrowseCount())
        && (getBrowseNextCount() == that.getBrowseNextCount())
        && (getTranslateBrowsePathsToNodeIdsCount() == that.getTranslateBrowsePathsToNodeIdsCount())
        && (getQueryFirstCount() == that.getQueryFirstCount())
        && (getQueryNextCount() == that.getQueryNextCount())
        && (getRegisterNodesCount() == that.getRegisterNodesCount())
        && (getUnregisterNodesCount() == that.getUnregisterNodesCount())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getSessionId(),
        getSessionName(),
        getClientDescription(),
        getServerUri(),
        getEndpointUrl(),
        getNoOfLocaleIds(),
        getLocaleIds(),
        getActualSessionTimeout(),
        getMaxResponseMessageSize(),
        getClientConnectionTime(),
        getClientLastContactTime(),
        getCurrentSubscriptionsCount(),
        getCurrentMonitoredItemsCount(),
        getCurrentPublishRequestsInQueue(),
        getTotalRequestCount(),
        getUnauthorizedRequestCount(),
        getReadCount(),
        getHistoryReadCount(),
        getWriteCount(),
        getHistoryUpdateCount(),
        getCallCount(),
        getCreateMonitoredItemsCount(),
        getModifyMonitoredItemsCount(),
        getSetMonitoringModeCount(),
        getSetTriggeringCount(),
        getDeleteMonitoredItemsCount(),
        getCreateSubscriptionCount(),
        getModifySubscriptionCount(),
        getSetPublishingModeCount(),
        getPublishCount(),
        getRepublishCount(),
        getTransferSubscriptionsCount(),
        getDeleteSubscriptionsCount(),
        getAddNodesCount(),
        getAddReferencesCount(),
        getDeleteNodesCount(),
        getDeleteReferencesCount(),
        getBrowseCount(),
        getBrowseNextCount(),
        getTranslateBrowsePathsToNodeIdsCount(),
        getQueryFirstCount(),
        getQueryNextCount(),
        getRegisterNodesCount(),
        getUnregisterNodesCount());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
