/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class TransferResult extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "838";
  }

  // Properties.
  protected final StatusCode statusCode;
  protected final int noOfAvailableSequenceNumbers;
  protected final List<Long> availableSequenceNumbers;

  public TransferResult(
      StatusCode statusCode,
      int noOfAvailableSequenceNumbers,
      List<Long> availableSequenceNumbers) {
    super();
    this.statusCode = statusCode;
    this.noOfAvailableSequenceNumbers = noOfAvailableSequenceNumbers;
    this.availableSequenceNumbers = availableSequenceNumbers;
  }

  public StatusCode getStatusCode() {
    return statusCode;
  }

  public int getNoOfAvailableSequenceNumbers() {
    return noOfAvailableSequenceNumbers;
  }

  public List<Long> getAvailableSequenceNumbers() {
    return availableSequenceNumbers;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("TransferResult");

    // Simple Field (statusCode)
    writeSimpleField("statusCode", statusCode, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfAvailableSequenceNumbers)
    writeSimpleField(
        "noOfAvailableSequenceNumbers",
        noOfAvailableSequenceNumbers,
        writeSignedInt(writeBuffer, 32));

    // Array Field (availableSequenceNumbers)
    writeSimpleTypeArrayField(
        "availableSequenceNumbers", availableSequenceNumbers, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("TransferResult");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    TransferResult _value = this;

    // Simple field (statusCode)
    lengthInBits += statusCode.getLengthInBits();

    // Simple field (noOfAvailableSequenceNumbers)
    lengthInBits += 32;

    // Array field
    if (availableSequenceNumbers != null) {
      lengthInBits += 32 * availableSequenceNumbers.size();
    }

    return lengthInBits;
  }

  public static TransferResultBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier)
      throws ParseException {
    readBuffer.pullContext("TransferResult");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    StatusCode statusCode =
        readSimpleField(
            "statusCode",
            new DataReaderComplexDefault<>(() -> StatusCode.staticParse(readBuffer), readBuffer));

    int noOfAvailableSequenceNumbers =
        readSimpleField("noOfAvailableSequenceNumbers", readSignedInt(readBuffer, 32));

    List<Long> availableSequenceNumbers =
        readCountArrayField(
            "availableSequenceNumbers",
            readUnsignedLong(readBuffer, 32),
            noOfAvailableSequenceNumbers);

    readBuffer.closeContext("TransferResult");
    // Create the instance
    return new TransferResultBuilder(
        statusCode, noOfAvailableSequenceNumbers, availableSequenceNumbers);
  }

  public static class TransferResultBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final StatusCode statusCode;
    private final int noOfAvailableSequenceNumbers;
    private final List<Long> availableSequenceNumbers;

    public TransferResultBuilder(
        StatusCode statusCode,
        int noOfAvailableSequenceNumbers,
        List<Long> availableSequenceNumbers) {

      this.statusCode = statusCode;
      this.noOfAvailableSequenceNumbers = noOfAvailableSequenceNumbers;
      this.availableSequenceNumbers = availableSequenceNumbers;
    }

    public TransferResult build() {
      TransferResult transferResult =
          new TransferResult(statusCode, noOfAvailableSequenceNumbers, availableSequenceNumbers);
      return transferResult;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TransferResult)) {
      return false;
    }
    TransferResult that = (TransferResult) o;
    return (getStatusCode() == that.getStatusCode())
        && (getNoOfAvailableSequenceNumbers() == that.getNoOfAvailableSequenceNumbers())
        && (getAvailableSequenceNumbers() == that.getAvailableSequenceNumbers())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getStatusCode(),
        getNoOfAvailableSequenceNumbers(),
        getAvailableSequenceNumbers());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
