/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.FileSystems;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.opcua.context.CertificateGenerator;
import org.apache.plc4x.java.opcua.context.CertificateKeyPair;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.configuration.annotations.ConfigurationParameter;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.BooleanDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.StringDefaultValue;
import org.apache.plc4x.java.transport.tcp.TcpTransportConfiguration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcuaConfiguration
implements Configuration,
TcpTransportConfiguration {
    private static final Logger LOGGER;
    private String code;
    private String host;
    private String port;
    private String endpoint;
    private String transportEndpoint;
    private String params;
    private Boolean isEncrypted = false;
    private PascalByteString thumbprint;
    private byte[] senderCertificate;
    @ConfigurationParameter(value="discovery")
    @BooleanDefaultValue(value=true)
    private boolean discovery;
    @ConfigurationParameter(value="username")
    private String username;
    @ConfigurationParameter(value="password")
    private String password;
    @ConfigurationParameter(value="securityPolicy")
    @StringDefaultValue(value="None")
    private String securityPolicy;
    @ConfigurationParameter(value="keyStoreFile")
    private String keyStoreFile;
    @ConfigurationParameter(value="certDirectory")
    private String certDirectory;
    @ConfigurationParameter(value="keyStorePassword")
    private String keyStorePassword;
    private CertificateKeyPair ckp;

    public boolean isDiscovery() {
        return this.discovery;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCertDirectory() {
        return this.certDirectory;
    }

    public String getSecurityPolicy() {
        return this.securityPolicy;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public PascalByteString getThumbprint() {
        return this.thumbprint;
    }

    public CertificateKeyPair getCertificateKeyPair() {
        return this.ckp;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void setDiscovery(boolean discovery) {
        this.discovery = discovery;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCertDirectory(String certDirectory) {
        this.certDirectory = certDirectory;
    }

    public void setSecurityPolicy(String securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setThumbprint(PascalByteString thumbprint) {
        this.thumbprint = thumbprint;
    }

    public String getTransportCode() {
        return this.code;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getTransportEndpoint() {
        return this.transportEndpoint;
    }

    public byte[] getSenderCertificate() {
        return this.senderCertificate;
    }

    public void setTransportCode(String code) {
        this.code = code;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setTransportEndpoint(String transportEndpoint) {
        this.transportEndpoint = transportEndpoint;
    }

    public void openKeyStore() throws Exception {
        this.isEncrypted = true;
        File securityTempDir = new File(this.certDirectory, "security");
        if (!securityTempDir.exists() && !securityTempDir.mkdirs()) {
            throw new PlcConnectionException("Unable to create directory please confirm folder permissions on " + this.certDirectory);
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        File serverKeyStore = securityTempDir.toPath().resolve(this.keyStoreFile).toFile();
        File pkiDir = FileSystems.getDefault().getPath(this.certDirectory, new String[0]).resolve("pki").toFile();
        if (!serverKeyStore.exists()) {
            this.ckp = CertificateGenerator.generateCertificate();
            LOGGER.info("Creating new KeyStore at {}", (Object)serverKeyStore);
            keyStore.load(null, this.keyStorePassword.toCharArray());
            keyStore.setKeyEntry("plc4x-certificate-alias", this.ckp.getKeyPair().getPrivate(), this.keyStorePassword.toCharArray(), new X509Certificate[]{this.ckp.getCertificate()});
            keyStore.store(new FileOutputStream(serverKeyStore), this.keyStorePassword.toCharArray());
        } else {
            LOGGER.info("Loading KeyStore at {}", (Object)serverKeyStore);
            keyStore.load(new FileInputStream(serverKeyStore), this.keyStorePassword.toCharArray());
            String alias = keyStore.aliases().nextElement();
            KeyPair kp = new KeyPair(keyStore.getCertificate(alias).getPublicKey(), (PrivateKey)keyStore.getKey(alias, this.keyStorePassword.toCharArray()));
            this.ckp = new CertificateKeyPair(kp, (X509Certificate)keyStore.getCertificate(alias));
        }
    }

    public String toString() {
        return "Configuration{}";
    }

    public void setSenderCertificate(byte[] certificate) {
        this.senderCertificate = certificate;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        LOGGER = LoggerFactory.getLogger(OpcuaConfiguration.class);
    }
}

