/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.protocol;

import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.opcua.config.OpcuaConfiguration;
import org.apache.plc4x.java.opcua.context.SecureChannel;
import org.apache.plc4x.java.opcua.field.OpcuaField;
import org.apache.plc4x.java.opcua.protocol.OpcuaSubscriptionHandle;
import org.apache.plc4x.java.opcua.readwrite.ByteStringArray;
import org.apache.plc4x.java.opcua.readwrite.CreateSubscriptionRequest;
import org.apache.plc4x.java.opcua.readwrite.CreateSubscriptionResponse;
import org.apache.plc4x.java.opcua.readwrite.DataValue;
import org.apache.plc4x.java.opcua.readwrite.ExpandedNodeId;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectEncodingMask;
import org.apache.plc4x.java.opcua.readwrite.GuidValue;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.NodeIdFourByte;
import org.apache.plc4x.java.opcua.readwrite.NodeIdGuid;
import org.apache.plc4x.java.opcua.readwrite.NodeIdNumeric;
import org.apache.plc4x.java.opcua.readwrite.NodeIdString;
import org.apache.plc4x.java.opcua.readwrite.NodeIdTwoByte;
import org.apache.plc4x.java.opcua.readwrite.NullExtension;
import org.apache.plc4x.java.opcua.readwrite.OpcuaAPU;
import org.apache.plc4x.java.opcua.readwrite.OpcuaIdentifierType;
import org.apache.plc4x.java.opcua.readwrite.OpcuaStatusCode;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.QualifiedName;
import org.apache.plc4x.java.opcua.readwrite.ReadRequest;
import org.apache.plc4x.java.opcua.readwrite.ReadResponse;
import org.apache.plc4x.java.opcua.readwrite.ReadValueId;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.opcua.readwrite.ServiceFault;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.opcua.readwrite.TimestampsToReturn;
import org.apache.plc4x.java.opcua.readwrite.Variant;
import org.apache.plc4x.java.opcua.readwrite.VariantBoolean;
import org.apache.plc4x.java.opcua.readwrite.VariantByte;
import org.apache.plc4x.java.opcua.readwrite.VariantByteString;
import org.apache.plc4x.java.opcua.readwrite.VariantDateTime;
import org.apache.plc4x.java.opcua.readwrite.VariantDouble;
import org.apache.plc4x.java.opcua.readwrite.VariantExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.VariantFloat;
import org.apache.plc4x.java.opcua.readwrite.VariantGuid;
import org.apache.plc4x.java.opcua.readwrite.VariantInt16;
import org.apache.plc4x.java.opcua.readwrite.VariantInt32;
import org.apache.plc4x.java.opcua.readwrite.VariantInt64;
import org.apache.plc4x.java.opcua.readwrite.VariantLocalizedText;
import org.apache.plc4x.java.opcua.readwrite.VariantNodeId;
import org.apache.plc4x.java.opcua.readwrite.VariantQualifiedName;
import org.apache.plc4x.java.opcua.readwrite.VariantSByte;
import org.apache.plc4x.java.opcua.readwrite.VariantStatusCode;
import org.apache.plc4x.java.opcua.readwrite.VariantString;
import org.apache.plc4x.java.opcua.readwrite.VariantUInt16;
import org.apache.plc4x.java.opcua.readwrite.VariantUInt32;
import org.apache.plc4x.java.opcua.readwrite.VariantUInt64;
import org.apache.plc4x.java.opcua.readwrite.VariantXmlElement;
import org.apache.plc4x.java.opcua.readwrite.WriteRequest;
import org.apache.plc4x.java.opcua.readwrite.WriteResponse;
import org.apache.plc4x.java.opcua.readwrite.WriteValue;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionField;
import org.apache.plc4x.java.spi.values.IEC61131ValueHandler;
import org.apache.plc4x.java.spi.values.PlcList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcuaProtocolLogic
extends Plc4xProtocolBase<OpcuaAPU>
implements HasConfiguration<OpcuaConfiguration>,
PlcSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcuaProtocolLogic.class);
    protected static final PascalString NULL_STRING = new PascalString("");
    private static ExpandedNodeId NULL_EXPANDED_NODEID = new ExpandedNodeId(false, false, new NodeIdTwoByte(0), null, null);
    protected static final ExtensionObject NULL_EXTENSION_OBJECT = new ExtensionObject(NULL_EXPANDED_NODEID, new ExtensionObjectEncodingMask(false, false, false), new NullExtension(), true);
    private static final long EPOCH_OFFSET = 116444736000000000L;
    private OpcuaConfiguration configuration;
    private Map<Long, OpcuaSubscriptionHandle> subscriptions = new HashMap<Long, OpcuaSubscriptionHandle>();
    private SecureChannel channel;
    private AtomicBoolean securedConnection = new AtomicBoolean(false);

    public void setConfiguration(OpcuaConfiguration configuration) {
        this.configuration = configuration;
    }

    public void close(ConversationContext<OpcuaAPU> context) {
    }

    public void onDisconnect(ConversationContext<OpcuaAPU> context) {
        for (Map.Entry<Long, OpcuaSubscriptionHandle> subscriber : this.subscriptions.entrySet()) {
            subscriber.getValue().stopSubscriber();
        }
        this.channel.onDisconnect(context);
    }

    public void setDriverContext(DriverContext driverContext) {
        super.setDriverContext(driverContext);
        this.channel = new SecureChannel(driverContext, this.configuration);
    }

    public void onConnect(ConversationContext<OpcuaAPU> context) {
        LOGGER.debug("Opcua Driver running in ACTIVE mode.");
        if (this.channel == null) {
            this.channel = new SecureChannel(this.driverContext, this.configuration);
        }
        this.channel.onConnect(context);
    }

    public void onDiscover(ConversationContext<OpcuaAPU> context) {
        LOGGER.debug("Opcua Driver running in ACTIVE mode, discovering endpoints");
        if (this.channel == null) {
            this.channel = new SecureChannel(this.driverContext, this.configuration);
        }
        this.channel.onDiscover(context);
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        LOGGER.trace("Reading Value");
        CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
        DefaultPlcReadRequest request = (DefaultPlcReadRequest)readRequest;
        RequestHeader requestHeader = new RequestHeader(this.channel.getAuthenticationToken(), SecureChannel.getCurrentDateTime(), this.channel.getRequestHandle(), 0L, NULL_STRING, 10000L, NULL_EXTENSION_OBJECT);
        ArrayList<ExtensionObjectDefinition> readValueArray = new ArrayList<ExtensionObjectDefinition>(request.getFieldNames().size());
        Iterator iterator = request.getFieldNames().iterator();
        for (int i = 0; i < request.getFieldNames().size(); ++i) {
            String fieldName = (String)iterator.next();
            OpcuaField field = (OpcuaField)request.getField(fieldName);
            NodeId nodeId = this.generateNodeId(field);
            readValueArray.add(new ReadValueId(nodeId, 13L, NULL_STRING, new QualifiedName(0, NULL_STRING)));
        }
        ReadRequest opcuaReadRequest = new ReadRequest(requestHeader, 0.0, TimestampsToReturn.timestampsToReturnNeither, readValueArray.size(), readValueArray);
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(opcuaReadRequest.getIdentifier())), null, null);
        ExtensionObject extObject = new ExtensionObject(expandedNodeId, null, opcuaReadRequest, false);
        try {
            WriteBufferByteBased buffer = new WriteBufferByteBased(extObject.getLengthInBytes(), ByteOrder.LITTLE_ENDIAN);
            extObject.serialize((WriteBuffer)buffer);
            Consumer<byte[]> consumer = opcuaResponse -> {
                Object response = null;
                try {
                    ExtensionObjectDefinition reply = ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaResponse, ByteOrder.LITTLE_ENDIAN), false).getBody();
                    if (!(reply instanceof ReadResponse)) {
                        if (reply instanceof ServiceFault) {
                            ExtensionObjectDefinition header = ((ServiceFault)reply).getResponseHeader();
                            LOGGER.error("Read request ended up with ServiceFault: {}", (Object)header);
                        } else {
                            LOGGER.error("Remote party returned an error '{}'", (Object)reply);
                        }
                        LinkedHashMap<String, ResponseItem> status = new LinkedHashMap<String, ResponseItem>();
                        for (String key : request.getFieldNames()) {
                            status.put(key, new ResponseItem(PlcResponseCode.INTERNAL_ERROR, null));
                        }
                        future.complete((PlcReadResponse)new DefaultPlcReadResponse((PlcReadRequest)request, status));
                        return;
                    }
                    future.complete((PlcReadResponse)new DefaultPlcReadResponse((PlcReadRequest)request, this.readResponse(request.getFieldNames(), ((ReadResponse)reply).getResults())));
                }
                catch (ParseException e) {
                    future.completeExceptionally((Throwable)new PlcRuntimeException((Throwable)e));
                }
            };
            Consumer<TimeoutException> timeout = future::completeExceptionally;
            BiConsumer<OpcuaAPU, Throwable> error = (message, t) -> future.completeExceptionally((Throwable)t);
            this.channel.submit((ConversationContext<OpcuaAPU>)this.context, timeout, error, consumer, buffer);
        }
        catch (SerializationException e) {
            LOGGER.error("Unable to serialise the ReadRequest");
        }
        return future;
    }

    private NodeId generateNodeId(OpcuaField field) {
        NodeId nodeId = null;
        if (field.getIdentifierType() == OpcuaIdentifierType.BINARY_IDENTIFIER) {
            nodeId = new NodeId(new NodeIdTwoByte(Short.parseShort(field.getIdentifier())));
        } else if (field.getIdentifierType() == OpcuaIdentifierType.NUMBER_IDENTIFIER) {
            nodeId = new NodeId(new NodeIdNumeric((short)field.getNamespace(), Long.parseLong(field.getIdentifier())));
        } else if (field.getIdentifierType() == OpcuaIdentifierType.GUID_IDENTIFIER) {
            UUID guid = UUID.fromString(field.getIdentifier());
            byte[] guidBytes = new byte[16];
            System.arraycopy(guid.getMostSignificantBits(), 0, guidBytes, 0, 8);
            System.arraycopy(guid.getLeastSignificantBits(), 0, guidBytes, 8, 8);
            nodeId = new NodeId(new NodeIdGuid((short)field.getNamespace(), guidBytes));
        } else if (field.getIdentifierType() == OpcuaIdentifierType.STRING_IDENTIFIER) {
            nodeId = new NodeId(new NodeIdString((short)field.getNamespace(), new PascalString(field.getIdentifier())));
        }
        return nodeId;
    }

    public Map<String, ResponseItem<PlcValue>> readResponse(LinkedHashSet<String> fieldNames, List<DataValue> results) {
        PlcResponseCode responseCode = PlcResponseCode.OK;
        HashMap<String, ResponseItem<PlcValue>> response = new HashMap<String, ResponseItem<PlcValue>>();
        int count = 0;
        for (String field : fieldNames) {
            PlcValue value = null;
            if (results.get(count).getValueSpecified()) {
                int i;
                Variant variant = results.get(count).getValue();
                LOGGER.trace("Response of type {}", (Object)variant.getClass().toString());
                if (variant instanceof VariantBoolean) {
                    byte[] array = ((VariantBoolean)variant).getValue();
                    int length = array.length;
                    Object[] tmpValue = new Boolean[length];
                    for (i = 0; i < length; ++i) {
                        tmpValue[i] = array[i] != 0;
                    }
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantSByte) {
                    byte[] array = ((VariantSByte)variant).getValue();
                    value = IEC61131ValueHandler.of((Object)array);
                } else if (variant instanceof VariantByte) {
                    List<Short> array = ((VariantByte)variant).getValue();
                    Object[] tmpValue = array.toArray(new Short[0]);
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantInt16) {
                    List<Short> array = ((VariantInt16)variant).getValue();
                    Object[] tmpValue = array.toArray(new Short[0]);
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantUInt16) {
                    List<Integer> array = ((VariantUInt16)variant).getValue();
                    Object[] tmpValue = array.toArray(new Integer[0]);
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantInt32) {
                    List<Integer> array = ((VariantInt32)variant).getValue();
                    Object[] tmpValue = array.toArray(new Integer[0]);
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantUInt32) {
                    List<Long> array = ((VariantUInt32)variant).getValue();
                    Object[] tmpValue = array.toArray(new Long[0]);
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantInt64) {
                    List<Long> array = ((VariantInt64)variant).getValue();
                    Object[] tmpValue = array.toArray(new Long[0]);
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantUInt64) {
                    value = IEC61131ValueHandler.of(((VariantUInt64)variant).getValue());
                } else if (variant instanceof VariantFloat) {
                    List<Float> array = ((VariantFloat)variant).getValue();
                    Object[] tmpValue = array.toArray(new Float[0]);
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantDouble) {
                    List<Double> array = ((VariantDouble)variant).getValue();
                    Object[] tmpValue = array.toArray(new Double[0]);
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantString) {
                    int length = ((VariantString)variant).getValue().size();
                    List<PascalString> stringArray = ((VariantString)variant).getValue();
                    Object[] tmpValue = new String[length];
                    for (i = 0; i < length; ++i) {
                        tmpValue[i] = stringArray.get(i).getStringValue();
                    }
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantDateTime) {
                    List<Long> array = ((VariantDateTime)variant).getValue();
                    int length = array.size();
                    Object[] tmpValue = new LocalDateTime[length];
                    for (i = 0; i < length; ++i) {
                        tmpValue[i] = LocalDateTime.ofInstant(Instant.ofEpochMilli(OpcuaProtocolLogic.getDateTime(array.get(i))), ZoneOffset.UTC);
                    }
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantGuid) {
                    List<GuidValue> array = ((VariantGuid)variant).getValue();
                    int length = array.size();
                    Object[] tmpValue = new String[length];
                    for (i = 0; i < length; ++i) {
                        byte[] data4Bytes = array.get(i).getData4();
                        int data4 = 0;
                        for (byte data4Byte : data4Bytes) {
                            data4 = (data4 << 8) + (data4Byte & 0xFF);
                        }
                        byte[] data5Bytes = array.get(i).getData5();
                        long data5 = 0L;
                        for (byte data5Byte : data5Bytes) {
                            data5 = (data5 << 8) + (long)(data5Byte & 0xFF);
                        }
                        tmpValue[i] = Long.toHexString(array.get(i).getData1()) + "-" + Integer.toHexString(array.get(i).getData2()) + "-" + Integer.toHexString(array.get(i).getData3()) + "-" + Integer.toHexString(data4) + "-" + Long.toHexString(data5);
                    }
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantXmlElement) {
                    int length = ((VariantXmlElement)variant).getValue().size();
                    List<PascalString> strings = ((VariantXmlElement)variant).getValue();
                    Object[] tmpValue = new String[length];
                    for (i = 0; i < length; ++i) {
                        tmpValue[i] = strings.get(i).getStringValue();
                    }
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantLocalizedText) {
                    int length = ((VariantLocalizedText)variant).getValue().size();
                    List<LocalizedText> strings = ((VariantLocalizedText)variant).getValue();
                    Object[] tmpValue = new String[length];
                    for (i = 0; i < length; ++i) {
                        tmpValue[i] = "";
                        int n = i;
                        tmpValue[n] = (String)tmpValue[n] + (strings.get(i).getLocaleSpecified() ? strings.get(i).getLocale().getStringValue() + "|" : "");
                        int n2 = i;
                        tmpValue[n2] = (String)tmpValue[n2] + (strings.get(i).getTextSpecified() ? strings.get(i).getText().getStringValue() : "");
                    }
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantQualifiedName) {
                    int length = ((VariantQualifiedName)variant).getValue().size();
                    List<QualifiedName> strings = ((VariantQualifiedName)variant).getValue();
                    Object[] tmpValue = new String[length];
                    for (i = 0; i < length; ++i) {
                        tmpValue[i] = "ns=" + strings.get(i).getNamespaceIndex() + ";s=" + strings.get(i).getName().getStringValue();
                    }
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantExtensionObject) {
                    int length = ((VariantExtensionObject)variant).getValue().size();
                    List<ExtensionObject> strings = ((VariantExtensionObject)variant).getValue();
                    Object[] tmpValue = new String[length];
                    for (i = 0; i < length; ++i) {
                        tmpValue[i] = strings.get(i).toString();
                    }
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantNodeId) {
                    int length = ((VariantNodeId)variant).getValue().size();
                    List<NodeId> strings = ((VariantNodeId)variant).getValue();
                    Object[] tmpValue = new String[length];
                    for (i = 0; i < length; ++i) {
                        tmpValue[i] = strings.get(i).toString();
                    }
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantStatusCode) {
                    int length = ((VariantStatusCode)variant).getValue().size();
                    List<StatusCode> strings = ((VariantStatusCode)variant).getValue();
                    Object[] tmpValue = new String[length];
                    for (i = 0; i < length; ++i) {
                        tmpValue[i] = strings.get(i).toString();
                    }
                    value = IEC61131ValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantByteString) {
                    PlcList plcList = new PlcList();
                    List<ByteStringArray> array = ((VariantByteString)variant).getValue();
                    for (int k = 0; k < array.size(); ++k) {
                        int length = array.get(k).getValue().size();
                        Object[] tmpValue = new Short[length];
                        for (int i2 = 0; i2 < length; ++i2) {
                            tmpValue[i2] = array.get(k).getValue().get(i2);
                        }
                        plcList.add(IEC61131ValueHandler.of((Object[])tmpValue));
                    }
                    value = plcList;
                } else {
                    responseCode = PlcResponseCode.UNSUPPORTED;
                    LOGGER.error("Data type - " + variant.getClass() + " is not supported ");
                }
            } else {
                responseCode = results.get(count).getStatusCode().getStatusCode() == OpcuaStatusCode.BadNodeIdUnknown.getValue() ? PlcResponseCode.NOT_FOUND : PlcResponseCode.UNSUPPORTED;
                LOGGER.error("Error while reading value from OPC UA server error code:- " + results.get(count).getStatusCode().toString());
            }
            ++count;
            response.put(field, (ResponseItem<PlcValue>)new ResponseItem(responseCode, (Object)value));
        }
        return response;
    }

    private Variant fromPlcValue(String fieldName, OpcuaField field, PlcWriteRequest request) {
        PlcList valueObject;
        if (request.getPlcValue(fieldName).getObject() instanceof ArrayList) {
            valueObject = (PlcList)request.getPlcValue(fieldName);
        } else {
            ArrayList<PlcValue> list = new ArrayList<PlcValue>();
            list.add(request.getPlcValue(fieldName));
            valueObject = new PlcList(list);
        }
        List plcValueList = valueObject.getList();
        String dataType = field.getPlcDataType();
        if (dataType.equals("NULL")) {
            if (((PlcValue)plcValueList.get(0)).getObject() instanceof Boolean) {
                dataType = "BOOL";
            } else if (((PlcValue)plcValueList.get(0)).getObject() instanceof Byte) {
                dataType = "SINT";
            } else if (((PlcValue)plcValueList.get(0)).getObject() instanceof Short) {
                dataType = "INT";
            } else if (((PlcValue)plcValueList.get(0)).getObject() instanceof Integer) {
                dataType = "DINT";
            } else if (((PlcValue)plcValueList.get(0)).getObject() instanceof Long) {
                dataType = "LINT";
            } else if (((PlcValue)plcValueList.get(0)).getObject() instanceof Float) {
                dataType = "REAL";
            } else if (((PlcValue)plcValueList.get(0)).getObject() instanceof Double) {
                dataType = "LREAL";
            } else if (((PlcValue)plcValueList.get(0)).getObject() instanceof String) {
                dataType = "STRING";
            }
        }
        int length = valueObject.getLength();
        switch (dataType) {
            case "BOOL": 
            case "BIT": {
                byte[] tmpBOOL = new byte[length];
                for (int i = 0; i < length; ++i) {
                    tmpBOOL[i] = valueObject.getIndex(i).getByte();
                }
                return new VariantBoolean(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpBOOL);
            }
            case "BYTE": 
            case "BIT8": 
            case "BITARR8": {
                ArrayList<Short> tmpBYTE = new ArrayList<Short>(length);
                for (int i = 0; i < length; ++i) {
                    tmpBYTE.add(valueObject.getIndex(i).getShort());
                }
                return new VariantByte(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpBYTE);
            }
            case "WORD": 
            case "BIT16": 
            case "BITARR16": {
                ArrayList<Integer> tmpWORD = new ArrayList<Integer>(length);
                for (int i = 0; i < length; ++i) {
                    tmpWORD.add(valueObject.getIndex(i).getInteger());
                }
                return new VariantUInt16(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpWORD);
            }
            case "DWORD": 
            case "BIT32": 
            case "BITARR32": {
                ArrayList<Long> tmpDWORD = new ArrayList<Long>(length);
                for (int i = 0; i < length; ++i) {
                    tmpDWORD.add(valueObject.getIndex(i).getLong());
                }
                return new VariantUInt32(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpDWORD);
            }
            case "LWORD": 
            case "BIT64": 
            case "BITARR64": {
                ArrayList<BigInteger> tmpLWORD = new ArrayList<BigInteger>(length);
                for (int i = 0; i < length; ++i) {
                    tmpLWORD.add(valueObject.getIndex(i).getBigInteger());
                }
                return new VariantUInt64(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpLWORD);
            }
            case "USINT": 
            case "UINT8": {
                ArrayList<Short> tmpUSINT = new ArrayList<Short>(length);
                for (int i = 0; i < length; ++i) {
                    tmpUSINT.add(valueObject.getIndex(i).getShort());
                }
                return new VariantByte(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpUSINT);
            }
            case "SINT": 
            case "INT8": {
                byte[] tmpSINT = new byte[length];
                for (int i = 0; i < length; ++i) {
                    tmpSINT[i] = valueObject.getIndex(i).getByte();
                }
                return new VariantSByte(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpSINT);
            }
            case "UINT": 
            case "UINT16": {
                ArrayList<Integer> tmpUINT = new ArrayList<Integer>(length);
                for (int i = 0; i < length; ++i) {
                    tmpUINT.add(valueObject.getIndex(i).getInt());
                }
                return new VariantUInt16(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpUINT);
            }
            case "INT": 
            case "INT16": {
                ArrayList<Short> tmpINT16 = new ArrayList<Short>(length);
                for (int i = 0; i < length; ++i) {
                    tmpINT16.add(valueObject.getIndex(i).getShort());
                }
                return new VariantInt16(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpINT16);
            }
            case "UDINT": 
            case "UINT32": {
                ArrayList<Long> tmpUDINT = new ArrayList<Long>(length);
                for (int i = 0; i < length; ++i) {
                    tmpUDINT.add(valueObject.getIndex(i).getLong());
                }
                return new VariantUInt32(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpUDINT);
            }
            case "DINT": 
            case "INT32": {
                ArrayList<Integer> tmpDINT = new ArrayList<Integer>(length);
                for (int i = 0; i < length; ++i) {
                    tmpDINT.add(valueObject.getIndex(i).getInt());
                }
                return new VariantInt32(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpDINT);
            }
            case "ULINT": 
            case "UINT64": {
                ArrayList<BigInteger> tmpULINT = new ArrayList<BigInteger>(length);
                for (int i = 0; i < length; ++i) {
                    tmpULINT.add(valueObject.getIndex(i).getBigInteger());
                }
                return new VariantUInt64(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpULINT);
            }
            case "LINT": 
            case "INT64": {
                ArrayList<Long> tmpLINT = new ArrayList<Long>(length);
                for (int i = 0; i < length; ++i) {
                    tmpLINT.add(valueObject.getIndex(i).getLong());
                }
                return new VariantInt64(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpLINT);
            }
            case "REAL": 
            case "FLOAT": {
                ArrayList<Float> tmpREAL = new ArrayList<Float>(length);
                for (int i = 0; i < length; ++i) {
                    tmpREAL.add(Float.valueOf(valueObject.getIndex(i).getFloat()));
                }
                return new VariantFloat(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpREAL);
            }
            case "LREAL": 
            case "DOUBLE": {
                ArrayList<Double> tmpLREAL = new ArrayList<Double>(length);
                for (int i = 0; i < length; ++i) {
                    tmpLREAL.add(valueObject.getIndex(i).getDouble());
                }
                return new VariantDouble(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpLREAL);
            }
            case "CHAR": 
            case "STRING": 
            case "WCHAR": 
            case "WSTRING": 
            case "STRING16": {
                ArrayList<PascalString> tmpString = new ArrayList<PascalString>(length);
                for (int i = 0; i < length; ++i) {
                    String s = valueObject.getIndex(i).getString();
                    tmpString.add(new PascalString(s));
                }
                return new VariantString(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpString);
            }
            case "DATE_AND_TIME": {
                ArrayList<Long> tmpDateTime = new ArrayList<Long>(length);
                for (int i = 0; i < length; ++i) {
                    tmpDateTime.add(valueObject.getIndex(i).getDateTime().toEpochSecond(ZoneOffset.UTC));
                }
                return new VariantDateTime(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpDateTime);
            }
        }
        throw new PlcRuntimeException("Unsupported write field type " + dataType);
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        LOGGER.trace("Writing Value");
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        DefaultPlcWriteRequest request = (DefaultPlcWriteRequest)writeRequest;
        RequestHeader requestHeader = new RequestHeader(this.channel.getAuthenticationToken(), SecureChannel.getCurrentDateTime(), this.channel.getRequestHandle(), 0L, NULL_STRING, 10000L, NULL_EXTENSION_OBJECT);
        ArrayList<ExtensionObjectDefinition> writeValueList = new ArrayList<ExtensionObjectDefinition>(request.getFieldNames().size());
        for (String fieldName : request.getFieldNames()) {
            OpcuaField field = (OpcuaField)request.getField(fieldName);
            NodeId nodeId = this.generateNodeId(field);
            writeValueList.add(new WriteValue(nodeId, 13L, NULL_STRING, new DataValue(false, false, false, false, false, true, this.fromPlcValue(fieldName, field, writeRequest), null, null, null, null, null)));
        }
        WriteRequest opcuaWriteRequest = new WriteRequest(requestHeader, writeValueList.size(), writeValueList);
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(opcuaWriteRequest.getIdentifier())), null, null);
        ExtensionObject extObject = new ExtensionObject(expandedNodeId, null, opcuaWriteRequest, false);
        try {
            WriteBufferByteBased buffer = new WriteBufferByteBased(extObject.getLengthInBytes(), ByteOrder.LITTLE_ENDIAN);
            extObject.serialize((WriteBuffer)buffer);
            Consumer<byte[]> consumer = opcuaResponse -> {
                WriteResponse responseMessage = null;
                try {
                    responseMessage = (WriteResponse)ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaResponse, ByteOrder.LITTLE_ENDIAN), false).getBody();
                }
                catch (ParseException e) {
                    throw new PlcRuntimeException((Throwable)e);
                }
                PlcWriteResponse response = this.writeResponse(request, responseMessage);
                future.complete(response);
            };
            Consumer<TimeoutException> timeout = future::completeExceptionally;
            BiConsumer<OpcuaAPU, Throwable> error = (message, t) -> future.completeExceptionally((Throwable)t);
            this.channel.submit((ConversationContext<OpcuaAPU>)this.context, timeout, error, consumer, buffer);
        }
        catch (SerializationException e) {
            LOGGER.error("Unable to serialise the ReadRequest");
        }
        return future;
    }

    private PlcWriteResponse writeResponse(DefaultPlcWriteRequest request, WriteResponse writeResponse) {
        HashMap<String, PlcResponseCode> responseMap = new HashMap<String, PlcResponseCode>();
        List<StatusCode> results = writeResponse.getResults();
        Iterator responseIterator = request.getFieldNames().iterator();
        block4: for (int i = 0; i < request.getFieldNames().size(); ++i) {
            String fieldName = (String)responseIterator.next();
            OpcuaStatusCode statusCode = OpcuaStatusCode.enumForValue(results.get(i).getStatusCode());
            switch (statusCode) {
                case Good: {
                    responseMap.put(fieldName, PlcResponseCode.OK);
                    continue block4;
                }
                case BadNodeIdUnknown: {
                    responseMap.put(fieldName, PlcResponseCode.NOT_FOUND);
                    continue block4;
                }
                default: {
                    responseMap.put(fieldName, PlcResponseCode.REMOTE_ERROR);
                }
            }
        }
        return new DefaultPlcWriteResponse((PlcWriteRequest)request, responseMap);
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        return CompletableFuture.supplyAsync(() -> {
            long subscriptionId;
            HashMap<String, ResponseItem> values = new HashMap<String, ResponseItem>();
            ArrayList fields = new ArrayList(subscriptionRequest.getFieldNames());
            long cycleTime = subscriptionRequest.getField((String)fields.get(0)).getDuration().orElse(Duration.ofMillis(1000L)).toMillis();
            try {
                CompletableFuture<CreateSubscriptionResponse> subscription = this.onSubscribeCreateSubscription(cycleTime);
                CreateSubscriptionResponse response = subscription.get(10000L, TimeUnit.MILLISECONDS);
                subscriptionId = response.getSubscriptionId();
                this.subscriptions.put(subscriptionId, new OpcuaSubscriptionHandle((ConversationContext<OpcuaAPU>)this.context, this, this.channel, subscriptionRequest, subscriptionId, cycleTime));
            }
            catch (Exception e) {
                throw new PlcRuntimeException("Unable to subscribe because of: " + e.getMessage());
            }
            for (String fieldName : subscriptionRequest.getFieldNames()) {
                DefaultPlcSubscriptionField fieldDefaultPlcSubscription = (DefaultPlcSubscriptionField)subscriptionRequest.getField(fieldName);
                if (!(fieldDefaultPlcSubscription.getPlcField() instanceof OpcuaField)) {
                    values.put(fieldName, new ResponseItem(PlcResponseCode.INVALID_ADDRESS, null));
                    continue;
                }
                values.put(fieldName, new ResponseItem(PlcResponseCode.OK, (Object)((PlcSubscriptionHandle)this.subscriptions.get(subscriptionId))));
            }
            return new DefaultPlcSubscriptionResponse(subscriptionRequest, values);
        });
    }

    private CompletableFuture<CreateSubscriptionResponse> onSubscribeCreateSubscription(long cycleTime) {
        CompletableFuture<CreateSubscriptionResponse> future = new CompletableFuture<CreateSubscriptionResponse>();
        LOGGER.trace("Entering creating subscription request");
        RequestHeader requestHeader = new RequestHeader(this.channel.getAuthenticationToken(), SecureChannel.getCurrentDateTime(), this.channel.getRequestHandle(), 0L, NULL_STRING, 10000L, NULL_EXTENSION_OBJECT);
        CreateSubscriptionRequest createSubscriptionRequest = new CreateSubscriptionRequest(requestHeader, cycleTime, 12000L, 5L, 65536L, true, 0);
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(createSubscriptionRequest.getIdentifier())), null, null);
        ExtensionObject extObject = new ExtensionObject(expandedNodeId, null, createSubscriptionRequest, false);
        try {
            WriteBufferByteBased buffer = new WriteBufferByteBased(extObject.getLengthInBytes(), ByteOrder.LITTLE_ENDIAN);
            extObject.serialize((WriteBuffer)buffer);
            Consumer<byte[]> consumer = opcuaResponse -> {
                CreateSubscriptionResponse responseMessage = null;
                try {
                    responseMessage = (CreateSubscriptionResponse)ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaResponse, ByteOrder.LITTLE_ENDIAN), false).getBody();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                future.complete(responseMessage);
            };
            Consumer<TimeoutException> timeout = e -> {
                LOGGER.error("Timeout while waiting on the crate subscription response", (Throwable)e);
                future.completeExceptionally((Throwable)e);
            };
            BiConsumer<OpcuaAPU, Throwable> error = (message, e) -> {
                LOGGER.error("Error while creating the subscription", e);
                future.completeExceptionally((Throwable)e);
            };
            this.channel.submit((ConversationContext<OpcuaAPU>)this.context, timeout, error, consumer, buffer);
        }
        catch (SerializationException e2) {
            LOGGER.error("Error while creating the subscription", (Throwable)e2);
            future.completeExceptionally(e2);
        }
        return future;
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        unsubscriptionRequest.getSubscriptionHandles().forEach(o -> {
            OpcuaSubscriptionHandle opcuaSubHandle = (OpcuaSubscriptionHandle)((Object)o);
            opcuaSubHandle.stopSubscriber();
        });
        return null;
    }

    public void removeSubscription(Long subscriptionId) {
        this.subscriptions.remove(subscriptionId);
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        LinkedList<PlcConsumerRegistration> registrations = new LinkedList<PlcConsumerRegistration>();
        for (PlcSubscriptionHandle subscriptionHandle : handles) {
            LOGGER.debug("Registering Consumer");
            PlcConsumerRegistration consumerRegistration = subscriptionHandle.register(consumer);
            registrations.add(consumerRegistration);
        }
        return new DefaultPlcConsumerRegistration((PlcSubscriber)this, consumer, handles.toArray(new PlcSubscriptionHandle[0]));
    }

    public void unregister(PlcConsumerRegistration registration) {
        registration.unregister();
    }

    public static long getDateTime(long dateTime) {
        return (dateTime - 116444736000000000L) / 10000L;
    }

    private GuidValue toGuidValue(String identifier) {
        LOGGER.error("Querying Guid nodes is not supported");
        byte[] data4 = new byte[]{0, 0};
        byte[] data5 = new byte[]{0, 0, 0, 0, 0, 0};
        return new GuidValue(0L, 0, 0, data4, data5);
    }
}

