/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.NodeIdType;
import org.apache.plc4x.java.opcua.readwrite.NodeIdTypeDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class NodeIdByteString
extends NodeIdTypeDefinition
implements Message {
    protected final int namespaceIndex;
    protected final PascalByteString id;

    @Override
    public NodeIdType getNodeType() {
        return NodeIdType.nodeIdTypeByteString;
    }

    public NodeIdByteString(int namespaceIndex, PascalByteString id) {
        this.namespaceIndex = namespaceIndex;
        this.id = id;
    }

    public int getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public PascalByteString getId() {
        return this.id;
    }

    @Override
    public String getIdentifier() {
        return String.valueOf(this.getId().getStringValue());
    }

    @Override
    protected void serializeNodeIdTypeDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("NodeIdByteString", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"namespaceIndex", (Object)this.namespaceIndex, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"id", (Object)this.id, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        String identifier = this.getIdentifier();
        writeBuffer.writeVirtual("identifier", (Object)identifier, new WithWriterArgs[0]);
        writeBuffer.popContext("NodeIdByteString", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NodeIdByteString _value = this;
        lengthInBits += 16;
        return lengthInBits += this.id.getLengthInBits();
    }

    public static NodeIdByteStringBuilder staticParseBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("NodeIdByteString", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        int namespaceIndex = (Integer)FieldReaderFactory.readSimpleField((String)"namespaceIndex", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalByteString id = (PascalByteString)FieldReaderFactory.readSimpleField((String)"id", (DataReader)new DataReaderComplexDefault(() -> PascalByteString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        String identifier = (String)FieldReaderFactory.readVirtualField((String)"identifier", String.class, (Object)id.getStringValue(), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("NodeIdByteString", new WithReaderArgs[0]);
        return new NodeIdByteStringBuilder(namespaceIndex, id);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeIdByteString)) {
            return false;
        }
        NodeIdByteString that = (NodeIdByteString)o;
        return this.getNamespaceIndex() == that.getNamespaceIndex() && this.getId() == that.getId() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNamespaceIndex(), this.getId());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NodeIdByteStringBuilder
    implements NodeIdTypeDefinition.NodeIdTypeDefinitionBuilder {
        private final int namespaceIndex;
        private final PascalByteString id;

        public NodeIdByteStringBuilder(int namespaceIndex, PascalByteString id) {
            this.namespaceIndex = namespaceIndex;
            this.id = id;
        }

        @Override
        public NodeIdByteString build() {
            NodeIdByteString nodeIdByteString = new NodeIdByteString(this.namespaceIndex, this.id);
            return nodeIdByteString;
        }
    }
}

