/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.NodeIdType;
import org.apache.plc4x.java.opcua.readwrite.NodeIdTypeDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class NodeIdString
extends NodeIdTypeDefinition
implements Message {
    protected final int namespaceIndex;
    protected final PascalString id;

    @Override
    public NodeIdType getNodeType() {
        return NodeIdType.nodeIdTypeString;
    }

    public NodeIdString(int namespaceIndex, PascalString id) {
        this.namespaceIndex = namespaceIndex;
        this.id = id;
    }

    public int getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public PascalString getId() {
        return this.id;
    }

    @Override
    public String getIdentifier() {
        return String.valueOf(this.getId().getStringValue());
    }

    @Override
    protected void serializeNodeIdTypeDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("NodeIdString", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"namespaceIndex", (Object)this.namespaceIndex, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"id", (Object)this.id, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        String identifier = this.getIdentifier();
        writeBuffer.writeVirtual("identifier", (Object)identifier, new WithWriterArgs[0]);
        writeBuffer.popContext("NodeIdString", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NodeIdString _value = this;
        lengthInBits += 16;
        return lengthInBits += this.id.getLengthInBits();
    }

    public static NodeIdStringBuilder staticParseBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("NodeIdString", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        int namespaceIndex = (Integer)FieldReaderFactory.readSimpleField((String)"namespaceIndex", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString id = (PascalString)FieldReaderFactory.readSimpleField((String)"id", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        String identifier = (String)FieldReaderFactory.readVirtualField((String)"identifier", String.class, (Object)id.getStringValue(), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("NodeIdString", new WithReaderArgs[0]);
        return new NodeIdStringBuilder(namespaceIndex, id);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeIdString)) {
            return false;
        }
        NodeIdString that = (NodeIdString)o;
        return this.getNamespaceIndex() == that.getNamespaceIndex() && this.getId() == that.getId() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNamespaceIndex(), this.getId());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NodeIdStringBuilder
    implements NodeIdTypeDefinition.NodeIdTypeDefinitionBuilder {
        private final int namespaceIndex;
        private final PascalString id;

        public NodeIdStringBuilder(int namespaceIndex, PascalString id) {
            this.namespaceIndex = namespaceIndex;
            this.id = id;
        }

        @Override
        public NodeIdString build() {
            NodeIdString nodeIdString = new NodeIdString(this.namespaceIndex, this.id);
            return nodeIdString;
        }
    }
}

