/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class OpcuaAcknowledgeResponse
extends MessagePDU
implements Message {
    protected final String chunk;
    protected final int version;
    protected final int receiveBufferSize;
    protected final int sendBufferSize;
    protected final int maxMessageSize;
    protected final int maxChunkCount;

    @Override
    public String getMessageType() {
        return "ACK";
    }

    @Override
    public Boolean getResponse() {
        return true;
    }

    public OpcuaAcknowledgeResponse(String chunk, int version, int receiveBufferSize, int sendBufferSize, int maxMessageSize, int maxChunkCount) {
        this.chunk = chunk;
        this.version = version;
        this.receiveBufferSize = receiveBufferSize;
        this.sendBufferSize = sendBufferSize;
        this.maxMessageSize = maxMessageSize;
        this.maxChunkCount = maxChunkCount;
    }

    public String getChunk() {
        return this.chunk;
    }

    public int getVersion() {
        return this.version;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public int getMaxChunkCount() {
        return this.maxChunkCount;
    }

    @Override
    protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("OpcuaAcknowledgeResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"chunk", (Object)this.chunk, (DataWriter)DataWriterFactory.writeString((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        int messageSize = this.getLengthInBytes();
        FieldWriterFactory.writeImplicitField((String)"messageSize", (Object)messageSize, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"version", (Object)this.version, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"receiveBufferSize", (Object)this.receiveBufferSize, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sendBufferSize", (Object)this.sendBufferSize, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"maxMessageSize", (Object)this.maxMessageSize, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"maxChunkCount", (Object)this.maxChunkCount, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("OpcuaAcknowledgeResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpcuaAcknowledgeResponse _value = this;
        lengthInBits += 8;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        return lengthInBits += 32;
    }

    public static OpcuaAcknowledgeResponseBuilder staticParseBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("OpcuaAcknowledgeResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        String chunk = (String)FieldReaderFactory.readSimpleField((String)"chunk", (DataReader)DataReaderFactory.readString((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        int messageSize = (Integer)FieldReaderFactory.readImplicitField((String)"messageSize", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int version = (Integer)FieldReaderFactory.readSimpleField((String)"version", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int receiveBufferSize = (Integer)FieldReaderFactory.readSimpleField((String)"receiveBufferSize", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int sendBufferSize = (Integer)FieldReaderFactory.readSimpleField((String)"sendBufferSize", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int maxMessageSize = (Integer)FieldReaderFactory.readSimpleField((String)"maxMessageSize", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int maxChunkCount = (Integer)FieldReaderFactory.readSimpleField((String)"maxChunkCount", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("OpcuaAcknowledgeResponse", new WithReaderArgs[0]);
        return new OpcuaAcknowledgeResponseBuilder(chunk, version, receiveBufferSize, sendBufferSize, maxMessageSize, maxChunkCount);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaAcknowledgeResponse)) {
            return false;
        }
        OpcuaAcknowledgeResponse that = (OpcuaAcknowledgeResponse)o;
        return this.getChunk() == that.getChunk() && this.getVersion() == that.getVersion() && this.getReceiveBufferSize() == that.getReceiveBufferSize() && this.getSendBufferSize() == that.getSendBufferSize() && this.getMaxMessageSize() == that.getMaxMessageSize() && this.getMaxChunkCount() == that.getMaxChunkCount() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getChunk(), this.getVersion(), this.getReceiveBufferSize(), this.getSendBufferSize(), this.getMaxMessageSize(), this.getMaxChunkCount());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpcuaAcknowledgeResponseBuilder
    implements MessagePDU.MessagePDUBuilder {
        private final String chunk;
        private final int version;
        private final int receiveBufferSize;
        private final int sendBufferSize;
        private final int maxMessageSize;
        private final int maxChunkCount;

        public OpcuaAcknowledgeResponseBuilder(String chunk, int version, int receiveBufferSize, int sendBufferSize, int maxMessageSize, int maxChunkCount) {
            this.chunk = chunk;
            this.version = version;
            this.receiveBufferSize = receiveBufferSize;
            this.sendBufferSize = sendBufferSize;
            this.maxMessageSize = maxMessageSize;
            this.maxChunkCount = maxChunkCount;
        }

        @Override
        public OpcuaAcknowledgeResponse build() {
            OpcuaAcknowledgeResponse opcuaAcknowledgeResponse = new OpcuaAcknowledgeResponse(this.chunk, this.version, this.receiveBufferSize, this.sendBufferSize, this.maxMessageSize, this.maxChunkCount);
            return opcuaAcknowledgeResponse;
        }
    }
}

