/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ParsingResult
extends ExtensionObjectDefinition
implements Message {
    protected final StatusCode statusCode;
    protected final int noOfDataStatusCodes;
    protected final List<StatusCode> dataStatusCodes;
    protected final int noOfDataDiagnosticInfos;
    protected final List<DiagnosticInfo> dataDiagnosticInfos;

    @Override
    public String getIdentifier() {
        return "612";
    }

    public ParsingResult(StatusCode statusCode, int noOfDataStatusCodes, List<StatusCode> dataStatusCodes, int noOfDataDiagnosticInfos, List<DiagnosticInfo> dataDiagnosticInfos) {
        this.statusCode = statusCode;
        this.noOfDataStatusCodes = noOfDataStatusCodes;
        this.dataStatusCodes = dataStatusCodes;
        this.noOfDataDiagnosticInfos = noOfDataDiagnosticInfos;
        this.dataDiagnosticInfos = dataDiagnosticInfos;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public int getNoOfDataStatusCodes() {
        return this.noOfDataStatusCodes;
    }

    public List<StatusCode> getDataStatusCodes() {
        return this.dataStatusCodes;
    }

    public int getNoOfDataDiagnosticInfos() {
        return this.noOfDataDiagnosticInfos;
    }

    public List<DiagnosticInfo> getDataDiagnosticInfos() {
        return this.dataDiagnosticInfos;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("ParsingResult", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"statusCode", (Object)this.statusCode, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfDataStatusCodes", (Object)this.noOfDataStatusCodes, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"dataStatusCodes", this.dataStatusCodes, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfDataDiagnosticInfos", (Object)this.noOfDataDiagnosticInfos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"dataDiagnosticInfos", this.dataDiagnosticInfos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ParsingResult", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        boolean last;
        int i;
        int lengthInBits = super.getLengthInBits();
        ParsingResult _value = this;
        lengthInBits += this.statusCode.getLengthInBits();
        lengthInBits += 32;
        if (this.dataStatusCodes != null) {
            i = 0;
            for (StatusCode statusCode : this.dataStatusCodes) {
                last = ++i >= this.dataStatusCodes.size();
                lengthInBits += statusCode.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.dataDiagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.dataDiagnosticInfos) {
                last = ++i >= this.dataDiagnosticInfos.size();
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ParsingResultBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("ParsingResult", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        StatusCode statusCode = (StatusCode)FieldReaderFactory.readSimpleField((String)"statusCode", (DataReader)new DataReaderComplexDefault(() -> StatusCode.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDataStatusCodes = (Integer)FieldReaderFactory.readSimpleField((String)"noOfDataStatusCodes", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List dataStatusCodes = FieldReaderFactory.readCountArrayField((String)"dataStatusCodes", (DataReader)new DataReaderComplexDefault(() -> StatusCode.staticParse(readBuffer), readBuffer), (long)noOfDataStatusCodes, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDataDiagnosticInfos = (Integer)FieldReaderFactory.readSimpleField((String)"noOfDataDiagnosticInfos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List dataDiagnosticInfos = FieldReaderFactory.readCountArrayField((String)"dataDiagnosticInfos", (DataReader)new DataReaderComplexDefault(() -> DiagnosticInfo.staticParse(readBuffer), readBuffer), (long)noOfDataDiagnosticInfos, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ParsingResult", new WithReaderArgs[0]);
        return new ParsingResultBuilder(statusCode, noOfDataStatusCodes, dataStatusCodes, noOfDataDiagnosticInfos, dataDiagnosticInfos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParsingResult)) {
            return false;
        }
        ParsingResult that = (ParsingResult)o;
        return this.getStatusCode() == that.getStatusCode() && this.getNoOfDataStatusCodes() == that.getNoOfDataStatusCodes() && this.getDataStatusCodes() == that.getDataStatusCodes() && this.getNoOfDataDiagnosticInfos() == that.getNoOfDataDiagnosticInfos() && this.getDataDiagnosticInfos() == that.getDataDiagnosticInfos() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStatusCode(), this.getNoOfDataStatusCodes(), this.getDataStatusCodes(), this.getNoOfDataDiagnosticInfos(), this.getDataDiagnosticInfos());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ParsingResultBuilder
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final StatusCode statusCode;
        private final int noOfDataStatusCodes;
        private final List<StatusCode> dataStatusCodes;
        private final int noOfDataDiagnosticInfos;
        private final List<DiagnosticInfo> dataDiagnosticInfos;

        public ParsingResultBuilder(StatusCode statusCode, int noOfDataStatusCodes, List<StatusCode> dataStatusCodes, int noOfDataDiagnosticInfos, List<DiagnosticInfo> dataDiagnosticInfos) {
            this.statusCode = statusCode;
            this.noOfDataStatusCodes = noOfDataStatusCodes;
            this.dataStatusCodes = dataStatusCodes;
            this.noOfDataDiagnosticInfos = noOfDataDiagnosticInfos;
            this.dataDiagnosticInfos = dataDiagnosticInfos;
        }

        @Override
        public ParsingResult build() {
            ParsingResult parsingResult = new ParsingResult(this.statusCode, this.noOfDataStatusCodes, this.dataStatusCodes, this.noOfDataDiagnosticInfos, this.dataDiagnosticInfos);
            return parsingResult;
        }
    }
}

