/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class ExtensionObjectDefinition implements Message {

  // Abstract accessors for discriminator values.
  public abstract String getIdentifier();

  public ExtensionObjectDefinition() {
    super();
  }

  protected abstract void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ExtensionObjectDefinition");

    // Switch field (Serialize the sub-type)
    serializeExtensionObjectDefinitionChild(writeBuffer);

    writeBuffer.popContext("ExtensionObjectDefinition");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    ExtensionObjectDefinition _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static ExtensionObjectDefinition staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 1)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 1, but got " + args.length);
    }
    String identifier;
    if (args[0] instanceof String) {
      identifier = (String) args[0];
    } else if (args[0] instanceof String) {
      identifier = String.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type String or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    return staticParse(readBuffer, identifier);
  }

  public static ExtensionObjectDefinition staticParse(ReadBuffer readBuffer, String identifier)
      throws ParseException {
    readBuffer.pullContext("ExtensionObjectDefinition");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    ExtensionObjectDefinitionBuilder builder = null;
    if (EvaluationHelper.equals(identifier, (String) "0")) {
      builder = NullExtension.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "12758")) {
      builder = Union.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "14535")) {
      builder = KeyValuePair.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "16315")) {
      builder =
          AdditionalParametersType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "17550")) {
      builder =
          EphemeralKeyType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15530")) {
      builder = EndpointType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "18808")) {
      builder = RationalNumber.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "18809")) {
      builder = OpcuaVector.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "18811")) {
      builder =
          CartesianCoordinates.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "18813")) {
      builder = Orientation.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "18815")) {
      builder = Frame.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15636")) {
      builder =
          IdentityMappingRuleType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "23500")) {
      builder =
          CurrencyUnitType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "12556")) {
      builder =
          TrustListDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "32287")) {
      builder =
          TransactionErrorType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15536")) {
      builder =
          DataTypeSchemaHeader.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "14527")) {
      builder =
          DataTypeDescription.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "24107")) {
      builder =
          PortableQualifiedName.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "24109")) {
      builder =
          UnsignedRationalNumber.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "14526")) {
      builder = FieldMetaData.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "14595")) {
      builder =
          ConfigurationVersionDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15582")) {
      builder =
          PublishedDataSetSourceDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "14275")) {
      builder =
          PublishedVariableDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15599")) {
      builder =
          DataSetWriterDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15600")) {
      builder =
          DataSetWriterTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15607")) {
      builder =
          DataSetWriterMessageDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15611")) {
      builder =
          PubSubGroupDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15613")) {
      builder =
          WriterGroupTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15618")) {
      builder =
          WriterGroupMessageDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15619")) {
      builder =
          PubSubConnectionDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15620")) {
      builder =
          ConnectionTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15504")) {
      builder =
          NetworkAddressDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15623")) {
      builder =
          ReaderGroupTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15624")) {
      builder =
          ReaderGroupMessageDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15630")) {
      builder =
          DataSetReaderTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15631")) {
      builder =
          DataSetReaderMessageDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15632")) {
      builder =
          SubscribedDataSetDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "14746")) {
      builder =
          FieldTargetDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15532")) {
      builder =
          PubSubConfigurationDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "23603")) {
      builder =
          SecurityGroupDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "25272")) {
      builder =
          PubSubKeyPushTargetDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "23605")) {
      builder = QosDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "25521")) {
      builder =
          PubSubConfigurationRefDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "23470")) {
      builder =
          AliasNameDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "24283")) {
      builder =
          UserManagementDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "25222")) {
      builder =
          PriorityMappingEntryType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "32661")) {
      builder =
          ReferenceDescriptionDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "32662")) {
      builder =
          ReferenceListEntryDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "98")) {
      builder =
          RolePermissionType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "99")) {
      builder =
          DataTypeDefinition.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "103")) {
      builder = StructureField.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "298")) {
      builder = Argument.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "7596")) {
      builder = EnumValueType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "12757")) {
      builder = OptionSet.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "8914")) {
      builder =
          TimeZoneDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "310")) {
      builder =
          ApplicationDescription.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "391")) {
      builder = RequestHeader.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "394")) {
      builder = ResponseHeader.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "397")) {
      builder = ServiceFault.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "15903")) {
      builder =
          SessionlessInvokeRequestType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "21001")) {
      builder =
          SessionlessInvokeResponseType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "422")) {
      builder =
          FindServersRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "425")) {
      builder =
          FindServersResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "12191")) {
      builder = ServerOnNetwork.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "12192")) {
      builder =
          FindServersOnNetworkRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "12193")) {
      builder =
          FindServersOnNetworkResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "306")) {
      builder = UserTokenPolicy.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "314")) {
      builder =
          EndpointDescription.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "428")) {
      builder =
          GetEndpointsRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "431")) {
      builder =
          GetEndpointsResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "434")) {
      builder =
          RegisteredServer.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "437")) {
      builder =
          RegisterServerRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "440")) {
      builder =
          RegisterServerResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "12892")) {
      builder =
          DiscoveryConfiguration.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "12195")) {
      builder =
          RegisterServer2Request.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "12196")) {
      builder =
          RegisterServer2Response.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "443")) {
      builder =
          ChannelSecurityToken.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "446")) {
      builder =
          OpenSecureChannelRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "449")) {
      builder =
          OpenSecureChannelResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "452")) {
      builder =
          CloseSecureChannelRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "455")) {
      builder =
          CloseSecureChannelResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "346")) {
      builder =
          SignedSoftwareCertificate.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "458")) {
      builder = SignatureData.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "461")) {
      builder =
          CreateSessionRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "464")) {
      builder =
          CreateSessionResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "467")) {
      builder =
          ActivateSessionRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "470")) {
      builder =
          ActivateSessionResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "473")) {
      builder =
          CloseSessionRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "476")) {
      builder =
          CloseSessionResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "479")) {
      builder = CancelRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "482")) {
      builder = CancelResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "351")) {
      builder = NodeAttributes.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "17608")) {
      builder =
          GenericAttributeValue.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "378")) {
      builder = AddNodesItem.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "485")) {
      builder = AddNodesResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "488")) {
      builder = AddNodesRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "491")) {
      builder =
          AddNodesResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "381")) {
      builder =
          AddReferencesItem.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "494")) {
      builder =
          AddReferencesRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "497")) {
      builder =
          AddReferencesResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "384")) {
      builder = DeleteNodesItem.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "500")) {
      builder =
          DeleteNodesRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "503")) {
      builder =
          DeleteNodesResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "387")) {
      builder =
          DeleteReferencesItem.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "506")) {
      builder =
          DeleteReferencesRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "509")) {
      builder =
          DeleteReferencesResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "513")) {
      builder = ViewDescription.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "516")) {
      builder =
          BrowseDescription.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "520")) {
      builder =
          ReferenceDescription.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "524")) {
      builder = BrowseResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "527")) {
      builder = BrowseRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "530")) {
      builder = BrowseResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "533")) {
      builder =
          BrowseNextRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "536")) {
      builder =
          BrowseNextResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "539")) {
      builder =
          RelativePathElement.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "542")) {
      builder = RelativePath.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "545")) {
      builder = BrowsePath.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "548")) {
      builder =
          BrowsePathTarget.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "551")) {
      builder =
          BrowsePathResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "554")) {
      builder =
          TranslateBrowsePathsToNodeIdsRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "557")) {
      builder =
          TranslateBrowsePathsToNodeIdsResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "560")) {
      builder =
          RegisterNodesRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "563")) {
      builder =
          RegisterNodesResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "566")) {
      builder =
          UnregisterNodesRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "569")) {
      builder =
          UnregisterNodesResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "333")) {
      builder =
          EndpointConfiguration.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "572")) {
      builder =
          QueryDataDescription.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "575")) {
      builder =
          NodeTypeDescription.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "579")) {
      builder = QueryDataSet.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "582")) {
      builder = NodeReference.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "585")) {
      builder =
          ContentFilterElement.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "588")) {
      builder = ContentFilter.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "591")) {
      builder = FilterOperand.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "606")) {
      builder =
          ContentFilterElementResult.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "609")) {
      builder =
          ContentFilterResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "612")) {
      builder = ParsingResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "615")) {
      builder =
          QueryFirstRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "618")) {
      builder =
          QueryFirstResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "621")) {
      builder =
          QueryNextRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "624")) {
      builder =
          QueryNextResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "628")) {
      builder = ReadValueId.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "631")) {
      builder = ReadRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "634")) {
      builder = ReadResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "637")) {
      builder =
          HistoryReadValueId.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "640")) {
      builder =
          HistoryReadResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "643")) {
      builder =
          HistoryReadDetails.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "658")) {
      builder = HistoryData.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "11218")) {
      builder =
          ModificationInfo.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "661")) {
      builder = HistoryEvent.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "664")) {
      builder =
          HistoryReadRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "667")) {
      builder =
          HistoryReadResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "670")) {
      builder = WriteValue.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "673")) {
      builder = WriteRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "676")) {
      builder = WriteResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "679")) {
      builder =
          HistoryUpdateDetails.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "697")) {
      builder =
          HistoryUpdateResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "700")) {
      builder =
          HistoryUpdateRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "703")) {
      builder =
          HistoryUpdateResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "706")) {
      builder =
          CallMethodRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "709")) {
      builder =
          CallMethodResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "712")) {
      builder = CallRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "715")) {
      builder = CallResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "721")) {
      builder =
          MonitoringFilter.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "950")) {
      builder =
          AggregateConfiguration.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "733")) {
      builder =
          MonitoringFilterResult.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "742")) {
      builder =
          MonitoringParameters.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "745")) {
      builder =
          MonitoredItemCreateRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "748")) {
      builder =
          MonitoredItemCreateResult.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "751")) {
      builder =
          CreateMonitoredItemsRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "754")) {
      builder =
          CreateMonitoredItemsResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "757")) {
      builder =
          MonitoredItemModifyRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "760")) {
      builder =
          MonitoredItemModifyResult.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "763")) {
      builder =
          ModifyMonitoredItemsRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "766")) {
      builder =
          ModifyMonitoredItemsResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "769")) {
      builder =
          SetMonitoringModeRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "772")) {
      builder =
          SetMonitoringModeResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "775")) {
      builder =
          SetTriggeringRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "778")) {
      builder =
          SetTriggeringResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "781")) {
      builder =
          DeleteMonitoredItemsRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "784")) {
      builder =
          DeleteMonitoredItemsResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "787")) {
      builder =
          CreateSubscriptionRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "790")) {
      builder =
          CreateSubscriptionResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "793")) {
      builder =
          ModifySubscriptionRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "796")) {
      builder =
          ModifySubscriptionResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "799")) {
      builder =
          SetPublishingModeRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "802")) {
      builder =
          SetPublishingModeResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "805")) {
      builder =
          NotificationMessage.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "947")) {
      builder =
          NotificationData.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "808")) {
      builder =
          MonitoredItemNotification.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "919")) {
      builder = EventFieldList.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "922")) {
      builder =
          HistoryEventFieldList.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "823")) {
      builder =
          SubscriptionAcknowledgement.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "826")) {
      builder = PublishRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "829")) {
      builder = PublishResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "832")) {
      builder =
          RepublishRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "835")) {
      builder =
          RepublishResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "838")) {
      builder = TransferResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "841")) {
      builder =
          TransferSubscriptionsRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "844")) {
      builder =
          TransferSubscriptionsResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "847")) {
      builder =
          DeleteSubscriptionsRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "850")) {
      builder =
          DeleteSubscriptionsResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "340")) {
      builder = BuildInfo.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "855")) {
      builder =
          RedundantServerDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "11945")) {
      builder =
          EndpointUrlListDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "11946")) {
      builder =
          NetworkGroupDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "858")) {
      builder =
          SamplingIntervalDiagnosticsDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "861")) {
      builder =
          ServerDiagnosticsSummaryDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "864")) {
      builder =
          ServerStatusDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "867")) {
      builder =
          SessionDiagnosticsDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "870")) {
      builder =
          SessionSecurityDiagnosticsDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "873")) {
      builder =
          ServiceCounterDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "301")) {
      builder = StatusResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "876")) {
      builder =
          SubscriptionDiagnosticsDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "879")) {
      builder =
          ModelChangeStructureDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "899")) {
      builder =
          SemanticChangeStructureDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "886")) {
      builder = Range.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "889")) {
      builder = EUInformation.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "12173")) {
      builder =
          ComplexNumberType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "12174")) {
      builder =
          DoubleComplexNumberType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "12081")) {
      builder = AxisInformation.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "12082")) {
      builder = XVType.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "896")) {
      builder =
          ProgramDiagnosticDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "24035")) {
      builder =
          ProgramDiagnostic2DataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "893")) {
      builder = Annotation.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "811")) {
      builder =
          DataChangeNotification.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "916")) {
      builder =
          EventNotificationList.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "820")) {
      builder =
          StatusChangeNotification.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, identifier);
    } else if (EvaluationHelper.equals(identifier, (String) "316")) {
      builder =
          UserIdentityToken.staticParseExtensionObjectDefinitionBuilder(readBuffer, identifier);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "identifier="
              + identifier
              + "]");
    }

    readBuffer.closeContext("ExtensionObjectDefinition");
    // Create the instance
    ExtensionObjectDefinition _extensionObjectDefinition = builder.build();
    return _extensionObjectDefinition;
  }

  public interface ExtensionObjectDefinitionBuilder {
    ExtensionObjectDefinition build();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ExtensionObjectDefinition)) {
      return false;
    }
    ExtensionObjectDefinition that = (ExtensionObjectDefinition) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
