/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum OpcuaNodeIdServicesVariableDevice {
  DeviceFailureEventType_EventId((int) 3662L),
  DeviceFailureEventType_EventType((int) 3663L),
  DeviceFailureEventType_SourceNode((int) 3664L),
  DeviceFailureEventType_SourceName((int) 3665L),
  DeviceFailureEventType_Time((int) 3666L),
  DeviceFailureEventType_ReceiveTime((int) 3667L),
  DeviceFailureEventType_LocalTime((int) 3668L),
  DeviceFailureEventType_Message((int) 3669L),
  DeviceFailureEventType_Severity((int) 3670L),
  DeviceFailureEventType_ConditionClassId((int) 31879L),
  DeviceFailureEventType_ConditionClassName((int) 31880L),
  DeviceFailureEventType_ConditionSubClassId((int) 31881L),
  DeviceFailureEventType_ConditionSubClassName((int) 31882L);
  private static final Map<Integer, OpcuaNodeIdServicesVariableDevice> map;

  static {
    map = new HashMap<>();
    for (OpcuaNodeIdServicesVariableDevice value : OpcuaNodeIdServicesVariableDevice.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  OpcuaNodeIdServicesVariableDevice(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static OpcuaNodeIdServicesVariableDevice enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
