/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum OpcuaDataType {
    NULL("NULL", 0),
    BOOL("BOOL", 1),
    BYTE("BYTE", 3),
    SINT("SINT", 2),
    INT("INT", 4),
    DINT("DINT", 6),
    LINT("LINT", 8),
    USINT("USINT", 3),
    UINT("UINT", 5),
    UDINT("UDINT", 7),
    ULINT("ULINT", 9),
    REAL("REAL", 10),
    LREAL("LREAL", 11),
    TIME("TIME", 1),
    LTIME("LTIME", 1),
    DATE("DATE", 1),
    LDATE("LDATE", 1),
    TIME_OF_DAY("TIME_OF_DAY", 1),
    LTIME_OF_DAY("LTIME_OF_DAY", 1),
    DATE_AND_TIME("DATE_AND_TIME", 13),
    LDATE_AND_TIME("LDATE_AND_TIME", 1),
    CHAR("CHAR", 1),
    WCHAR("WCHAR", 1),
    STRING("STRING", 12);

    private static final Map<String, OpcuaDataType> map;
    private final String value;
    private final short variantType;

    static {
        map = new HashMap<String, OpcuaDataType>();
        OpcuaDataType[] opcuaDataTypeArray = OpcuaDataType.values();
        int n = opcuaDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OpcuaDataType value = opcuaDataTypeArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private OpcuaDataType(String value, short variantType) {
        this.value = value;
        this.variantType = variantType;
    }

    public String getValue() {
        return this.value;
    }

    public short getVariantType() {
        return this.variantType;
    }

    public static OpcuaDataType firstEnumForFieldVariantType(short fieldValue) {
        OpcuaDataType[] opcuaDataTypeArray = OpcuaDataType.values();
        int n = opcuaDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OpcuaDataType _val = opcuaDataTypeArray[n2];
            if (_val.getVariantType() == fieldValue) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<OpcuaDataType> enumsForFieldVariantType(short fieldValue) {
        ArrayList<OpcuaDataType> _values = new ArrayList<OpcuaDataType>();
        OpcuaDataType[] opcuaDataTypeArray = OpcuaDataType.values();
        int n = opcuaDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OpcuaDataType _val = opcuaDataTypeArray[n2];
            if (_val.getVariantType() == fieldValue) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public static OpcuaDataType enumForValue(String value) {
        return map.get(value);
    }

    public static Boolean isDefined(String value) {
        return map.containsKey(value);
    }
}

