/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class OpcuaHelloRequest
extends MessagePDU
implements Message {
    protected final String chunk;
    protected final int version;
    protected final int receiveBufferSize;
    protected final int sendBufferSize;
    protected final int maxMessageSize;
    protected final int maxChunkCount;
    protected final PascalString endpoint;

    @Override
    public String getMessageType() {
        return "HEL";
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    public OpcuaHelloRequest(String chunk, int version, int receiveBufferSize, int sendBufferSize, int maxMessageSize, int maxChunkCount, PascalString endpoint) {
        this.chunk = chunk;
        this.version = version;
        this.receiveBufferSize = receiveBufferSize;
        this.sendBufferSize = sendBufferSize;
        this.maxMessageSize = maxMessageSize;
        this.maxChunkCount = maxChunkCount;
        this.endpoint = endpoint;
    }

    public String getChunk() {
        return this.chunk;
    }

    public int getVersion() {
        return this.version;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public int getMaxChunkCount() {
        return this.maxChunkCount;
    }

    public PascalString getEndpoint() {
        return this.endpoint;
    }

    @Override
    protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpcuaHelloRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"chunk", (Object)this.chunk, (DataWriter)DataWriterFactory.writeString((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        int messageSize = this.getLengthInBytes();
        FieldWriterFactory.writeImplicitField((String)"messageSize", (Object)messageSize, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"version", (Object)this.version, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"receiveBufferSize", (Object)this.receiveBufferSize, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sendBufferSize", (Object)this.sendBufferSize, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"maxMessageSize", (Object)this.maxMessageSize, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"maxChunkCount", (Object)this.maxChunkCount, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"endpoint", (Object)this.endpoint, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("OpcuaHelloRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpcuaHelloRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        return lengthInBits += this.endpoint.getLengthInBits();
    }

    public static MessagePDU.MessagePDUBuilder staticParseMessagePDUBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("OpcuaHelloRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        String chunk = (String)FieldReaderFactory.readSimpleField((String)"chunk", (DataReader)DataReaderFactory.readString((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        int messageSize = (Integer)FieldReaderFactory.readImplicitField((String)"messageSize", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int version = (Integer)FieldReaderFactory.readSimpleField((String)"version", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int receiveBufferSize = (Integer)FieldReaderFactory.readSimpleField((String)"receiveBufferSize", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int sendBufferSize = (Integer)FieldReaderFactory.readSimpleField((String)"sendBufferSize", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int maxMessageSize = (Integer)FieldReaderFactory.readSimpleField((String)"maxMessageSize", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int maxChunkCount = (Integer)FieldReaderFactory.readSimpleField((String)"maxChunkCount", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString endpoint = (PascalString)FieldReaderFactory.readSimpleField((String)"endpoint", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("OpcuaHelloRequest", new WithReaderArgs[0]);
        return new OpcuaHelloRequestBuilderImpl(chunk, version, receiveBufferSize, sendBufferSize, maxMessageSize, maxChunkCount, endpoint);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaHelloRequest)) {
            return false;
        }
        OpcuaHelloRequest that = (OpcuaHelloRequest)o;
        return this.getChunk() == that.getChunk() && this.getVersion() == that.getVersion() && this.getReceiveBufferSize() == that.getReceiveBufferSize() && this.getSendBufferSize() == that.getSendBufferSize() && this.getMaxMessageSize() == that.getMaxMessageSize() && this.getMaxChunkCount() == that.getMaxChunkCount() && this.getEndpoint() == that.getEndpoint() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getChunk(), this.getVersion(), this.getReceiveBufferSize(), this.getSendBufferSize(), this.getMaxMessageSize(), this.getMaxChunkCount(), this.getEndpoint());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpcuaHelloRequestBuilderImpl
    implements MessagePDU.MessagePDUBuilder {
        private final String chunk;
        private final int version;
        private final int receiveBufferSize;
        private final int sendBufferSize;
        private final int maxMessageSize;
        private final int maxChunkCount;
        private final PascalString endpoint;

        public OpcuaHelloRequestBuilderImpl(String chunk, int version, int receiveBufferSize, int sendBufferSize, int maxMessageSize, int maxChunkCount, PascalString endpoint) {
            this.chunk = chunk;
            this.version = version;
            this.receiveBufferSize = receiveBufferSize;
            this.sendBufferSize = sendBufferSize;
            this.maxMessageSize = maxMessageSize;
            this.maxChunkCount = maxChunkCount;
            this.endpoint = endpoint;
        }

        @Override
        public OpcuaHelloRequest build() {
            OpcuaHelloRequest opcuaHelloRequest = new OpcuaHelloRequest(this.chunk, this.version, this.receiveBufferSize, this.sendBufferSize, this.maxMessageSize, this.maxChunkCount, this.endpoint);
            return opcuaHelloRequest;
        }
    }
}

