/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExpandedNodeId;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.Variant;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class QueryDataSet
extends ExtensionObjectDefinition
implements Message {
    protected final ExpandedNodeId nodeId;
    protected final ExpandedNodeId typeDefinitionNode;
    protected final int noOfValues;
    protected final List<Variant> values;

    @Override
    public String getIdentifier() {
        return "579";
    }

    public QueryDataSet(ExpandedNodeId nodeId, ExpandedNodeId typeDefinitionNode, int noOfValues, List<Variant> values) {
        this.nodeId = nodeId;
        this.typeDefinitionNode = typeDefinitionNode;
        this.noOfValues = noOfValues;
        this.values = values;
    }

    public ExpandedNodeId getNodeId() {
        return this.nodeId;
    }

    public ExpandedNodeId getTypeDefinitionNode() {
        return this.typeDefinitionNode;
    }

    public int getNoOfValues() {
        return this.noOfValues;
    }

    public List<Variant> getValues() {
        return this.values;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("QueryDataSet", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"nodeId", (Object)this.nodeId, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"typeDefinitionNode", (Object)this.typeDefinitionNode, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfValues", (Object)this.noOfValues, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"values", this.values, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("QueryDataSet", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        QueryDataSet _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.nodeId.getLengthInBits();
        lengthInBits += this.typeDefinitionNode.getLengthInBits();
        lengthInBits += 32;
        if (this.values != null) {
            int i = 0;
            for (Variant element : this.values) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.values.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("QueryDataSet", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ExpandedNodeId nodeId = (ExpandedNodeId)FieldReaderFactory.readSimpleField((String)"nodeId", (DataReader)new DataReaderComplexDefault(() -> ExpandedNodeId.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ExpandedNodeId typeDefinitionNode = (ExpandedNodeId)FieldReaderFactory.readSimpleField((String)"typeDefinitionNode", (DataReader)new DataReaderComplexDefault(() -> ExpandedNodeId.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfValues = (Integer)FieldReaderFactory.readSimpleField((String)"noOfValues", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List values = FieldReaderFactory.readCountArrayField((String)"values", (DataReader)new DataReaderComplexDefault(() -> Variant.staticParse(readBuffer), readBuffer), (long)noOfValues, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("QueryDataSet", new WithReaderArgs[0]);
        return new QueryDataSetBuilderImpl(nodeId, typeDefinitionNode, noOfValues, values);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryDataSet)) {
            return false;
        }
        QueryDataSet that = (QueryDataSet)o;
        return this.getNodeId() == that.getNodeId() && this.getTypeDefinitionNode() == that.getTypeDefinitionNode() && this.getNoOfValues() == that.getNoOfValues() && this.getValues() == that.getValues() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNodeId(), this.getTypeDefinitionNode(), this.getNoOfValues(), this.getValues());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class QueryDataSetBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExpandedNodeId nodeId;
        private final ExpandedNodeId typeDefinitionNode;
        private final int noOfValues;
        private final List<Variant> values;

        public QueryDataSetBuilderImpl(ExpandedNodeId nodeId, ExpandedNodeId typeDefinitionNode, int noOfValues, List<Variant> values) {
            this.nodeId = nodeId;
            this.typeDefinitionNode = typeDefinitionNode;
            this.noOfValues = noOfValues;
            this.values = values;
        }

        @Override
        public QueryDataSet build() {
            QueryDataSet queryDataSet = new QueryDataSet(this.nodeId, this.typeDefinitionNode, this.noOfValues, this.values);
            return queryDataSet;
        }
    }
}

