/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ServerOnNetwork
extends ExtensionObjectDefinition
implements Message {
    protected final long recordId;
    protected final PascalString serverName;
    protected final PascalString discoveryUrl;
    protected final int noOfServerCapabilities;
    protected final List<PascalString> serverCapabilities;

    @Override
    public String getIdentifier() {
        return "12191";
    }

    public ServerOnNetwork(long recordId, PascalString serverName, PascalString discoveryUrl, int noOfServerCapabilities, List<PascalString> serverCapabilities) {
        this.recordId = recordId;
        this.serverName = serverName;
        this.discoveryUrl = discoveryUrl;
        this.noOfServerCapabilities = noOfServerCapabilities;
        this.serverCapabilities = serverCapabilities;
    }

    public long getRecordId() {
        return this.recordId;
    }

    public PascalString getServerName() {
        return this.serverName;
    }

    public PascalString getDiscoveryUrl() {
        return this.discoveryUrl;
    }

    public int getNoOfServerCapabilities() {
        return this.noOfServerCapabilities;
    }

    public List<PascalString> getServerCapabilities() {
        return this.serverCapabilities;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ServerOnNetwork", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"recordId", (Object)this.recordId, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"serverName", (Object)this.serverName, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"discoveryUrl", (Object)this.discoveryUrl, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfServerCapabilities", (Object)this.noOfServerCapabilities, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"serverCapabilities", this.serverCapabilities, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ServerOnNetwork", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ServerOnNetwork _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += this.serverName.getLengthInBits();
        lengthInBits += this.discoveryUrl.getLengthInBits();
        lengthInBits += 32;
        if (this.serverCapabilities != null) {
            int i = 0;
            for (PascalString element : this.serverCapabilities) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.serverCapabilities.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("ServerOnNetwork", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long recordId = (Long)FieldReaderFactory.readSimpleField((String)"recordId", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString serverName = (PascalString)FieldReaderFactory.readSimpleField((String)"serverName", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString discoveryUrl = (PascalString)FieldReaderFactory.readSimpleField((String)"discoveryUrl", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfServerCapabilities = (Integer)FieldReaderFactory.readSimpleField((String)"noOfServerCapabilities", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List serverCapabilities = FieldReaderFactory.readCountArrayField((String)"serverCapabilities", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (long)noOfServerCapabilities, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ServerOnNetwork", new WithReaderArgs[0]);
        return new ServerOnNetworkBuilderImpl(recordId, serverName, discoveryUrl, noOfServerCapabilities, serverCapabilities);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerOnNetwork)) {
            return false;
        }
        ServerOnNetwork that = (ServerOnNetwork)o;
        return this.getRecordId() == that.getRecordId() && this.getServerName() == that.getServerName() && this.getDiscoveryUrl() == that.getDiscoveryUrl() && this.getNoOfServerCapabilities() == that.getNoOfServerCapabilities() && this.getServerCapabilities() == that.getServerCapabilities() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRecordId(), this.getServerName(), this.getDiscoveryUrl(), this.getNoOfServerCapabilities(), this.getServerCapabilities());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ServerOnNetworkBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final long recordId;
        private final PascalString serverName;
        private final PascalString discoveryUrl;
        private final int noOfServerCapabilities;
        private final List<PascalString> serverCapabilities;

        public ServerOnNetworkBuilderImpl(long recordId, PascalString serverName, PascalString discoveryUrl, int noOfServerCapabilities, List<PascalString> serverCapabilities) {
            this.recordId = recordId;
            this.serverName = serverName;
            this.discoveryUrl = discoveryUrl;
            this.noOfServerCapabilities = noOfServerCapabilities;
            this.serverCapabilities = serverCapabilities;
        }

        @Override
        public ServerOnNetwork build() {
            ServerOnNetwork serverOnNetwork = new ServerOnNetwork(this.recordId, this.serverName, this.discoveryUrl, this.noOfServerCapabilities, this.serverCapabilities);
            return serverOnNetwork;
        }
    }
}

