/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class StatusChangeNotification
extends ExtensionObjectDefinition
implements Message {
    protected final StatusCode status;
    protected final DiagnosticInfo diagnosticInfo;

    @Override
    public String getIdentifier() {
        return "820";
    }

    public StatusChangeNotification(StatusCode status, DiagnosticInfo diagnosticInfo) {
        this.status = status;
        this.diagnosticInfo = diagnosticInfo;
    }

    public StatusCode getStatus() {
        return this.status;
    }

    public DiagnosticInfo getDiagnosticInfo() {
        return this.diagnosticInfo;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("StatusChangeNotification", new WithWriterArgs[0]);
        int notificationLength = this.getLengthInBytes();
        FieldWriterFactory.writeImplicitField((String)"notificationLength", (Object)notificationLength, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"status", (Object)this.status, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"diagnosticInfo", (Object)this.diagnosticInfo, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("StatusChangeNotification", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        StatusChangeNotification _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += this.status.getLengthInBits();
        return lengthInBits += this.diagnosticInfo.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("StatusChangeNotification", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int notificationLength = (Integer)FieldReaderFactory.readImplicitField((String)"notificationLength", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        StatusCode status = (StatusCode)FieldReaderFactory.readSimpleField((String)"status", (DataReader)new DataReaderComplexDefault(() -> StatusCode.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        DiagnosticInfo diagnosticInfo = (DiagnosticInfo)FieldReaderFactory.readSimpleField((String)"diagnosticInfo", (DataReader)new DataReaderComplexDefault(() -> DiagnosticInfo.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("StatusChangeNotification", new WithReaderArgs[0]);
        return new StatusChangeNotificationBuilderImpl(status, diagnosticInfo);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatusChangeNotification)) {
            return false;
        }
        StatusChangeNotification that = (StatusChangeNotification)o;
        return this.getStatus() == that.getStatus() && this.getDiagnosticInfo() == that.getDiagnosticInfo() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStatus(), this.getDiagnosticInfo());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class StatusChangeNotificationBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final StatusCode status;
        private final DiagnosticInfo diagnosticInfo;

        public StatusChangeNotificationBuilderImpl(StatusCode status, DiagnosticInfo diagnosticInfo) {
            this.status = status;
            this.diagnosticInfo = diagnosticInfo;
        }

        @Override
        public StatusChangeNotification build() {
            StatusChangeNotification statusChangeNotification = new StatusChangeNotification(this.status, this.diagnosticInfo);
            return statusChangeNotification;
        }
    }
}

