/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.tag;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.EnumUtils;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.exceptions.PlcUnsupportedDataTypeException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.types.PlcSubscriptionType;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.opcua.readwrite.OpcuaDataType;
import org.apache.plc4x.java.opcua.readwrite.OpcuaIdentifierType;

public class OpcuaTag
implements PlcSubscriptionTag {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("^ns=(?<namespace>\\d+);(?<identifierType>[isgb])=(?<identifier>[^;]+)?(;(?<datatype>[a-zA-Z_]+))?$");
    private final OpcuaIdentifierType identifierType;
    private final int namespace;
    private final String identifier;
    private final OpcuaDataType dataType;

    private OpcuaTag(Integer namespace, String identifier, OpcuaIdentifierType identifierType, OpcuaDataType dataType) {
        this.identifier = Objects.requireNonNull(identifier);
        this.identifierType = Objects.requireNonNull(identifierType);
        int n = this.namespace = namespace != null ? namespace : 0;
        if (this.namespace < 0) {
            throw new IllegalArgumentException("namespace must be greater then zero. Was " + this.namespace);
        }
        this.dataType = dataType;
    }

    public static OpcuaTag of(String address) {
        String dataTypeString;
        Matcher matcher = ADDRESS_PATTERN.matcher(address);
        if (!matcher.matches()) {
            throw new PlcInvalidTagException(address, ADDRESS_PATTERN, "{address}");
        }
        String identifier = matcher.group("identifier");
        String identifierTypeString = matcher.group("identifierType");
        OpcuaIdentifierType identifierType = OpcuaIdentifierType.enumForValue(identifierTypeString);
        String namespaceString = matcher.group("namespace");
        Integer namespace = namespaceString != null ? Integer.parseInt(namespaceString) : 0;
        String string = dataTypeString = matcher.group("datatype") != null ? matcher.group("datatype").toUpperCase() : "NULL";
        if (!EnumUtils.isValidEnum(OpcuaDataType.class, (String)dataTypeString)) {
            throw new PlcUnsupportedDataTypeException("Datatype " + dataTypeString + " is unsupported by this protocol");
        }
        OpcuaDataType dataType = OpcuaDataType.valueOf(dataTypeString);
        return new OpcuaTag(namespace, identifier, identifierType, dataType);
    }

    public static boolean matches(String address) {
        return ADDRESS_PATTERN.matcher(address).matches();
    }

    public int getNamespace() {
        return this.namespace;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public OpcuaIdentifierType getIdentifierType() {
        return this.identifierType;
    }

    public OpcuaDataType getDataType() {
        return this.dataType;
    }

    public String getAddressString() {
        String address = String.format("ns=%d;%s=%s", this.namespace, this.identifierType.getValue(), this.identifier);
        if (this.dataType != null) {
            address = String.valueOf(address) + ";" + this.dataType.name();
        }
        return address;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.valueOf((String)this.dataType.name());
    }

    public List<ArrayInfo> getArrayInfo() {
        return super.getArrayInfo();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaTag)) {
            return false;
        }
        OpcuaTag that = (OpcuaTag)o;
        return this.namespace == that.namespace && this.identifier.equals(that.identifier) && this.identifierType == that.identifierType;
    }

    public int hashCode() {
        return Objects.hash(this.namespace);
    }

    public String toString() {
        return "OpcuaTag{namespace=" + this.namespace + "identifierType=" + this.identifierType.getValue() + "identifier=" + this.identifier + '}';
    }

    public PlcSubscriptionType getPlcSubscriptionType() {
        return null;
    }

    public Optional<Duration> getDuration() {
        return Optional.empty();
    }
}

