/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpcuaAcknowledgeResponse extends MessagePDU implements Message {

  // Accessors for discriminator values.
  public String getMessageType() {
    return (String) "ACK";
  }

  public Boolean getResponse() {
    return (boolean) true;
  }

  // Properties.
  protected final long version;
  protected final OpcuaProtocolLimits limits;

  public OpcuaAcknowledgeResponse(ChunkType chunk, long version, OpcuaProtocolLimits limits) {
    super(chunk);
    this.version = version;
    this.limits = limits;
  }

  public long getVersion() {
    return version;
  }

  public OpcuaProtocolLimits getLimits() {
    return limits;
  }

  @Override
  protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpcuaAcknowledgeResponse");

    // Simple Field (version)
    writeSimpleField("version", version, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (limits)
    writeSimpleField("limits", limits, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("OpcuaAcknowledgeResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpcuaAcknowledgeResponse _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (version)
    lengthInBits += 32;

    // Simple field (limits)
    lengthInBits += limits.getLengthInBits();

    return lengthInBits;
  }

  public static MessagePDUBuilder staticParseMessagePDUBuilder(
      ReadBuffer readBuffer, Boolean response) throws ParseException {
    readBuffer.pullContext("OpcuaAcknowledgeResponse");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long version = readSimpleField("version", readUnsignedLong(readBuffer, 32));

    OpcuaProtocolLimits limits =
        readSimpleField(
            "limits",
            new DataReaderComplexDefault<>(
                () -> OpcuaProtocolLimits.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("OpcuaAcknowledgeResponse");
    // Create the instance
    return new OpcuaAcknowledgeResponseBuilderImpl(version, limits);
  }

  public static class OpcuaAcknowledgeResponseBuilderImpl implements MessagePDU.MessagePDUBuilder {
    private final long version;
    private final OpcuaProtocolLimits limits;

    public OpcuaAcknowledgeResponseBuilderImpl(long version, OpcuaProtocolLimits limits) {
      this.version = version;
      this.limits = limits;
    }

    public OpcuaAcknowledgeResponse build(ChunkType chunk) {
      OpcuaAcknowledgeResponse opcuaAcknowledgeResponse =
          new OpcuaAcknowledgeResponse(chunk, version, limits);
      return opcuaAcknowledgeResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpcuaAcknowledgeResponse)) {
      return false;
    }
    OpcuaAcknowledgeResponse that = (OpcuaAcknowledgeResponse) o;
    return (getVersion() == that.getVersion())
        && (getLimits() == that.getLimits())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getVersion(), getLimits());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
