/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpcuaMessageError extends MessagePDU implements Message {

  // Accessors for discriminator values.
  public String getMessageType() {
    return (String) "ERR";
  }

  public Boolean getResponse() {
    return (boolean) true;
  }

  // Properties.
  protected final OpcuaStatusCode error;
  protected final PascalString reason;

  public OpcuaMessageError(ChunkType chunk, OpcuaStatusCode error, PascalString reason) {
    super(chunk);
    this.error = error;
    this.reason = reason;
  }

  public OpcuaStatusCode getError() {
    return error;
  }

  public PascalString getReason() {
    return reason;
  }

  @Override
  protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpcuaMessageError");

    // Simple Field (error)
    writeSimpleEnumField(
        "error",
        "OpcuaStatusCode",
        error,
        new DataWriterEnumDefault<>(
            OpcuaStatusCode::getValue, OpcuaStatusCode::name, writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (reason)
    writeSimpleField("reason", reason, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("OpcuaMessageError");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpcuaMessageError _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (error)
    lengthInBits += 32;

    // Simple field (reason)
    lengthInBits += reason.getLengthInBits();

    return lengthInBits;
  }

  public static MessagePDUBuilder staticParseMessagePDUBuilder(
      ReadBuffer readBuffer, Boolean response) throws ParseException {
    readBuffer.pullContext("OpcuaMessageError");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    OpcuaStatusCode error =
        readEnumField(
            "error",
            "OpcuaStatusCode",
            new DataReaderEnumDefault<>(
                OpcuaStatusCode::enumForValue, readUnsignedLong(readBuffer, 32)));

    PascalString reason =
        readSimpleField(
            "reason",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("OpcuaMessageError");
    // Create the instance
    return new OpcuaMessageErrorBuilderImpl(error, reason);
  }

  public static class OpcuaMessageErrorBuilderImpl implements MessagePDU.MessagePDUBuilder {
    private final OpcuaStatusCode error;
    private final PascalString reason;

    public OpcuaMessageErrorBuilderImpl(OpcuaStatusCode error, PascalString reason) {
      this.error = error;
      this.reason = reason;
    }

    public OpcuaMessageError build(ChunkType chunk) {
      OpcuaMessageError opcuaMessageError = new OpcuaMessageError(chunk, error, reason);
      return opcuaMessageError;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpcuaMessageError)) {
      return false;
    }
    OpcuaMessageError that = (OpcuaMessageError) o;
    return (getError() == that.getError())
        && (getReason() == that.getReason())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getError(), getReason());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
