/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum OpcuaNodeIdServicesReferenceType {
  References((int) 31L),
  NonHierarchicalReferences((int) 32L),
  HierarchicalReferences((int) 33L),
  HasChild((int) 34L),
  Organizes((int) 35L),
  HasEventSource((int) 36L),
  HasModellingRule((int) 37L),
  HasEncoding((int) 38L),
  HasDescription((int) 39L),
  HasTypeDefinition((int) 40L),
  GeneratesEvent((int) 41L),
  Aggregates((int) 44L),
  HasSubtype((int) 45L),
  HasProperty((int) 46L),
  HasComponent((int) 47L),
  HasNotifier((int) 48L),
  HasOrderedComponent((int) 49L),
  FromState((int) 51L),
  ToState((int) 52L),
  HasCause((int) 53L),
  HasEffect((int) 54L),
  HasHistoricalConfiguration((int) 56L),
  HasSubStateMachine((int) 117L),
  HasArgumentDescription((int) 129L),
  HasOptionalInputArgumentDescription((int) 131L),
  AlwaysGeneratesEvent((int) 3065L),
  HasTrueSubState((int) 9004L),
  HasFalseSubState((int) 9005L),
  HasCondition((int) 9006L),
  HasPubSubConnection((int) 14476L),
  DataSetToWriter((int) 14936L),
  HasGuard((int) 15112L),
  HasDataSetWriter((int) 15296L),
  HasDataSetReader((int) 15297L),
  HasAlarmSuppressionGroup((int) 16361L),
  AlarmGroupMember((int) 16362L),
  HasEffectDisable((int) 17276L),
  HasDictionaryEntry((int) 17597L),
  HasInterface((int) 17603L),
  HasAddIn((int) 17604L),
  HasEffectEnable((int) 17983L),
  HasEffectSuppressed((int) 17984L),
  HasEffectUnsuppressed((int) 17985L),
  HasWriterGroup((int) 18804L),
  HasReaderGroup((int) 18805L),
  AliasFor((int) 23469L),
  IsDeprecated((int) 23562L),
  HasStructuredComponent((int) 24136L),
  AssociatedWith((int) 24137L),
  UsesPriorityMappingTable((int) 25237L),
  HasLowerLayerInterface((int) 25238L),
  IsExecutableOn((int) 25253L),
  Controls((int) 25254L),
  Utilizes((int) 25255L),
  Requires((int) 25256L),
  IsPhysicallyConnectedTo((int) 25257L),
  RepresentsSameEntityAs((int) 25258L),
  RepresentsSameHardwareAs((int) 25259L),
  RepresentsSameFunctionalityAs((int) 25260L),
  IsHostedBy((int) 25261L),
  HasPhysicalComponent((int) 25262L),
  HasContainedComponent((int) 25263L),
  HasAttachedComponent((int) 25264L),
  IsExecutingOn((int) 25265L),
  HasPushedSecurityGroup((int) 25345L),
  AlarmSuppressionGroupMember((int) 32059L),
  HasKeyValueDescription((int) 32407L),
  HasEngineeringUnitDetails((int) 32558L),
  HasQuantity((int) 32559L),
  HasCurrentData((int) 32633L),
  HasCurrentEvent((int) 32634L),
  HasReferenceDescription((int) 32679L);
  private static final Map<Integer, OpcuaNodeIdServicesReferenceType> map;

  static {
    map = new HashMap<>();
    for (OpcuaNodeIdServicesReferenceType value : OpcuaNodeIdServicesReferenceType.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  OpcuaNodeIdServicesReferenceType(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static OpcuaNodeIdServicesReferenceType enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
