/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import org.apache.plc4x.java.opcua.config.Limits;
import org.apache.plc4x.java.opcua.context.SecureChannel;
import org.apache.plc4x.java.opcua.security.MessageSecurity;
import org.apache.plc4x.java.opcua.security.SecurityPolicy;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.annotations.ComplexConfigurationParameter;
import org.apache.plc4x.java.spi.configuration.annotations.ConfigurationParameter;
import org.apache.plc4x.java.spi.configuration.annotations.Description;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.BooleanDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.LongDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.StringDefaultValue;

public class OpcuaConfiguration
implements PlcConnectionConfiguration {
    @ConfigurationParameter(value="protocol-code")
    private String protocolCode;
    @ConfigurationParameter(value="transport-code")
    private String transportCode;
    @ConfigurationParameter(value="transport-config")
    private String transportConfig;
    @ConfigurationParameter(value="discovery")
    @BooleanDefaultValue(value=true)
    @Description(value="Controls the feature of the discovery endpoint of an OPC UA server which every server\nwill propagate over an '<address>/discovery' endpoint. The most common issue here is that most servers are not correctly\nconfigured and propagate the wrong external IP or URL address. If that is the case you can disable the discovery by\nconfiguring it with a `false` value.\n\nThe discovery phase is always conducted using `NONE` security policy.")
    private boolean discovery;
    @ConfigurationParameter(value="username")
    @Description(value="A username to authenticate to the OPCUA server with.")
    private String username;
    @ConfigurationParameter(value="password")
    @Description(value="A password to authenticate to the OPCUA server with.")
    private String password;
    @ConfigurationParameter(value="security-policy")
    @StringDefaultValue(value="NONE")
    @Description(value="The security policy applied to communication channel between driver and OPC UA server.\nDefault value assumes. Possible options are `NONE`, `Basic128Rsa15`, `Basic256`, `Basic256Sha256`, `Aes128_Sha256_RsaOaep`, `Aes256_Sha256_RsaPss`.")
    private SecurityPolicy securityPolicy;
    @ConfigurationParameter(value="message-security")
    @StringDefaultValue(value="SIGN_ENCRYPT")
    @Description(value="The security policy applied to messages exchanged after handshake phase.\nPossible options are `NONE`, `SIGN`, `SIGN_ENCRYPT`.\nThis option is effective only when `securityPolicy` turns encryption (anything beyond `NONE`).")
    private MessageSecurity messageSecurity;
    @ConfigurationParameter(value="key-store-file")
    @Description(value="The Keystore file used to lookup client certificate and its private key.")
    private String keyStoreFile;
    @ConfigurationParameter(value="key-store-type")
    @StringDefaultValue(value="pkcs12")
    @Description(value="Keystore type used to access keystore and private key, defaults to PKCS (for Java 11+).\nPossible values are between others `jks`, `pkcs11`, `dks`, `jceks`.")
    private String keyStoreType;
    @ConfigurationParameter(value="key-store-password")
    @Description(value="Java keystore password used to access keystore and private key.")
    private String keyStorePassword;
    @ConfigurationParameter(value="server-certificate-file")
    @Description(value="Filesystem location where server certificate is located, supported formats are `DER` and `PEM`.")
    private String serverCertificateFile;
    @ConfigurationParameter(value="trust-store-file")
    @Description(value="The trust store file used to verify server certificates and its chain.")
    private String trustStoreFile;
    @ConfigurationParameter(value="trust-store-type")
    @StringDefaultValue(value="pkcs12")
    @Description(value="Keystore type used to access keystore and private key, defaults to PKCS (for Java 11+).\nPossible values are between others `jks`, `pkcs11`, `dks`, `jceks`.")
    private String trustStoreType;
    @ConfigurationParameter(value="trust-store-password")
    @Description(value="Password used to open trust store.")
    private String trustStorePassword;
    private X509Certificate serverCertificate;
    @ConfigurationParameter(value="channel-lifetime")
    @LongDefaultValue(value=3600000L)
    @Description(value="Time for which negotiated secure channel, its keys and session remains open. Value in milliseconds, by default 60 minutes.")
    private long channelLifetime;
    @ConfigurationParameter(value="session-timeout")
    @LongDefaultValue(value=120000L)
    @Description(value="Expiry time for opened secure session, value in milliseconds. Defaults to 2 minutes.")
    private long sessionTimeout;
    @ConfigurationParameter(value="negotiation-timeout")
    @LongDefaultValue(value=60000L)
    @Description(value="Timeout for all negotiation steps prior acceptance of application level operations - this timeout applies to open secure channel, create session and close calls. Defaults to 60 seconds.")
    private long negotiationTimeout;
    @ConfigurationParameter(value="request-timeout")
    @LongDefaultValue(value=30000L)
    @Description(value="Timeout for read/write/subscribe calls. Value in milliseconds.")
    private long requestTimeout;
    @ComplexConfigurationParameter(prefix="encoding", defaultOverrides={}, requiredOverrides={})
    @Description(value="TCP encoding options")
    private Limits limits;

    public String getProtocolCode() {
        return this.protocolCode;
    }

    public String getTransportCode() {
        return this.transportCode;
    }

    public String getTransportConfig() {
        return this.transportConfig;
    }

    public boolean isDiscovery() {
        return this.discovery;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public MessageSecurity getMessageSecurity() {
        return this.messageSecurity;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray();
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public char[] getTrustStorePassword() {
        return this.trustStorePassword == null ? null : this.trustStorePassword.toCharArray();
    }

    public Limits getEncodingLimits() {
        return this.limits;
    }

    public X509Certificate getServerCertificate() {
        if (this.serverCertificate == null && this.serverCertificateFile != null) {
            try {
                byte[] certificateBytes = Files.readAllBytes(Path.of(this.serverCertificateFile, new String[0]));
                this.serverCertificate = SecureChannel.getX509Certificate(certificateBytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.serverCertificate;
    }

    public void setServerCertificate(X509Certificate serverCertificate) {
        this.serverCertificate = serverCertificate;
    }

    public long getChannelLifetime() {
        return this.channelLifetime;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public long getNegotiationTimeout() {
        return this.negotiationTimeout;
    }

    public String toString() {
        return "OpcuaConfiguration{discovery=" + this.discovery + ", username='" + this.username + '\'' + ", password='" + (this.password != null ? "******" : null) + '\'' + ", securityPolicy='" + (Object)((Object)this.securityPolicy) + '\'' + ", keyStoreFile='" + this.keyStoreFile + '\'' + ", keyStorePassword='" + (this.keyStorePassword != null ? "******" : null) + '\'' + ", limits=" + this.limits + '}';
    }
}

