/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.context;

import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.commons.lang3.RandomUtils;
import org.apache.plc4x.java.api.exceptions.PlcProtocolException;
import org.apache.plc4x.java.opcua.config.Limits;
import org.apache.plc4x.java.opcua.config.OpcuaConfiguration;
import org.apache.plc4x.java.opcua.context.CallContext;
import org.apache.plc4x.java.opcua.context.CertificateKeyPair;
import org.apache.plc4x.java.opcua.context.EncryptionHandler;
import org.apache.plc4x.java.opcua.context.OpcuaDriverContext;
import org.apache.plc4x.java.opcua.context.SecureChannel;
import org.apache.plc4x.java.opcua.context.SecureChannelTransactionManager;
import org.apache.plc4x.java.opcua.protocol.chunk.ChunkStorage;
import org.apache.plc4x.java.opcua.protocol.chunk.MemoryChunkStorage;
import org.apache.plc4x.java.opcua.readwrite.BinaryPayload;
import org.apache.plc4x.java.opcua.readwrite.ChunkType;
import org.apache.plc4x.java.opcua.readwrite.ExpandedNodeId;
import org.apache.plc4x.java.opcua.readwrite.ExtensiblePayload;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectEncodingMask;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.NodeIdFourByte;
import org.apache.plc4x.java.opcua.readwrite.NodeIdTwoByte;
import org.apache.plc4x.java.opcua.readwrite.NodeIdTypeDefinition;
import org.apache.plc4x.java.opcua.readwrite.NullExtension;
import org.apache.plc4x.java.opcua.readwrite.OpcuaAPU;
import org.apache.plc4x.java.opcua.readwrite.OpcuaAcknowledgeResponse;
import org.apache.plc4x.java.opcua.readwrite.OpcuaCloseRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaConstants;
import org.apache.plc4x.java.opcua.readwrite.OpcuaHelloRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaMessageRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaMessageResponse;
import org.apache.plc4x.java.opcua.readwrite.OpcuaOpenRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaOpenResponse;
import org.apache.plc4x.java.opcua.readwrite.OpcuaProtocolLimits;
import org.apache.plc4x.java.opcua.readwrite.OpcuaStatusCode;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.Payload;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.opcua.readwrite.ResponseHeader;
import org.apache.plc4x.java.opcua.readwrite.SecurityHeader;
import org.apache.plc4x.java.opcua.readwrite.SequenceHeader;
import org.apache.plc4x.java.opcua.readwrite.ServiceFault;
import org.apache.plc4x.java.opcua.readwrite.SignatureData;
import org.apache.plc4x.java.opcua.security.MessageSecurity;
import org.apache.plc4x.java.opcua.security.SecurityPolicy;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conversation {
    private static final long EPOCH_OFFSET = 116444736000000000L;
    private static final ExpandedNodeId NULL_EXPANDED_NODE_ID = new ExpandedNodeId(false, false, new NodeIdTwoByte(0), null, null);
    protected static final ExtensionObject NULL_EXTENSION_OBJECT = new ExtensionObject(NULL_EXPANDED_NODE_ID, new ExtensionObjectEncodingMask(false, false, false), new NullExtension());
    private final Logger logger = LoggerFactory.getLogger(Conversation.class);
    private final AtomicReference<SecurityHeader> securityHeader = new AtomicReference<SecurityHeader>(new SecurityHeader(1L, 1L));
    private final AtomicLong senderSequenceNumber = new AtomicLong(-1L);
    private final AtomicReference<NodeIdTypeDefinition> authenticationToken = new AtomicReference<NodeIdTwoByte>(new NodeIdTwoByte(0));
    private final ConversationContext<OpcuaAPU> context;
    private final SecureChannelTransactionManager tm;
    private final SecurityPolicy securityPolicy;
    private final MessageSecurity messageSecurity;
    private final EncryptionHandler encryptionHandler;
    private final OpcuaDriverContext driverContext;
    private final OpcuaConfiguration configuration;
    private OpcuaProtocolLimits limits;
    private X509Certificate localCertificate = null;
    private X509Certificate remoteCertificate = null;
    private byte[] remoteNonce;
    private byte[] localNonce;
    private final BiPredicate<SequenceHeader, CompletableFuture<?>> sequenceValidator = (sequenceHeader, callback) -> {
        if (this.senderSequenceNumber.get() == -1L) {
            this.senderSequenceNumber.set(sequenceHeader.getSequenceNumber());
            return true;
        }
        int expectedSequence = sequenceHeader.getSequenceNumber() - 1;
        if (!this.senderSequenceNumber.compareAndSet(expectedSequence, sequenceHeader.getSequenceNumber())) {
            callback.completeExceptionally((Throwable)new PlcProtocolException("Lost sequence, expected " + expectedSequence + " but received " + sequenceHeader.getSequenceNumber()));
            return false;
        }
        return true;
    };

    public Conversation(ConversationContext<OpcuaAPU> context, OpcuaDriverContext driverContext, OpcuaConfiguration configuration) {
        this.context = context;
        this.tm = new SecureChannelTransactionManager();
        this.driverContext = driverContext;
        this.configuration = configuration;
        this.securityPolicy = Conversation.determineSecurityPolicy(configuration);
        CertificateKeyPair senderKeyPair = driverContext.getCertificateKeyPair();
        if (this.securityPolicy != SecurityPolicy.NONE) {
            this.messageSecurity = configuration.getMessageSecurity();
            this.remoteCertificate = configuration.getServerCertificate();
            this.encryptionHandler = new EncryptionHandler(this, senderKeyPair.getPrivateKey());
            this.localCertificate = senderKeyPair.getCertificate();
            this.localNonce = this.createNonce();
        } else {
            this.messageSecurity = MessageSecurity.NONE;
            this.encryptionHandler = new EncryptionHandler(this, null);
        }
        Limits encodingLimits = configuration.getEncodingLimits();
        this.limits = new OpcuaProtocolLimits(encodingLimits.getReceiveBufferSize(), encodingLimits.getSendBufferSize(), encodingLimits.getMaxMessageSize(), encodingLimits.getMaxChunkCount());
    }

    public CompletableFuture<OpcuaAcknowledgeResponse> requestHello() {
        this.logger.debug("Sending hello message to {}", (Object)this.driverContext.getEndpoint());
        OpcuaHelloRequest request = new OpcuaHelloRequest(ChunkType.FINAL, OpcuaConstants.PROTOCOLVERSION.shortValue(), new OpcuaProtocolLimits(this.limits.getReceiveBufferSize(), this.limits.getSendBufferSize(), this.limits.getMaxMessageSize(), this.limits.getMaxChunkCount()), new PascalString(this.driverContext.getEndpoint()));
        CompletableFuture<OpcuaAcknowledgeResponse> future = new CompletableFuture<OpcuaAcknowledgeResponse>();
        this.sendRequest(request, future, this.configuration.getNegotiationTimeout()).unwrap(OpcuaAPU::getMessage).check(OpcuaAcknowledgeResponse.class::isInstance).unwrap(OpcuaAcknowledgeResponse.class::cast).handle(opcuaAcknowledgeResponse -> {
            OpcuaProtocolLimits limits = opcuaAcknowledgeResponse.getLimits();
            this.limits = new OpcuaProtocolLimits(Math.min(this.limits.getReceiveBufferSize(), limits.getSendBufferSize()), Math.min(this.limits.getSendBufferSize(), limits.getReceiveBufferSize()), Math.min(this.limits.getMaxMessageSize(), limits.getMaxMessageSize()), Math.min(this.limits.getMaxChunkCount(), limits.getMaxChunkCount()));
            future.complete((OpcuaAcknowledgeResponse)opcuaAcknowledgeResponse);
        });
        return future;
    }

    public CompletableFuture<OpcuaOpenResponse> requestChannelOpen(Function<CallContext, OpcuaOpenRequest> request) {
        return this.request(OpcuaOpenResponse.class, request, (rsp, chunk) -> new OpcuaOpenResponse(rsp.getChunk(), rsp.getOpenResponse(), (Payload)chunk), rsp -> rsp.getMessage().getSequenceHeader(), OpcuaOpenResponse::getMessage);
    }

    public CompletableFuture<Void> requestChannelClose(Function<CallContext, OpcuaCloseRequest> request) {
        this.logger.trace("Got close secure channel request");
        return ((CompletableFuture)this.request(OpcuaMessageResponse.class, request, (rsp, chunk) -> new OpcuaMessageResponse(rsp.getChunk(), rsp.getSecurityHeader(), (Payload)chunk), rsp -> rsp.getMessage().getSequenceHeader(), OpcuaMessageResponse::getMessage).whenComplete((r, e) -> this.context.fireDisconnected())).thenApply(r -> null);
    }

    private <T extends MessagePDU, R extends MessagePDU> CompletableFuture<R> request(Class<R> replyType, Function<CallContext, T> request, BiFunction<R, BinaryPayload, R> chunkAssembler, Function<R, SequenceHeader> sequenceHeaderExtractor, Function<R, Payload> chunkExtractor) {
        int requestId = this.tm.getTransactionIdentifier();
        this.logger.debug("Firing request {}", (Object)requestId);
        MessagePDU messagePDU = (MessagePDU)request.apply(new CallContext(this.securityHeader.get(), this.tm.getSequenceSupplier(), requestId));
        MemoryChunkStorage chunkStorage = new MemoryChunkStorage();
        List<MessagePDU> chunks = this.encryptionHandler.encodeMessage(messagePDU, this.tm.getSequenceSupplier());
        CompletableFuture future = new CompletableFuture();
        int count = chunks.size();
        int index = 0;
        while (index < count) {
            boolean last;
            boolean bl = last = index + 1 == count;
            if (last) {
                this.sendRequest(chunks.get(index), future, this.configuration.getNegotiationTimeout()).unwrap(OpcuaAPU::getMessage).check(replyType::isInstance).unwrap(replyType::cast).unwrap(msg -> this.encryptionHandler.decodeMessage((MessagePDU)msg)).check(replyType::isInstance).unwrap(replyType::cast).check(reply -> requestId == ((SequenceHeader)sequenceHeaderExtractor.apply(reply)).getRequestId()).check(reply -> this.sequenceValidator.test((SequenceHeader)sequenceHeaderExtractor.apply(reply), future)).check(msg -> this.accumulateChunkUntilFinal(chunkStorage, msg.getChunk(), (Payload)chunkExtractor.apply(msg))).unwrap(msg -> this.mergeChunks(chunkStorage, msg, (SequenceHeader)sequenceHeaderExtractor.apply(msg), chunkAssembler)).handle(response -> future.complete(response));
            } else {
                this.context.sendToWire((Object)new OpcuaAPU(chunks.get(index)));
            }
            ++index;
        }
        return future;
    }

    public <T extends ExtensionObjectDefinition, R extends ExtensionObjectDefinition> CompletableFuture<R> submit(T object, Class<R> replyType) {
        return this.submit(object).thenApply(response -> {
            if (replyType.isInstance(response)) {
                return (ExtensionObjectDefinition)replyType.cast(response);
            }
            throw new IllegalStateException("Received reply of unexpected type " + response.getClass().getName() + " while " + replyType.getName() + " has been expected");
        });
    }

    private CompletableFuture<Object> submit(ExtensionObjectDefinition requestDefinition) {
        Integer requestId = this.tm.getTransactionIdentifier();
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(requestDefinition.getIdentifier())), null, null);
        ExtensionObject requestObject = new ExtensionObject(expandedNodeId, null, requestDefinition);
        ExtensiblePayload payload = new ExtensiblePayload(new SequenceHeader(this.tm.getSequenceSupplier().get(), requestId), requestObject);
        MemoryChunkStorage chunkStorage = new MemoryChunkStorage();
        SecurityHeader securityHeaderValue = this.securityHeader.get();
        OpcuaMessageRequest request = new OpcuaMessageRequest(ChunkType.FINAL, securityHeaderValue, payload);
        this.logger.debug("Submitting Transaction to TransactionManager {}, security channel {}, token {}", new Object[]{requestId, securityHeaderValue.getSecureChannelId(), securityHeaderValue.getSecureTokenId()});
        List<MessagePDU> chunks = this.encryptionHandler.encodeMessage(request, this.tm.getSequenceSupplier());
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        int count = chunks.size();
        int index = 0;
        while (index < count) {
            boolean last;
            boolean bl = last = index + 1 == count;
            if (last) {
                BiFunction<OpcuaMessageResponse, BinaryPayload, OpcuaMessageResponse> chunkAssembler = (src, chunkPayload) -> new OpcuaMessageResponse(src.getChunk(), src.getSecurityHeader(), (Payload)chunkPayload);
                this.sendRequest(chunks.get(index), future, this.configuration.getRequestTimeout()).unwrap(OpcuaAPU::getMessage).check(OpcuaMessageResponse.class::isInstance).unwrap(OpcuaMessageResponse.class::cast).unwrap(msg -> this.encryptionHandler.decodeMessage((MessagePDU)msg)).check(OpcuaMessageResponse.class::isInstance).unwrap(OpcuaMessageResponse.class::cast).check(OpcuaMessageResponse.class::isInstance).unwrap(OpcuaMessageResponse.class::cast).check(msg -> msg.getMessage().getSequenceHeader().getRequestId() == requestId.intValue()).check(reply -> this.sequenceValidator.test(reply.getMessage().getSequenceHeader(), future)).check(msg -> this.accumulateChunkUntilFinal(chunkStorage, msg.getChunk(), msg.getMessage())).unwrap(msg -> this.mergeChunks(chunkStorage, msg, msg.getMessage().getSequenceHeader(), chunkAssembler)).handle(response -> {
                    if (response.getChunk().equals((Object)ChunkType.FINAL)) {
                        ExtensionObjectDefinition extensionObjectBody;
                        this.logger.debug("Received response made of {} bytes for message id: {}, channel id:{}, token:{}", new Object[]{response.getLengthInBytes(), requestId, response.getSecurityHeader().getSecureChannelId(), response.getSecurityHeader().getSecureTokenId()});
                        this.securityHeader.set(response.getSecurityHeader());
                        Payload message = response.getMessage();
                        if (message instanceof ExtensiblePayload) {
                            extensionObjectBody = ((ExtensiblePayload)message).getPayload().getBody();
                        } else {
                            try {
                                BinaryPayload binary = (BinaryPayload)message;
                                ReadBufferByteBased buffer = new ReadBufferByteBased(binary.getPayload(), ByteOrder.LITTLE_ENDIAN);
                                extensionObjectBody = ExtensionObject.staticParse((ReadBuffer)buffer, false).getBody();
                            }
                            catch (ParseException e) {
                                future.completeExceptionally(e);
                                return;
                            }
                        }
                        if (extensionObjectBody instanceof ServiceFault) {
                            ServiceFault fault = (ServiceFault)extensionObjectBody;
                            future.completeExceptionally((Throwable)Conversation.toProtocolException(fault));
                        } else {
                            future.complete(extensionObjectBody);
                        }
                    }
                });
            } else {
                this.context.sendToWire((Object)new OpcuaAPU(chunks.get(index)));
            }
            ++index;
        }
        return future;
    }

    private ConversationContext.SendRequestContext<OpcuaAPU> sendRequest(MessagePDU messagePDU, CompletableFuture<?> future, long timeout) {
        return this.context.sendRequest((Object)new OpcuaAPU(messagePDU)).onError((req, err) -> {
            boolean bl = future.completeExceptionally((Throwable)err);
        }).expectResponse(OpcuaAPU.class, Duration.ofMillis(timeout)).onTimeout(e -> {
            boolean bl = future.completeExceptionally((Throwable)e);
        });
    }

    private <T> T mergeChunks(ChunkStorage chunkStorage, T source, SequenceHeader sequenceHeader, BiFunction<T, BinaryPayload, T> producer) {
        byte[] message = chunkStorage.get();
        return producer.apply(source, new BinaryPayload(sequenceHeader, message));
    }

    private boolean accumulateChunkUntilFinal(ChunkStorage storage, ChunkType chunkType, Payload data) {
        if (ChunkType.ABORT.equals((Object)chunkType)) {
            storage.reset();
            return true;
        }
        if (!(data instanceof BinaryPayload)) {
            throw new IllegalArgumentException("Unexpected payload type " + data.getClass());
        }
        storage.append(((BinaryPayload)data).getPayload());
        return ChunkType.FINAL.equals((Object)chunkType);
    }

    private byte[] createNonce() {
        return this.createNonce(this.securityPolicy.getNonceLength());
    }

    byte[] createNonce(int nonceLength) {
        return RandomUtils.nextBytes((int)nonceLength);
    }

    public boolean isSymmetricEncryptionEnabled() {
        return this.messageSecurity == MessageSecurity.SIGN_ENCRYPT;
    }

    public boolean isSymmetricSigningEnabled() {
        return this.messageSecurity == MessageSecurity.SIGN_ENCRYPT || this.messageSecurity == MessageSecurity.SIGN;
    }

    static SecurityPolicy determineSecurityPolicy(OpcuaConfiguration configuration) {
        if (configuration.isDiscovery() && configuration.getServerCertificate() == null) {
            return SecurityPolicy.NONE;
        }
        return configuration.getSecurityPolicy();
    }

    static PlcProtocolException toProtocolException(ServiceFault fault) {
        if (fault.getResponseHeader() instanceof ResponseHeader) {
            ResponseHeader responseHeader = (ResponseHeader)fault.getResponseHeader();
            long statusCode = responseHeader.getServiceResult().getStatusCode();
            String statusName = OpcuaStatusCode.isDefined(statusCode) != false ? OpcuaStatusCode.enumForValue(statusCode).name() : "<unknown>";
            return new PlcProtocolException("Server returned error " + statusName + " (0x" + Long.toHexString(statusCode) + ")");
        }
        return new PlcProtocolException("Unexpected service fault");
    }

    public OpcuaProtocolLimits getLimits() {
        return this.limits;
    }

    public byte[] getLocalNonce() {
        return this.localNonce;
    }

    public X509Certificate getLocalCertificate() {
        return this.localCertificate;
    }

    public void setRemoteNonce(byte[] remoteNonce) {
        this.remoteNonce = remoteNonce;
    }

    public byte[] getRemoteNonce() {
        return this.remoteNonce;
    }

    public X509Certificate getRemoteCertificate() {
        return this.remoteCertificate;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public MessageSecurity getMessageSecurity() {
        return this.messageSecurity;
    }

    public byte[] encryptPassword(byte[] encodeablePassword) {
        return this.encryptionHandler.encryptPassword(encodeablePassword);
    }

    public void setSecurityHeader(SecurityHeader securityHeader) {
        this.securityHeader.set(securityHeader);
    }

    public SignatureData createClientSignature() throws GeneralSecurityException {
        return this.encryptionHandler.createClientSignature();
    }

    public void setRemoteCertificate(X509Certificate certificate) {
        this.remoteCertificate = certificate;
    }

    public RequestHeader createRequestHeader(long requestTimeout) {
        return this.createRequestHeader(requestTimeout, this.tm.getRequestHandle());
    }

    protected RequestHeader createRequestHeader(long requestTimeout, int requestHandle) {
        return new RequestHeader(new NodeId(this.authenticationToken.get()), Conversation.getCurrentDateTime(), requestHandle, 0L, SecureChannel.NULL_STRING, requestTimeout, NULL_EXTENSION_OBJECT);
    }

    public RequestHeader createRequestHeader() {
        return this.createRequestHeader(this.configuration.getRequestTimeout());
    }

    public static long getCurrentDateTime() {
        return System.currentTimeMillis() * 10000L + 116444736000000000L;
    }

    public void setAuthenticationToken(NodeIdTypeDefinition authenticationToken) {
        this.authenticationToken.set(authenticationToken);
    }
}

